/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.views.AbstractParallelElementView;
import org.eclipse.swt.widgets.Shell;

public abstract class ParallelAction
extends Action {
    protected AbstractParallelElementView view = null;

    public ParallelAction(String text, AbstractParallelElementView view) {
        this(text, 1, view);
    }

    public ParallelAction(String text, int style, AbstractParallelElementView view) {
        super(text, style);
        this.view = view;
        this.setToolTipText(text);
        this.setEnabled(false);
        this.setId(text);
    }

    public AbstractParallelElementView getViewPart() {
        return this.view;
    }

    public Shell getShell() {
        return this.view.getViewSite().getShell();
    }

    public abstract void run(IElement[] var1);

    public void run() {
        ISelection selection = this.getViewPart().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object[] objs = ((IStructuredSelection)selection).toArray();
            IElement[] elements = new IElement[objs.length];
            System.arraycopy(objs, 0, elements, 0, objs.length);
            this.run(elements);
        } else {
            this.run(new IElement[0]);
        }
    }

    protected boolean validation(IElement[] elements) {
        if (elements == null || elements.length == 0) {
            UIUtils.showErrorDialog("No selected elements", "Please select some elements first", null);
            return false;
        }
        return true;
    }
}

