/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IProcessChangeEvent;
import org.eclipse.ptp.core.elements.listeners.IProcessListener;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;

public class ParallelProcessView
extends AbstractTextEditor
implements IProcessListener {
    private Label pidLabel = null;
    private Label statusLabel = null;
    private Text outputText = null;
    private FormToolkit toolkit = null;
    private ScrolledForm myForm = null;
    private IPProcess process = null;

    public ParallelProcessView() {
        this.setDocumentProvider((IDocumentProvider)new StorageDocumentProvider());
    }

    public void dispose() {
        this.process.removeElementListener((IProcessListener)this);
        this.myForm.dispose();
        this.toolkit.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.myForm.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.setInput(input);
        Object obj = this.getEditorInput().getAdapter(IPProcess.class);
        if (obj instanceof IPProcess) {
            this.process = (IPProcess)obj;
            this.process.addElementListener((IProcessListener)this);
        }
    }

    public void close() {
        if (this.process != null) {
            this.process.removeElementListener((IProcessListener)this);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (ParallelProcessView.this.toolkit != null) {
                    ParallelProcessView.this.getSite().getPage().closeEditor((IEditorPart)ParallelProcessView.this, false);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.myForm = this.toolkit.createScrolledForm(parent);
        this.myForm.getBody().setLayout((Layout)this.createGridLayout(1, false, 5, 5));
        this.myForm.getBody().setLayoutData((Object)new GridData(768));
        this.detailsSection();
        this.outputSection();
        this.initialText();
    }

    protected void detailsSection() {
        Section detailsSection = this.toolkit.createSection(this.myForm.getBody(), 256);
        detailsSection.setText("Process details");
        detailsSection.setLayoutData((Object)new GridData(768));
        Composite detailsContainer = this.createClientContainer((Composite)detailsSection, this.toolkit, 3, true, 2, 2);
        this.pidLabel = this.toolkit.createLabel(detailsContainer, null);
        this.pidLabel.setLayoutData((Object)new GridData(768));
        Composite statusContainer = this.createClientContainer(detailsContainer, this.toolkit, 3, true, 0, 0);
        statusContainer.setLayoutData((Object)this.spanGridData(768, 3));
        this.statusLabel = this.toolkit.createLabel(statusContainer, null);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        detailsSection.setClient((Control)detailsContainer);
    }

    protected void outputSection() {
        Section outputSection = this.toolkit.createSection(this.myForm.getBody(), 258);
        outputSection.setText("Program output");
        outputSection.setLayoutData((Object)new GridData(1808));
        outputSection.setExpanded(true);
        Composite ouputContainer = this.createClientContainer((Composite)outputSection, this.toolkit, 1, true, 2, 2);
        this.outputText = this.toolkit.createText(ouputContainer, null, 586);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.outputText.setLayoutData((Object)gd);
        outputSection.setClient((Control)ouputContainer);
        this.toolkit.paintBordersFor(ouputContainer);
    }

    protected Composite createClientContainer(Composite parent, FormToolkit toolkit, int columns, boolean isEqual, int mh, int mw) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)this.createGridLayout(columns, isEqual, mh, mw));
        return container;
    }

    public void initialText() {
        this.pidLabel.setText("PID: N/A");
        this.statusLabel.setText("Status: N/A");
        this.outputText.setText("N/A");
        if (this.process != null) {
            this.pidLabel.setText("PID: " + this.process.getPid());
            this.statusLabel.setText("Status: " + this.process.getState());
            this.outputText.setText(this.process.getSavedOutput(ProcessAttributes.getStdoutAttributeDefinition()));
        }
    }

    public void handleEvent(final IProcessChangeEvent e) {
        UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

            public void run() {
                StringAttribute stdoutAttr;
                EnumeratedAttribute stateAttr = (EnumeratedAttribute)e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStateAttributeDefinition());
                if (stateAttr != null) {
                    ProcessAttributes.State state = (ProcessAttributes.State)stateAttr.getValue();
                    ParallelProcessView.this.statusLabel.setText("Status: " + state.toString());
                }
                if ((stdoutAttr = (StringAttribute)e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStdoutAttributeDefinition())) != null) {
                    ParallelProcessView.this.outputText.append(String.valueOf(stdoutAttr.getValue()) + "\n");
                }
            }
        });
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updateStatusField(String category) {
        if (category == null) {
            return;
        }
        IStatusField field = this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("InputPosition".equals(category)) {
                text = this.pidLabel.getText();
            } else if ("InputMode".equals(category) && this.process != null) {
                text = this.process.getState().toString();
            }
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }
}

