/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.ptp.remote.IRemoteServicesDelegate;
import org.eclipse.ptp.remote.IRemoteServicesFactory;
import org.eclipse.ptp.remote.PTPRemotePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServicesProxy
implements IRemoteServices {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private boolean initialized;
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private IRemoteServicesFactory factory;
    private IRemoteServicesDelegate delegate;

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public RemoteServicesProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = RemoteServicesProxy.getAttribute(configElement, ATTR_ID, null);
        this.name = RemoteServicesProxy.getAttribute(configElement, ATTR_NAME, this.id);
        RemoteServicesProxy.getAttribute(configElement, ATTR_CLASS, null);
        this.factory = null;
        this.delegate = null;
        this.initialized = false;
    }

    @Override
    public IRemoteConnectionManager getConnectionManager() {
        this.loadServices();
        return this.delegate.getConnectionManager();
    }

    public IRemoteServicesFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            this.factory = (IRemoteServicesFactory)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {
            PTPRemotePlugin.log("Failed to instatiate factory: " + this.configElement.getAttribute(ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespaceIdentifier());
        }
        return this.factory;
    }

    @Override
    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        this.loadServices();
        return this.delegate.getFileManager(conn);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        this.loadServices();
        return this.delegate.getProcessBuilder(conn, command);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        this.loadServices();
        return this.delegate.getProcessBuilder(conn, command);
    }

    @Override
    public boolean initialize() {
        this.loadServices();
        return this.initialized;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void loadServices() {
        IRemoteServicesFactory factory;
        if (this.delegate == null && (factory = this.getFactory()) != null) {
            this.delegate = factory.getServices();
            if (this.delegate.initialize()) {
                this.initialized = true;
            }
        }
    }
}

