/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.remote.RemoteServicesProxy;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTPRemotePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.remote";
    public static final String EXTENSION_POINT_ID = "remoteServices";
    private static PTPRemotePlugin plugin;
    private Map<String, RemoteServicesProxy> allRemoteServices;
    private IRemoteServices defaultRemoteServices;

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPRemotePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPRemotePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Object getAdapter(Object sourceObject, Class adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    public static PTPRemotePlugin getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        if (PTPRemotePlugin.getActiveWorkbenchWindow() != null) {
            return PTPRemotePlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static String getUniqueIdentifier() {
        if (PTPRemotePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPRemotePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPRemotePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPRemotePlugin.log((IStatus)new Status(4, PTPRemotePlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        PTPRemotePlugin.log((IStatus)new Status(4, PTPRemotePlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public synchronized IRemoteServices[] getAllRemoteServices() {
        if (this.allRemoteServices == null) {
            this.allRemoteServices = this.retrieveRemoteServices();
        }
        IRemoteServices[] services = this.allRemoteServices.values().toArray(new IRemoteServices[this.allRemoteServices.size()]);
        Arrays.sort(services, new RemoteServicesSorter());
        return services;
    }

    public synchronized IRemoteServices getDefaultServices() {
        if (this.defaultRemoteServices == null) {
            IRemoteServices[] allServices = this.getAllRemoteServices();
            this.defaultRemoteServices = allServices[allServices.length - 1];
            IRemoteServices[] iRemoteServicesArray = allServices;
            int n = allServices.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteServices services = iRemoteServicesArray[n2];
                if (services.getId().equals("org.eclipse.ptp.remote.LocalServices")) {
                    this.defaultRemoteServices = services;
                    break;
                }
                ++n2;
            }
        }
        return this.defaultRemoteServices;
    }

    public synchronized IRemoteServices getRemoteServices(String id) {
        if (this.allRemoteServices == null) {
            this.allRemoteServices = this.retrieveRemoteServices();
        }
        return this.allRemoteServices.get(id);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.defaultRemoteServices = null;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private Map<String, RemoteServicesProxy> retrieveRemoteServices() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, RemoteServicesProxy> services = new HashMap<String, RemoteServicesProxy>(5);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                RemoteServicesProxy proxy = new RemoteServicesProxy(ce);
                if (proxy.initialize()) {
                    services.put(proxy.getId(), proxy);
                } else {
                    PTPRemotePlugin.log("Failed to initialize remote service: " + proxy.getId() + "(" + proxy.getName() + ")");
                }
                ++n4;
            }
            ++n2;
        }
        return services;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteServicesSorter
    implements Comparator<IRemoteServices> {
        private RemoteServicesSorter() {
        }

        @Override
        public int compare(IRemoteServices o1, IRemoteServices o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

