/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.data.DownloadRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.ISynchronizationRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.RuleFactory;
import org.eclipse.ptp.remotetools.environment.launcher.data.UploadRule;
import org.eclipse.ptp.remotetools.environment.launcher.preferences.LaunchPreferences;
import org.eclipse.ptp.remotetools.environment.launcher.ui.IRuleDialog;
import org.eclipse.ptp.remotetools.environment.launcher.ui.Messages;
import org.eclipse.ptp.remotetools.environment.launcher.ui.RuleDialogFactory;
import org.eclipse.ptp.remotetools.environment.launcher.ui.SynchronizationRuleLabelProvider;
import org.eclipse.ptp.remotetools.utils.ui.swt.Frame;
import org.eclipse.ptp.remotetools.utils.ui.swt.FrameMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EnhancedSynchronizeTab
extends AbstractLaunchConfigurationTab {
    protected Button addUploadRuleButton;
    protected Button addDownloadRuleButton;
    protected Button editRuleButton;
    protected Button removeRuleButton;
    protected org.eclipse.swt.widgets.List ruleList;
    protected ListViewer ruleViewer;
    protected Button syncBeforeButton;
    protected Button syncAfterButton;
    protected ArrayList rules = new ArrayList();
    protected SynchronizationRuleLabelProvider ruleLabelProvider;
    boolean dataChanged = false;
    int eventHandlerEnabled = 0;
    Image tabImage;
    protected TabModifyListener modifyListener;

    public EnhancedSynchronizeTab() {
        URL url = RemoteLauncherPlugin.getDefault().getBundle().getEntry("/icons/sync.png");
        if (url != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            this.tabImage = imageDescriptor.createImage();
        }
    }

    protected void enableEventHandlers() {
        ++this.eventHandlerEnabled;
    }

    protected void disableEventHandlers() {
        --this.eventHandlerEnabled;
    }

    protected boolean isEventHandlerEnabled() {
        return this.eventHandlerEnabled > 0;
    }

    public void createControl(Composite parent) {
        this.setErrorMessage(null);
        this.setMessage(Messages.EnhancedSynchronizeTab_Tab_Message);
        Composite topControl = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        Frame frame = new Frame(topControl, Messages.EnhancedSynchronizeTab_RulesFrame_Title);
        frame.setLayoutData((Object)new GridData(1808));
        Composite frameComposite = frame.getComposite();
        this.modifyListener = new TabModifyListener();
        this.createRuleListControl(frameComposite);
        this.createOptionsControl(frameComposite);
        this.createButtonControl(frameComposite);
        this.enableEventHandlers();
    }

    protected Composite createRuleListControl(Composite parent) {
        Frame frame = new Frame(parent, 1);
        frame.setLayoutData((Object)new GridData(1808));
        Composite frameComposite = frame.getComposite();
        Label label = new Label(frameComposite, 64);
        label.setText(Messages.EnhancedSynchronizeTab_RulesFrame_Description);
        label.setLayoutData((Object)new GridData(768));
        this.ruleList = new org.eclipse.swt.widgets.List(frameComposite, 770);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        this.ruleList.setLayoutData((Object)gridData);
        this.ruleList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                    return;
                }
                EnhancedSynchronizeTab.this.removeRuleButton.setEnabled(EnhancedSynchronizeTab.this.ruleList.getSelectionCount() != 0);
                EnhancedSynchronizeTab.this.editRuleButton.setEnabled(EnhancedSynchronizeTab.this.ruleList.getSelectionCount() == 1);
            }
        });
        this.ruleList.deselectAll();
        this.ruleViewer = new ListViewer(this.ruleList);
        this.ruleViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return EnhancedSynchronizeTab.this.rules.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.ruleLabelProvider = new SynchronizationRuleLabelProvider();
        this.ruleViewer.setLabelProvider((IBaseLabelProvider)this.ruleLabelProvider);
        this.ruleViewer.setInput((Object)this.rules);
        return frame;
    }

    protected Composite createOptionsControl(Composite parent) {
        Frame frame = new Frame(parent, FrameMold.COLUMNS_EQUAL_WIDTH, 2);
        Composite frameComposite = frame.getComposite();
        this.syncBeforeButton = this.createCheckButton(frameComposite, Messages.EnhancedSynchronizeTab_RulesFrame_Options_UploadEnabled);
        this.syncBeforeButton.setLayoutData((Object)new GridData(768));
        this.syncBeforeButton.addSelectionListener((SelectionListener)this.modifyListener);
        this.syncAfterButton = this.createCheckButton(frameComposite, Messages.EnhancedSynchronizeTab_RulesFrame_Options_DownloadEnabled);
        this.syncAfterButton.addSelectionListener((SelectionListener)this.modifyListener);
        this.syncAfterButton.setLayoutData((Object)new GridData(768));
        return frame;
    }

    protected Composite createButtonControl(Composite parent) {
        Frame frame = new Frame(parent, FrameMold.COLUMNS_EQUAL_WIDTH, 4);
        Composite frameComposite = frame.getComposite();
        this.addUploadRuleButton = new Button(frameComposite, 8);
        this.addUploadRuleButton.setText(Messages.EnhancedSynchronizeTab_RulesFrame_Actions_NewUploadRule);
        this.addUploadRuleButton.setLayoutData((Object)new GridData(768));
        this.addUploadRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                    return;
                }
                EnhancedSynchronizeTab.this.handleAddUploadRuleButtonPressed();
            }
        });
        this.addDownloadRuleButton = new Button(frameComposite, 8);
        this.addDownloadRuleButton.setText(Messages.EnhancedSynchronizeTab_RulesFrame_Actions_DownloadRule);
        this.addDownloadRuleButton.setLayoutData((Object)new GridData(768));
        this.addDownloadRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                    return;
                }
                EnhancedSynchronizeTab.this.handleAddDownloadRuleButtonPressed();
            }
        });
        this.editRuleButton = new Button(frameComposite, 8);
        this.editRuleButton.setText(Messages.EnhancedSynchronizeTab_RulesFrame_Actions_EditSelectedRule);
        this.editRuleButton.setLayoutData((Object)new GridData(768));
        this.editRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                    return;
                }
                EnhancedSynchronizeTab.this.handleEditRuleButtonPressed();
            }
        });
        this.editRuleButton.setEnabled(false);
        this.removeRuleButton = new Button(frameComposite, 8);
        this.removeRuleButton.setText(Messages.EnhancedSynchronizeTab_RulesFrame_Actions_RemoveSelectedRules);
        this.removeRuleButton.setLayoutData((Object)new GridData(768));
        this.removeRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                    return;
                }
                EnhancedSynchronizeTab.this.handleRemoveRuleButtonPressed();
            }
        });
        this.removeRuleButton.setEnabled(false);
        return frame;
    }

    public boolean isValid(ILaunchConfiguration config) {
        return super.isValid(config);
    }

    public boolean canSave() {
        return super.canSave() || this.dataChanged;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_AFTER", true);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_BEFORE", true);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_RULES", new ArrayList());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.dataChanged = false;
        try {
            this.syncAfterButton.setSelection(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_AFTER", true));
            this.syncBeforeButton.setSelection(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_BEFORE", true));
            List list = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_RULES", new ArrayList());
            this.rules.clear();
            for (String string : list) {
                ISynchronizationRule rule = RuleFactory.createRuleFromString(string);
                this.rules.add(rule);
            }
            String defaultRemoteWorkingDirectory = LaunchPreferences.getPreferenceStore().getString("org.eclipse.ptp.remotetools.environment.launcher.preferences-working-directory");
            if (configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AUTO_REMOTE_DIRECTORY", true)) {
                this.ruleLabelProvider.setRemoteWorkingDir(defaultRemoteWorkingDirectory);
            } else {
                this.ruleLabelProvider.setRemoteWorkingDir(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.REMOTE_DIRECTORY", defaultRemoteWorkingDirectory));
            }
            this.refreshRuleList();
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedString((String)"Launch.common.Exception_occurred_reading_configuration_EXCEPTION", (String)e.getStatus().getMessage()));
            LaunchUIPlugin.log((Throwable)e);
        }
    }

    private void refreshRuleList() {
        this.ruleViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_AFTER", this.syncAfterButton.getSelection());
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_BEFORE", this.syncBeforeButton.getSelection());
        ArrayList<String> list = new ArrayList<String>();
        for (ISynchronizationRule rule : this.rules) {
            list.add(rule.toString());
        }
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.SYNC_RULES", list);
        this.dataChanged = false;
    }

    public String getName() {
        return Messages.EnhancedSynchronizeTab_Tab_Title;
    }

    public Image getImage() {
        return this.tabImage;
    }

    protected void handleAddUploadRuleButtonPressed() {
        UploadRule uploadRule = new UploadRule();
        uploadRule.setDefaultRemoteDirectory(true);
        uploadRule.setRemoteDirectory(null);
        uploadRule.setOverwritePolicy(2);
        this.newRuleDialog(uploadRule);
    }

    protected void handleAddDownloadRuleButtonPressed() {
        DownloadRule downloadRule = new DownloadRule();
        downloadRule.setOverwritePolicy(2);
        this.newRuleDialog(downloadRule);
    }

    protected void newRuleDialog(ISynchronizationRule rule) {
        Dialog dialog = RuleDialogFactory.createDialogForRule(this.getShell(), rule);
        if (dialog != null) {
            if (dialog.open() == 0) {
                IRuleDialog ruleDialog = (IRuleDialog)dialog;
                ISynchronizationRule newRule = RuleFactory.duplicateRule(ruleDialog.getRuleWorkingCopy());
                this.rules.add(newRule);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EnhancedSynchronizeTab_ErrorMessage_NewRule_Title, (String)Messages.EnhancedSynchronizeTab_ErrorMessage_NewRule_DontKnowRuleType);
        }
        this.refreshRuleList();
        this.dataChanged = true;
        this.updateLaunchConfigurationDialog();
    }

    protected void handleEditRuleButtonPressed() {
        if (this.ruleList.getSelectionCount() != 1) {
            return;
        }
        int index = this.ruleList.getSelectionIndex();
        ISynchronizationRule rule = (ISynchronizationRule)this.rules.get(index);
        Dialog dialog = RuleDialogFactory.createDialogForRule(this.getShell(), rule);
        if (dialog != null) {
            if (dialog.open() == 0) {
                IRuleDialog ruleDialog = (IRuleDialog)dialog;
                ISynchronizationRule newRule = RuleFactory.duplicateRule(ruleDialog.getRuleWorkingCopy());
                this.rules.set(index, newRule);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EnhancedSynchronizeTab_ErrorMessage_NewRule_Title, (String)Messages.EnhancedSynchronizeTab_ErrorMessage_NewRule_DontKnowRuleType);
        }
        this.refreshRuleList();
        this.dataChanged = true;
        this.updateLaunchConfigurationDialog();
    }

    protected void handleRemoveRuleButtonPressed() {
        if (this.ruleList.getSelectionCount() == 0) {
            return;
        }
        int[] indexes = this.ruleList.getSelectionIndices();
        HashSet set = new HashSet();
        int i = 0;
        while (i < indexes.length) {
            int index = indexes[i];
            set.add(this.rules.get(index));
            ++i;
        }
        this.rules.removeAll(set);
        this.refreshRuleList();
        this.dataChanged = true;
        this.updateLaunchConfigurationDialog();
    }

    public void dispose() {
        super.dispose();
        if (this.tabImage != null) {
            this.tabImage.dispose();
        }
        this.tabImage = null;
    }

    protected class TabModifyListener
    implements ModifyListener,
    SelectionListener {
        protected TabModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                return;
            }
            EnhancedSynchronizeTab.this.dataChanged = true;
            EnhancedSynchronizeTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                return;
            }
            EnhancedSynchronizeTab.this.dataChanged = true;
            EnhancedSynchronizeTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            if (!EnhancedSynchronizeTab.this.isEventHandlerEnabled()) {
                return;
            }
            EnhancedSynchronizeTab.this.dataChanged = true;
            EnhancedSynchronizeTab.this.updateLaunchConfigurationDialog();
        }
    }
}

