/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.text.MessageFormat;
import org.eclipse.ptp.remotetools.core.IRemotePortForwarding;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;

public class RemotePortForwarding
implements IRemotePortForwarding {
    ExecutionManager owner;
    int localPort;
    String localAddress;
    int remotePort;

    RemotePortForwarding(ExecutionManager owner, int localPort, String localAddress, int remotePort) {
        this.owner = owner;
        this.localPort = localPort;
        this.localAddress = localAddress;
        this.remotePort = remotePort;
    }

    void releaseOwner() {
        this.owner = null;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void release() throws RemoteConnectionException, PortForwardingException, CancelException {
        if (this.owner == null) {
            throw new PortForwardingException(4);
        }
        this.owner.getPortForwardingTools().releaseForwarding(this);
    }

    public String toString() {
        return MessageFormat.format("remote port {0} to local {1}:{2}", new Integer(this.remotePort), this.localAddress, new Integer(this.localPort));
    }

    public boolean isActive() {
        return this.owner != null;
    }
}

