/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.util.RangeSet;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.IRuntimeEventListener;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeConnectedStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeErrorStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeQueueChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveAllEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRunningStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeShutdownStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeStartupErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeTerminateJobErrorEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeResourceManager
extends AbstractResourceManager
implements IRuntimeEventListener {
    private IRuntimeSystem runtimeSystem;
    private volatile RMState state;
    private String errorMessage = null;
    private final ReentrantLock stateLock = new ReentrantLock();
    private final Condition stateCondition = this.stateLock.newCondition();
    private final ReentrantLock subLock = new ReentrantLock();
    private final Condition subCondition = this.subLock.newCondition();
    private Map<String, JobSubmission> jobSubmissions = new HashMap<String, JobSubmission>();

    public AbstractRuntimeResourceManager(String id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id, universe, config);
        this.state = RMState.STOPPED;
    }

    @Override
    public void handleEvent(IRuntimeAttributeDefinitionEvent e) {
        IAttributeDefinition<?, ?, ?>[] iAttributeDefinitionArray = e.getDefinitions();
        int n = iAttributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition<?, ?, ?> attr = iAttributeDefinitionArray[n2];
            this.getAttributeDefinitionManager().setAttributeDefinition(attr);
            ++n2;
        }
    }

    @Override
    public void handleEvent(IRuntimeConnectedStateEvent e) {
    }

    @Override
    public void handleEvent(IRuntimeErrorStateEvent e) {
        this.subLock.lock();
        try {
            for (JobSubmission sub : this.jobSubmissions.values()) {
                sub.setState(JobSubState.ERROR);
                sub.setErrorReason("Fatal error ocurred in runtime system");
            }
            this.subCondition.signalAll();
        }
        finally {
            this.subLock.unlock();
        }
        this.stateLock.lock();
        try {
            RMState oldState = this.state;
            this.state = RMState.ERROR;
            this.errorMessage = null;
            if (oldState == RMState.STOPPING) {
                this.stateCondition.signal();
            }
            this.setState(ResourceManagerAttributes.State.ERROR);
            this.cleanUp();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void handleEvent(IRuntimeJobChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPQueueControl, ArrayList<IPJobControl>> map = new HashMap<IPQueueControl, ArrayList<IPJobControl>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet jobIds = mgrEntry.getKey();
            for (String string : jobIds) {
                IPJobControl job = this.getJobControl(string);
                if (job != null) {
                    IPQueueControl queue = job.getQueueControl();
                    ArrayList<IPJobControl> changedJobs = (ArrayList<IPJobControl>)map.get(queue);
                    if (changedJobs == null) {
                        changedJobs = new ArrayList<IPJobControl>();
                        map.put(queue, changedJobs);
                    }
                    changedJobs.add(job);
                    continue;
                }
                PTPCorePlugin.log("JobChange: unknown node " + string);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateJobs((IPQueueControl)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMachineChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPMachineControl> machines = new ArrayList<IPMachineControl>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            for (String elementId : machineIds) {
                IPMachineControl machine = this.getMachineControl(elementId);
                if (machine != null) {
                    machines.add(machine);
                    continue;
                }
                System.out.println("MachineChange: unknown machine " + elementId);
            }
            this.doUpdateMachines(machines, attrs);
            machines.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMessageEvent e) {
        e.getLevel();
    }

    @Override
    public void handleEvent(IRuntimeNewJobEvent e) {
        IPQueueControl queue = this.getQueueControl(e.getParentId());
        if (queue != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager jobAttrs = entry.getValue();
                RangeSet jobIds = entry.getKey();
                ArrayList<IPJobControl> newJobs = new ArrayList<IPJobControl>(jobIds.size());
                for (String elementId : jobIds) {
                    IPJobControl job = this.getJobControl(elementId);
                    if (job != null) continue;
                    job = this.doCreateJob(queue, elementId, jobAttrs);
                    newJobs.add(job);
                    StringAttribute jobSubAttr = (StringAttribute)jobAttrs.getAttribute(JobAttributes.getSubIdAttributeDefinition());
                    if (jobSubAttr == null) continue;
                    this.subLock.lock();
                    try {
                        JobSubmission sub = this.jobSubmissions.get(jobSubAttr.getValue());
                        if (sub == null || sub.getState() != JobSubState.SUBMITTED) continue;
                        sub.setJob(job);
                        job.setLaunchConfiguration(sub.getLaunchConfiguration());
                        sub.setState(JobSubState.COMPLETED);
                        this.subCondition.signalAll();
                    }
                    finally {
                        this.subLock.unlock();
                    }
                }
                this.addJobs(queue, newJobs);
            }
        } else {
            PTPCorePlugin.log("IRuntimeEventListener#handleEvent: unknown queue ID " + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewMachineEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            ArrayList<IPMachineControl> newMachines = new ArrayList<IPMachineControl>(machineIds.size());
            for (String elementId : machineIds) {
                IPMachineControl machine = this.getMachineControl(elementId);
                if (machine != null) continue;
                machine = this.doCreateMachine(elementId, attrs);
                newMachines.add(machine);
            }
            this.addMachines(newMachines);
        }
    }

    @Override
    public void handleEvent(IRuntimeNewNodeEvent e) {
        IPMachineControl machine = this.getMachineControl(e.getParentId());
        if (machine != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet nodeIds = entry.getKey();
                ArrayList<IPNodeControl> newNodes = new ArrayList<IPNodeControl>(nodeIds.size());
                for (String elementId : nodeIds) {
                    IPNodeControl node = this.getNodeControl(elementId);
                    if (node != null) continue;
                    node = this.doCreateNode(machine, elementId, attrs);
                    newNodes.add(node);
                }
                this.addNodes(machine, newNodes);
            }
        } else {
            PTPCorePlugin.log("IRuntimeEventListener#handleEvent: unknown machine ID " + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewProcessEvent e) {
        IPJobControl job = this.getJobControl(e.getParentId());
        if (job != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet processIds = entry.getKey();
                ArrayList<IPProcessControl> newProcesses = new ArrayList<IPProcessControl>(processIds.size());
                for (String elementId : processIds) {
                    IPProcessControl process = this.getProcessControl(elementId);
                    if (process != null) continue;
                    process = this.doCreateProcess(job, elementId, attrs);
                    newProcesses.add(process);
                }
                this.addProcesses(job, newProcesses);
            }
        } else {
            PTPCorePlugin.log("IRuntimeEventListener#handleEvent: unknown job ID " + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewQueueEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            ArrayList<IPQueueControl> newQueues = new ArrayList<IPQueueControl>(queueIds.size());
            for (String elementId : queueIds) {
                IPQueueControl queue = this.getQueueControl(elementId);
                if (queue != null) continue;
                queue = this.doCreateQueue(elementId, attrs);
                newQueues.add(queue);
            }
            this.addQueues(newQueues);
        }
    }

    @Override
    public void handleEvent(IRuntimeNodeChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPMachineControl, ArrayList<IPNodeControl>> map = new HashMap<IPMachineControl, ArrayList<IPNodeControl>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet nodeIds = mgrEntry.getKey();
            for (String string : nodeIds) {
                IPNodeControl node = this.getNodeControl(string);
                if (node != null) {
                    IPMachineControl machine = node.getMachineControl();
                    ArrayList<IPNodeControl> changedNodes = (ArrayList<IPNodeControl>)map.get(machine);
                    if (changedNodes == null) {
                        changedNodes = new ArrayList<IPNodeControl>();
                        map.put(machine, changedNodes);
                    }
                    changedNodes.add(node);
                    continue;
                }
                PTPCorePlugin.log("NodeChange: unknown node " + string);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateNodes((IPMachineControl)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeProcessChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPJobControl, ArrayList<IPProcessControl>> map = new HashMap<IPJobControl, ArrayList<IPProcessControl>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet processIds = mgrEntry.getKey();
            for (String string : processIds) {
                IPProcessControl process = this.getProcessControl(string);
                if (process != null) {
                    IPJobControl job = process.getJobControl();
                    ArrayList<IPProcessControl> changedProcesses = (ArrayList<IPProcessControl>)map.get(job);
                    if (changedProcesses == null) {
                        changedProcesses = new ArrayList<IPProcessControl>();
                        map.put(job, changedProcesses);
                    }
                    changedProcesses.add(process);
                    continue;
                }
                PTPCorePlugin.log("ProcessChange: unknown process " + string);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateProcesses((IPJobControl)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeQueueChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPQueueControl> queues = new ArrayList<IPQueueControl>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            for (String elementId : queueIds) {
                IPQueueControl queue = this.getQueueControl(elementId);
                if (queue != null) {
                    queues.add(queue);
                    continue;
                }
                PTPCorePlugin.log("QueueChange: unknown queue " + elementId);
            }
            this.doUpdateQueues(queues, attrs);
            queues.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveAllEvent e) {
        this.cleanUp();
    }

    @Override
    public void handleEvent(IRuntimeRemoveJobEvent e) {
        HashMap<IPQueueControl, ArrayList<IPJobControl>> map = new HashMap<IPQueueControl, ArrayList<IPJobControl>>();
        for (String string : e.getElementIds()) {
            IPJobControl job = this.getJobControl(string);
            if (job == null) continue;
            IPQueueControl queue = job.getQueueControl();
            ArrayList<IPJobControl> jobs = (ArrayList<IPJobControl>)map.get(queue);
            if (jobs == null) {
                jobs = new ArrayList<IPJobControl>();
                map.put(queue, jobs);
            }
            jobs.add(job);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeJobs((IPQueueControl)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveMachineEvent e) {
        HashMap<IResourceManager, ArrayList<IPMachineControl>> map = new HashMap<IResourceManager, ArrayList<IPMachineControl>>();
        for (String string : e.getElementIds()) {
            IPMachineControl machine = this.getMachineControl(string);
            if (machine == null) continue;
            IResourceManager rm = machine.getResourceManager();
            ArrayList<IPMachineControl> machines = (ArrayList<IPMachineControl>)map.get(rm);
            if (machines == null) {
                machines = new ArrayList<IPMachineControl>();
                map.put(rm, machines);
            }
            machines.add(machine);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeMachines((IResourceManager)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveNodeEvent e) {
        HashMap<IPMachineControl, ArrayList<IPNodeControl>> map = new HashMap<IPMachineControl, ArrayList<IPNodeControl>>();
        for (String string : e.getElementIds()) {
            IPNodeControl node = this.getNodeControl(string);
            if (node == null) continue;
            IPMachineControl machine = node.getMachineControl();
            ArrayList<IPNodeControl> nodes = (ArrayList<IPNodeControl>)map.get(machine);
            if (nodes == null) {
                nodes = new ArrayList<IPNodeControl>();
                map.put(machine, nodes);
            }
            nodes.add(node);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeNodes((IPMachineControl)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveProcessEvent e) {
        HashMap<IPJobControl, ArrayList<IPProcessControl>> map = new HashMap<IPJobControl, ArrayList<IPProcessControl>>();
        for (String string : e.getElementIds()) {
            IPProcessControl process = this.getProcessControl(string);
            if (process == null) continue;
            IPJobControl job = process.getJobControl();
            ArrayList<IPProcessControl> processes = (ArrayList<IPProcessControl>)map.get(job);
            if (processes == null) {
                processes = new ArrayList<IPProcessControl>();
                map.put(job, processes);
            }
            processes.add(process);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeProcesses((IPJobControl)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveQueueEvent e) {
        HashMap<IResourceManager, ArrayList<IPQueueControl>> map = new HashMap<IResourceManager, ArrayList<IPQueueControl>>();
        for (String string : e.getElementIds()) {
            IPQueueControl queue = this.getQueueControl(string);
            if (queue == null) continue;
            IResourceManager rm = queue.getResourceManager();
            ArrayList<IPQueueControl> queues = (ArrayList<IPQueueControl>)map.get(rm);
            if (queues == null) {
                queues = new ArrayList<IPQueueControl>();
                map.put(rm, queues);
            }
            queues.add(queue);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.removeQueues((IResourceManager)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRunningStateEvent e) {
        this.stateLock.lock();
        try {
            if (this.state == RMState.STARTING) {
                this.state = RMState.STARTED;
                this.stateCondition.signal();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void handleEvent(IRuntimeShutdownStateEvent e) {
        this.stateLock.lock();
        try {
            RMState oldState = this.state;
            this.state = RMState.STOPPED;
            if (oldState == RMState.STOPPING) {
                this.stateCondition.signal();
            } else {
                this.setState(ResourceManagerAttributes.State.STOPPED);
                this.cleanUp();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void handleEvent(IRuntimeStartupErrorEvent e) {
        this.stateLock.lock();
        try {
            if (this.state == RMState.STARTING) {
                this.state = RMState.ERROR;
                this.errorMessage = e.getErrorMessage();
                this.stateCondition.signal();
                return;
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void handleEvent(IRuntimeSubmitJobErrorEvent e) {
        this.subLock.lock();
        try {
            JobSubmission sub;
            if (e.getJobSubID() != null && (sub = this.jobSubmissions.get(e.getJobSubID())) != null) {
                sub.setState(JobSubState.ERROR);
                sub.setErrorReason(e.getErrorMessage());
                this.subCondition.signalAll();
            }
        }
        finally {
            this.subLock.unlock();
        }
        this.fireError("Error while submitting job: " + e.getErrorMessage());
    }

    @Override
    public void handleEvent(IRuntimeTerminateJobErrorEvent e) {
        IPJobControl job = this.getJobControl(e.getJobID());
        String name = e.getJobID();
        if (job != null) {
            name = job.getName();
        }
        this.fireError("Error while terminating job \"" + name + "\": " + e.getErrorMessage());
    }

    private void closeConnection(IProgressMonitor monitor) {
        try {
            this.runtimeSystem.shutdown(monitor);
        }
        catch (CoreException coreException) {}
    }

    protected abstract void doAfterCloseConnection();

    protected abstract void doAfterOpenConnection();

    protected abstract void doBeforeCloseConnection();

    protected abstract void doBeforeOpenConnection();

    @Override
    protected void doCleanUp() {
        this.state = RMState.STOPPED;
    }

    protected abstract IPJobControl doCreateJob(IPQueueControl var1, String var2, AttributeManager var3);

    protected abstract IPMachineControl doCreateMachine(String var1, AttributeManager var2);

    protected abstract IPNodeControl doCreateNode(IPMachineControl var1, String var2, AttributeManager var3);

    protected abstract IPProcessControl doCreateProcess(IPJobControl var1, String var2, AttributeManager var3);

    protected abstract IPQueueControl doCreateQueue(String var1, AttributeManager var2);

    protected abstract IRuntimeSystem doCreateRuntimeSystem() throws CoreException;

    @Override
    protected void doDisableEvents() {
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected void doEnableEvents() {
    }

    @Override
    protected List<IPJobControl> doRemoveTerminatedJobs(IPQueueControl queue) {
        ArrayList<IPJobControl> terminatedJobs = new ArrayList<IPJobControl>();
        if (queue != null) {
            for (IPJobControl job : queue.getJobControls()) {
                if (!job.isTerminated()) continue;
                terminatedJobs.add(job);
            }
            queue.removeJobs(terminatedJobs);
        }
        return terminatedJobs;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doShutdown(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 7[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean doStartup(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 15[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected IPJob doSubmitJob(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.subLock.lock();
        try {
            String jobSubId = this.runtimeSystem.submitJob(attrMgr);
            JobSubmission sub = new JobSubmission();
            sub.setLaunchConfiguration(configuration);
            this.jobSubmissions.put(jobSubId, sub);
            while (!monitor.isCanceled()) {
                if (sub.getState() != JobSubState.SUBMITTED) break;
                try {
                    this.subCondition.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            IPJob job = null;
            switch (sub.getState()) {
                case SUBMITTED: {
                    break;
                }
                case COMPLETED: {
                    this.jobSubmissions.remove(jobSubId);
                    job = sub.getJob();
                    break;
                }
                case ERROR: {
                    this.jobSubmissions.remove(jobSubId);
                    throw new CoreException((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, sub.getErrorReason(), null));
                }
            }
            IPJob iPJob = job;
            return iPJob;
        }
        finally {
            this.subLock.unlock();
            monitor.done();
        }
    }

    @Override
    protected void doTerminateJob(IPJob job) throws CoreException {
        this.runtimeSystem.terminateJob(job);
    }

    protected abstract boolean doUpdateJobs(IPQueueControl var1, Collection<IPJobControl> var2, AttributeManager var3);

    protected abstract boolean doUpdateMachines(Collection<IPMachineControl> var1, AttributeManager var2);

    protected abstract boolean doUpdateNodes(IPMachineControl var1, Collection<IPNodeControl> var2, AttributeManager var3);

    protected abstract boolean doUpdateProcesses(IPJobControl var1, Collection<IPProcessControl> var2, AttributeManager var3);

    protected abstract boolean doUpdateQueues(Collection<IPQueueControl> var1, AttributeManager var2);

    protected IRuntimeSystem getRuntimeSystem() {
        return this.runtimeSystem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobSubState {
        SUBMITTED,
        COMPLETED,
        ERROR;

    }

    private class JobSubmission {
        private IPJob job = null;
        private JobSubState state = JobSubState.SUBMITTED;
        private String reason;
        private ILaunchConfiguration configuration;

        private JobSubmission() {
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return this.configuration;
        }

        public String getErrorReason() {
            return this.reason;
        }

        public IPJob getJob() {
            return this.job;
        }

        public JobSubState getState() {
            return this.state;
        }

        public void setLaunchConfiguration(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }

        public void setErrorReason(String reason) {
            this.reason = reason;
        }

        public void setJob(IPJob job) {
            this.job = job;
        }

        public void setState(JobSubState state) {
            this.state = state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RMState {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        ERROR;

    }
}

