/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.remotetools.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.environment.core.PTPTargetControl;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.swt.widgets.Shell;

public class RemoteToolsConnectionManager
implements IRemoteConnectionManager {
    private TargetTypeElement remoteHost = null;
    private Map<String, IRemoteConnection> connections = new HashMap<String, IRemoteConnection>();

    public RemoteToolsConnectionManager() {
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        for (Object obj : targetMgr.getTypeElements()) {
            TargetTypeElement element = (TargetTypeElement)obj;
            if (!element.getName().equals("Remote Host")) continue;
            this.remoteHost = element;
            break;
        }
        this.refreshConnections();
    }

    private void refreshConnections() {
        HashMap<String, IRemoteConnection> newConns = new HashMap<String, IRemoteConnection>();
        for (Object obj : this.remoteHost.getElements()) {
            ITargetElement element = (ITargetElement)obj;
            IRemoteConnection conn = this.connections.get(element.getName());
            if (conn == null) {
                try {
                    ITargetControl control = element.getControl();
                    String address = (String)element.getAttributes().get("ptp.connection-address");
                    String user = (String)element.getAttributes().get("ptp.login-username");
                    newConns.put(element.getName(), new RemoteToolsConnection(element.getName(), address, user, (PTPTargetControl)control));
                }
                catch (CoreException coreException) {}
                continue;
            }
            newConns.put(element.getName(), conn);
        }
        this.connections = newConns;
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        return this.connections.get(name);
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.connections.values().toArray(new IRemoteConnection[this.connections.size()]);
    }

    public void newConnection(Shell shell) {
        if (this.remoteHost != null) {
            EnvironmentWizard wizard = new EnvironmentWizard(this.remoteHost);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                this.refreshConnections();
            }
        }
    }

    public boolean supportsNewConnections() {
        return this.remoteHost != null;
    }
}

