/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.remote.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteProcess;
import org.eclipse.ptp.remote.rse.RSEConnection;
import org.eclipse.ptp.remote.rse.RSEProcess;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEProcessBuilder
extends AbstractRemoteProcessBuilder {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";
    private RSEConnection connection;

    public RSEProcessBuilder(IRemoteConnection conn, List<String> command) {
        super(conn, command);
        this.connection = (RSEConnection)conn;
    }

    public RSEProcessBuilder(IRemoteConnection conn, String ... command) {
        super(conn, command);
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        remoteCmd = String.valueOf(remoteCmd) + ";exit";
        IShellService shellService = this.connection.getRemoteShellService();
        if (shellService == null) {
            throw new IOException("Remote service not found");
        }
        String[] env = new String[]{};
        IHostShell hostShell = shellService.launchShell("", env, (IProgressMonitor)new NullProgressMonitor());
        hostShell.writeToShell(remoteCmd);
        HostShellProcessAdapter p = new HostShellProcessAdapter(hostShell);
        return new RSEProcess((Process)p);
    }
}

