/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IResourceManagerErrorEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.internal.core.elements.PUniverse;
import org.eclipse.ptp.internal.core.events.NewResourceManagerEvent;
import org.eclipse.ptp.internal.core.events.RemoveResourceManagerEvent;
import org.eclipse.ptp.internal.rmsystem.ResourceManagerPersistence;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;

public class ModelManager
implements IModelManager {
    public static final String EXTENSION_POINT_ID = "resourceManagers";
    private IResourceManagerFactory[] resourceManagerFactories;
    private final ListenerList resourceManagerListeners = new ListenerList();
    protected IPJob processRoot = null;
    protected IPUniverseControl universe = new PUniverse();
    protected ILaunchConfiguration config = null;

    public void addListener(IModelManagerChildListener listener) {
        this.resourceManagerListeners.add((Object)listener);
    }

    public synchronized void addResourceManager(IResourceManagerControl rm) {
        this.universe.addResourceManager(rm);
        this.fireNewResourceManager(rm);
    }

    public synchronized void addResourceManagers(IResourceManagerControl[] rms) {
        IResourceManagerControl[] iResourceManagerControlArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            this.addResourceManager(rm);
            ++n2;
        }
    }

    public IResourceManagerFactory[] getResourceManagerFactories() {
        if (this.resourceManagerFactories != null) {
            return this.resourceManagerFactories;
        }
        ArrayList<AbstractResourceManagerFactory> factoryList = new ArrayList<AbstractResourceManagerFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PTPCorePlugin.getUniqueIdentifier(), EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractResourceManagerFactory factory = (AbstractResourceManagerFactory)ce.createExecutableExtension("class");
                    factory.setId(ce.getAttribute("id"));
                    factoryList.add(factory);
                }
                catch (CoreException e) {
                    PTPCorePlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
        this.resourceManagerFactories = factoryList.toArray(new IResourceManagerFactory[factoryList.size()]);
        return this.resourceManagerFactories;
    }

    public IResourceManagerFactory getResourceManagerFactory(String id) {
        IResourceManagerFactory[] factories = this.getResourceManagerFactories();
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(id)) {
                return factories[i];
            }
            ++i;
        }
        throw new RuntimeException("Unable to find resource manager factory");
    }

    public IResourceManager getResourceManagerFromUniqueName(String rmUniqueName) {
        IPUniverse universe = this.getUniverse();
        if (universe != null) {
            IResourceManager[] rms;
            IResourceManager[] iResourceManagerArray = rms = this.getStartedResourceManagers(universe);
            int n = rms.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                if (rm.getUniqueName().equals(rmUniqueName)) {
                    return rm;
                }
                ++n2;
            }
        }
        return null;
    }

    public IResourceManager[] getStartedResourceManagers(IPUniverse universe) {
        IResourceManager[] rms = universe.getResourceManagers();
        ArrayList<IResourceManager> startedRMs = new ArrayList<IResourceManager>(rms.length);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED) {
                startedRMs.add(rm);
            }
            ++n2;
        }
        return startedRMs.toArray(new IResourceManager[startedRMs.size()]);
    }

    public IPUniverse getUniverse() {
        return this.universe;
    }

    public void handleEvent(IResourceManagerErrorEvent e) {
    }

    public void loadResourceManagers() throws CoreException {
        ResourceManagerPersistence rmp = new ResourceManagerPersistence();
        rmp.loadResourceManagers(this.getResourceManagersFile(), this.getResourceManagerFactories());
        IResourceManagerControl[] resourceManagers = rmp.getResourceManagerControls();
        IResourceManagerControl[] rmsNeedStarting = rmp.getResourceManagerControlsNeedStarting();
        this.addResourceManagers(resourceManagers);
        this.startResourceManagers(rmsNeedStarting);
    }

    public void removeListener(IModelManagerChildListener listener) {
        this.resourceManagerListeners.remove((Object)listener);
    }

    public synchronized void removeResourceManager(IResourceManagerControl rm) {
        this.universe.removeResourceManager(rm);
        this.fireRemoveResourceManager(rm);
    }

    public synchronized void removeResourceManagers(IResourceManagerControl[] rms) {
        IResourceManagerControl[] iResourceManagerControlArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            this.removeResourceManager(rm);
            ++n2;
        }
    }

    public void saveResourceManagers() {
        ResourceManagerPersistence.saveResourceManagers(this.getResourceManagersFile(), this.universe.getResourceManagerControls());
    }

    public void shutdown() throws CoreException {
        this.saveResourceManagers();
        this.stopResourceManagers();
        this.shutdownResourceManagers();
        this.resourceManagerListeners.clear();
    }

    public void start() throws CoreException {
        this.loadResourceManagers();
    }

    public void stopResourceManagers() throws CoreException {
        IResourceManager[] resourceManagers = this.universe.getResourceManagers();
        int i = 0;
        while (i < resourceManagers.length) {
            resourceManagers[i].shutdown();
            ++i;
        }
    }

    private void fireNewResourceManager(IResourceManager rm) {
        NewResourceManagerEvent event = new NewResourceManagerEvent(this, rm);
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModelManagerChildListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireRemoveResourceManager(IResourceManager rm) {
        RemoveResourceManagerEvent event = new RemoveResourceManagerEvent(this, rm);
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModelManagerChildListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private File getResourceManagersFile() {
        PTPCorePlugin plugin = PTPCorePlugin.getDefault();
        return plugin.getStateLocation().append("resourceManagers.xml").toFile();
    }

    private synchronized void shutdownResourceManagers() {
        IResourceManagerControl[] resourceManagers = this.universe.getResourceManagerControls();
        int i = 0;
        while (i < resourceManagers.length) {
            resourceManagers[i].dispose();
            ++i;
        }
    }

    private void startResourceManagers(IResourceManagerControl[] rmsNeedStarting) throws CoreException {
        IResourceManagerControl[] iResourceManagerControlArray = rmsNeedStarting;
        int n = rmsNeedStarting.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManagerControl rm = iResourceManagerControlArray[n2];
            RMStartupJob job = new RMStartupJob(rm);
            job.schedule();
            ++n2;
        }
    }

    private class RMStartupJob
    extends Job {
        private IResourceManagerControl resourceManager;

        public RMStartupJob(IResourceManagerControl rm) {
            super("Starting Resource Manager: " + rm.getName());
            this.resourceManager = rm;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    monitor.beginTask("Starting resource manager", 100);
                    this.resourceManager.startUp((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

