/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIFunctionLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIBreakpointManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExceptionpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILineBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIWatchpoint;
import org.eclipse.ptp.debug.core.pdi.request.IPDIBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDISetWatchpointRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;
import org.eclipse.ptp.debug.internal.core.pdi.manager.PDIResources;

public class BreakpointManager
extends AbstractPDIManager
implements IPDIBreakpointManager {
    public static IPDIBreakpoint[] EMPTY_BREAKPOINTS = new IPDIBreakpoint[0];
    private static final String[] EXCEPTION_FUNCS = new String[]{"__cxa_throw", "__cxa_begin_catch"};
    private boolean allowInterrupt = true;
    private List<IPDIBreakpoint> breakList = null;
    private IPDIBreakpoint[] exceptionBps = new IPDIBreakpoint[2];
    private final int EXCEPTION_THROW_IDX = 0;
    private final int EXCEPTION_CATCH_IDX = 1;

    public BreakpointManager(IPDISession session) {
        super(session, false);
        this.breakList = Collections.synchronizedList(new ArrayList());
    }

    public void addSetBreakpoint(BitList tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isExisted(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
        breakpoint.getTasks().or(tasks);
        IPDIBreakpointRequest request = null;
        if (breakpoint instanceof IPDIFunctionBreakpoint) {
            request = this.session.getRequestFactory().getSetFunctionBreakpointRequest(tasks, (IPDIFunctionBreakpoint)breakpoint, false);
        } else if (breakpoint instanceof IPDIAddressBreakpoint) {
            request = this.session.getRequestFactory().getSetAddressBreakpointRequest(tasks, (IPDIAddressBreakpoint)breakpoint, false);
        } else if (breakpoint instanceof IPDILineBreakpoint) {
            request = this.session.getRequestFactory().getSetLineBreakpointRequest(tasks, (IPDILineBreakpoint)breakpoint, false);
        } else {
            throw new PDIException(tasks, PDIResources.getString("pdi.Common.Not_implemented"));
        }
        BitList resumeTasks = null;
        if (this.session.getStatus() == 3) {
            BitList nonTerTasks = tasks.copy();
            this.getSession().getTaskManager().getRunningTasks(nonTerTasks);
            if (!nonTerTasks.isEmpty()) {
                resumeTasks = nonTerTasks.copy();
                this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getSuspendRequest(nonTerTasks, false));
            }
        }
        this.getSession().getEventRequestManager().addEventRequest(request);
        if (resumeTasks != null) {
            this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getResumeRequest(resumeTasks, false));
        }
    }

    public IPDIAddressLocation createAddressLocation(BigInteger address) {
        return PDILocationFactory.newAddressLocation(address);
    }

    public IPDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        return this.session.getModelFactory().newCondition(ignoreCount, expression, tids);
    }

    public IPDIFunctionLocation createFunctionLocation(String file, String function) {
        return PDILocationFactory.newFunctionLocation(file, function);
    }

    public IPDILineLocation createLineLocation(String file, int line) {
        return PDILocationFactory.newLineLocation(file, line);
    }

    public void deleteAllBreakpoints() throws PDIException {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBpt = iPDIBreakpointArray[n2];
            this.deleteBreakpoint(this.session.getTasks(), pdiBpt);
            ++n2;
        }
    }

    public void deleteAllBreakpoints(BitList tasks) throws PDIException {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBpt = iPDIBreakpointArray[n2];
            if (pdiBpt.getTasks().intersects(tasks)) {
                this.deleteBreakpoint(tasks, pdiBpt);
            }
            ++n2;
        }
    }

    public void deleteBreakpoint(BitList tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isExisted(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDeleteBreakpointRequest(tasks, breakpoint, true));
        this.deleteBreakpoint(breakpoint.getBreakpointID());
    }

    public void deleteSetBreakpoint(BitList tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isExisted(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
        breakpoint.getTasks().andNot(tasks);
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDeleteBreakpointRequest(tasks, breakpoint, false));
    }

    public void disableBreakpoint(BitList tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isExisted(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
        breakpoint.setEnabled(false);
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getDisableBreakpointRequest(tasks, breakpoint));
    }

    public void enableBreakpoint(BitList tasks, IPDIBreakpoint breakpoint) throws PDIException {
        if (!this.isExisted(breakpoint.getBreakpointID())) {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
        breakpoint.setEnabled(true);
        this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getEnableBreakpointRequest(tasks, breakpoint));
    }

    public IPDIBreakpoint getBreakpoint(int id) {
        IPDIBreakpoint[] pdiBreakpoints;
        IPDIBreakpoint[] iPDIBreakpointArray = pdiBreakpoints = this.getAllPDIBreakpoints();
        int n = pdiBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIBreakpoint pdiBreakpoint = iPDIBreakpointArray[n2];
            if (pdiBreakpoint.getBreakpointID() == id) {
                return pdiBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    public IPDIAddressBreakpoint setAddressBreakpoint(BitList tasks, int type, IPDIAddressLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDIAddressBreakpoint bkpt = this.session.getModelFactory().newAddressBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public void setCondition(BitList tasks, IPDIBreakpoint breakpoint, IPDICondition newCondition) throws PDIException {
        this.deleteBreakpoint(tasks, breakpoint);
        breakpoint.setCondition(newCondition);
        if (breakpoint instanceof IPDILocationBreakpoint) {
            this.setLocationBreakpoint((IPDILocationBreakpoint)breakpoint);
        } else if (breakpoint instanceof IPDIWatchpoint) {
            this.setWatchpoint((IPDIWatchpoint)breakpoint);
        } else {
            throw new PDIException(tasks, PDIResources.getString("pdi.BreakpointManager.Not_a_PTP_breakpoint"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IPDIExceptionpoint setExceptionpoint(BitList tasks, String clazz, boolean stopOnThrow, boolean stopOnCatch, boolean enabled) throws PDIException {
        IPDIFunctionBreakpoint bp;
        IPDIFunctionLocation location;
        int id;
        IPDIBreakpoint[] iPDIBreakpointArray;
        if (!stopOnThrow && !stopOnCatch) {
            throw new PDIException(tasks, "Must suspend on throw or catch");
        }
        ArrayList<IPDIFunctionBreakpoint> funcBptList = new ArrayList<IPDIFunctionBreakpoint>(2);
        if (stopOnThrow) {
            iPDIBreakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[0] == null) {
                location = PDILocationFactory.newFunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, 0, location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                funcBptList.add(bp);
            }
            // MONITOREXIT : iPDIBreakpointArray
        }
        if (stopOnCatch) {
            iPDIBreakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[id] == null) {
                location = PDILocationFactory.newFunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, 0, location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                funcBptList.add(bp);
            }
            // MONITOREXIT : iPDIBreakpointArray
        }
        IPDIExceptionpoint excp = this.session.getModelFactory().newExceptionpoint(this.session, tasks, clazz, stopOnThrow, stopOnCatch, null, enabled, funcBptList.toArray(new IPDIFunctionBreakpoint[0]));
        this.addBreakpoint(excp);
        return excp;
    }

    public IPDIFunctionBreakpoint setFunctionBreakpoint(BitList tasks, int type, IPDIFunctionLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDIFunctionBreakpoint bkpt = this.session.getModelFactory().newFunctionBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public IPDILineBreakpoint setLineBreakpoint(BitList tasks, int type, IPDILineLocation location, IPDICondition condition, boolean deferred, boolean enabled) throws PDIException {
        IPDILineBreakpoint bkpt = this.session.getModelFactory().newLineBreakpoint(this.session, tasks, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public IPDIWatchpoint setWatchpoint(BitList tasks, int type, int watchType, String expression, IPDICondition condition, boolean enabled) throws PDIException {
        IPDIWatchpoint bkpt = this.session.getModelFactory().newWatchpoint(this.session, tasks, type, expression, watchType, condition, enabled);
        this.setWatchpoint(bkpt);
        this.addBreakpoint(bkpt);
        return bkpt;
    }

    public void shutdown() {
    }

    public void update(BitList tasks) throws PDIException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoint(IPDIBreakpoint breakpoint) {
        List<IPDIBreakpoint> list = this.breakList;
        synchronized (list) {
            if (!breakpoint.isTemporary()) {
                this.breakList.add(breakpoint);
            }
        }
    }

    private void deleteBreakpoint(int id) {
        IPDIBreakpoint[] pdiBreakpoints = this.getAllPDIBreakpoints();
        int i = 0;
        while (i < pdiBreakpoints.length) {
            if (pdiBreakpoints[i].getBreakpointID() == id) {
                this.breakList.remove(i);
                break;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPDIBreakpoint[] getAllPDIBreakpoints() {
        List<IPDIBreakpoint> list = this.breakList;
        synchronized (list) {
            return this.breakList.toArray(new IPDIBreakpoint[0]);
        }
    }

    private boolean isExisted(int id) {
        return this.getBreakpoint(id) != null;
    }

    private void setLocationBreakpoint(IPDILocationBreakpoint bkpt) throws PDIException {
        IPDIBreakpointRequest request = null;
        if (bkpt instanceof IPDIFunctionBreakpoint) {
            request = this.session.getRequestFactory().getSetFunctionBreakpointRequest(bkpt.getTasks(), (IPDIFunctionBreakpoint)bkpt, true);
        } else if (bkpt instanceof IPDIAddressBreakpoint) {
            request = this.session.getRequestFactory().getSetAddressBreakpointRequest(bkpt.getTasks(), (IPDIAddressBreakpoint)bkpt, true);
        } else if (bkpt instanceof IPDILineBreakpoint) {
            request = this.session.getRequestFactory().getSetLineBreakpointRequest(bkpt.getTasks(), (IPDILineBreakpoint)bkpt, true);
        } else {
            throw new PDIException(bkpt.getTasks(), PDIResources.getString("pdi.Common.Not_implemented"));
        }
        BitList resumeTasks = null;
        if (this.session.getStatus() == 3) {
            BitList nonTerTasks = bkpt.getTasks().copy();
            this.getSession().getTaskManager().getRunningTasks(nonTerTasks);
            if (!nonTerTasks.isEmpty()) {
                resumeTasks = nonTerTasks.copy();
                this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getSuspendRequest(nonTerTasks, false));
            }
        }
        this.getSession().getEventRequestManager().addEventRequest(request);
        if (resumeTasks != null) {
            this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getResumeRequest(resumeTasks, false));
        }
        if (!bkpt.isEnabled()) {
            this.disableBreakpoint(bkpt.getTasks(), bkpt);
        }
    }

    private void setWatchpoint(IPDIWatchpoint watchpoint) throws PDIException {
        IPDISetWatchpointRequest request = this.session.getRequestFactory().getSetWatchpointRequest(watchpoint.getTasks(), watchpoint, true);
        BitList resumeTasks = null;
        if (this.session.getStatus() == 3) {
            BitList nonTerTasks = watchpoint.getTasks().copy();
            this.getSession().getTaskManager().getRunningTasks(nonTerTasks);
            if (!nonTerTasks.isEmpty()) {
                resumeTasks = nonTerTasks.copy();
                this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getSuspendRequest(nonTerTasks, false));
            }
        }
        this.getSession().getEventRequestManager().addEventRequest(request);
        if (resumeTasks != null) {
            this.getSession().getEventRequestManager().addEventRequest(this.session.getRequestFactory().getResumeRequest(resumeTasks, false));
        }
    }

    protected void setNewLocationBreakpoint(IPDILocationBreakpoint bkpt, boolean deferred) throws PDIException {
        this.setLocationBreakpoint(bkpt);
        this.addBreakpoint(bkpt);
    }
}

