/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.verification;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class AttributeVerification {
    String pluginID = null;
    public static final int EXIST = 1;
    public static final int WRITEABLE = 2;
    public static final int DIRECTORY = 4;
    public static final int EXECUTABLE = 8;
    public static final int FILE = 16;
    public static final int EXISTING_FILE = 17;
    public static final int EXISTING_EXECUTABLE = 25;
    public static final int EXISTING_DIRECTORY = 5;

    public static IStatus createStatus(String pluginID, Throwable e, int severity, String attributeName, String message, String value) {
        if (value == null) {
            value = "no value";
        }
        String errorMessage = NLS.bind((String)"{0}: {1} ({2})", (Object[])new String[]{attributeName, message, value});
        return new Status(4, pluginID, 0, errorMessage, e);
    }

    public static void throwAttributeException(String pluginID, Throwable e, String attributeName, String message, String value) throws CoreException {
        throw new CoreException(AttributeVerification.createStatus(pluginID, e, 4, attributeName, message, value));
    }

    public static void throwAttributeException(String pluginID, String attributeName, String message, String value) throws CoreException {
        AttributeVerification.throwAttributeException(pluginID, null, attributeName, message, value);
    }

    public AttributeVerification(String pluginID) {
        this.pluginID = pluginID;
    }

    public void throwAttributeException(Throwable e, String attributeName, String message, String value) throws CoreException {
        if (value == null) {
            value = "no value";
        }
        String errorMessage = NLS.bind((String)"{0}: {1} ({2})", (Object[])new String[]{attributeName, message, value});
        throw new CoreException((IStatus)new Status(4, this.pluginID, 0, errorMessage, e));
    }

    public void throwAttributeException(String attributeName, String message, String value) throws CoreException {
        this.throwAttributeException(null, attributeName, message, value);
    }

    public IPath verifyPath(String attributeName, String stringValue) throws CoreException {
        Path path = new Path(stringValue);
        if (!path.isValidPath(stringValue)) {
            this.throwAttributeException(attributeName, "is not a valid path", stringValue);
        }
        return path;
    }

    public IStatus checkPath(String attributeName, IPath path) {
        return this.checkPath(attributeName, path, 4, 1);
    }

    public IStatus checkPath(String attributeName, IPath path, int severity) {
        return this.checkPath(attributeName, path, severity, 1);
    }

    public IStatus checkPath(String attributeName, IPath path, int severity, int options) {
        IFileStore file;
        if (!path.isAbsolute()) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "is not an absolute path", path.toOSString());
        }
        URI uri = URIUtil.toURI((IPath)path);
        try {
            file = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IFileInfo info = file.fetchInfo();
        if ((options & 1) != 0 && !info.exists()) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "Path does not exist", path.toOSString());
        }
        if ((options & 4) != 0 && !info.isDirectory()) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "Path is not a directory", path.toOSString());
        }
        if (!((options & 8) == 0 || Platform.getOSArch().equals("ppc64") || Platform.getOSArch().equals("ppc") || info.getAttribute(4))) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "Path is not an executable file", path.toOSString());
        }
        if ((options & 2) != 0 && info.getAttribute(2)) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "Path is not writable", path.toOSString());
        }
        if ((options & 0x10) != 0 && info.isDirectory()) {
            return AttributeVerification.createStatus(this.pluginID, null, severity, attributeName, "Path is not a file", path.toOSString());
        }
        return null;
    }

    public IPath verifyPluginRelativePath(String attributeName, Plugin plugin, IPath path) throws CoreException {
        if (path.isAbsolute()) {
            return path;
        }
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        if (url == null) {
            this.throwAttributeException(attributeName, "Path not found in plug-in", path.toOSString());
        }
        try {
            url = FileLocator.resolve((URL)url);
            URI uri = new URI(url.toString());
            File file = new File(uri);
            return new Path(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            this.throwAttributeException(attributeName, "Path not found in plugin", path.toOSString());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.throwAttributeException(attributeName, "Must be a local file", path.toOSString());
        }
        return null;
    }

    public IStatus createResultStatus(List errors) {
        ArrayList oldList = errors;
        errors = new ArrayList();
        for (Object object : oldList) {
            if (object == null) continue;
            errors.add(object);
        }
        if (errors.isEmpty()) {
            return new Status(0, this.pluginID, 0, "Configuration is OK", null);
        }
        MultiStatus result = new MultiStatus(this.pluginID, 0, "Configuration contains invalid values", null);
        for (IStatus object : errors) {
            result.add(object);
        }
        return result;
    }
}

