/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.ibm.pe.core.PEPreferenceManager;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.PEResourceManager;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.PEResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ui.IMemento;

public class PEResourceManagerFactory
extends AbstractResourceManagerFactory {
    public PEResourceManagerFactory() {
        super("PE");
    }

    public IResourceManagerConfiguration copyConfiguration(IResourceManagerConfiguration configuration) {
        return (IResourceManagerConfiguration)configuration.clone();
    }

    public IResourceManagerControl create(IResourceManagerConfiguration confIn) {
        PEResourceManagerConfiguration configuration = (PEResourceManagerConfiguration)confIn;
        PTPCorePlugin plugin = PTPCorePlugin.getDefault();
        IPUniverseControl universe = (IPUniverseControl)plugin.getUniverse();
        return new PEResourceManager(universe.getNextResourceManagerId(), universe, (IResourceManagerConfiguration)configuration);
    }

    public IResourceManagerConfiguration createConfiguration() {
        PEResourceManagerConfiguration conf = new PEResourceManagerConfiguration(this);
        Preferences preferences = PEPreferenceManager.getPreferences();
        conf.setProxyServerPath(preferences.getString("PROXY_PATH"));
        conf.setOptions(preferences.getInt("OPTIONS"));
        conf.setDebugLevel(preferences.getString("PE_traceLevel"));
        conf.setJobPollInterval(preferences.getString("PE_JobPollInterval"));
        conf.setLibraryOverride(preferences.getString("PE_libraryOverride"));
        conf.setLoadLevelerMode(preferences.getString("PE_LoadLevelerMode"));
        conf.setNodeMaxPollInterval(preferences.getString("PE_NodeMaxPollInterval"));
        conf.setNodeMinPollInterval(preferences.getString("PE_NodeMinPollInterval"));
        conf.setRunMiniproxy(preferences.getString("PE_runMiniproxy"));
        conf.setUseLoadLeveler(preferences.getString("PE_useLoadLeveler"));
        return conf;
    }

    public IResourceManagerConfiguration loadConfiguration(IMemento memento) {
        return PEResourceManagerConfiguration.load(this, memento);
    }
}

