/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.hover;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.ptp.internal.ui.hover.DefaultInformationControl;
import org.eclipse.ptp.internal.ui.hover.IconTextReader;
import org.eclipse.ptp.internal.ui.hover.LineBreakingReader;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class IconHoverPresenter
implements DefaultInformationControl.IInformationPresenter {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private int fCounter;
    private boolean fEnforceUpperLineLimit;

    public IconHoverPresenter(boolean enforceUpperLineLimit) {
        this.fEnforceUpperLineLimit = enforceUpperLineLimit;
    }

    public IconHoverPresenter() {
        this(true);
    }

    protected Reader createReader(String hoverInfo, TextPresentation presentation) {
        return new IconTextReader(new StringReader(hoverInfo), presentation);
    }

    protected void adaptTextPresentation(TextPresentation presentation, int offset, int insertLength) {
        int yoursStart = offset;
        int yoursEnd = offset + insertLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            int myStart = range.start;
            int myEnd = range.start + range.length - 1;
            if ((myEnd = Math.max(myStart, myEnd)) < yoursStart) continue;
            if (myStart < yoursStart) {
                range.length += insertLength;
                continue;
            }
            range.start += insertLength;
        }
    }

    private void append(StringBuffer buffer, String string, TextPresentation presentation) {
        int length = string.length();
        buffer.append(string);
        if (presentation != null) {
            this.adaptTextPresentation(presentation, this.fCounter, length);
        }
        this.fCounter += length;
    }

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null) {
            return null;
        }
        GC gc = new GC((Drawable)display);
        try {
            StringBuffer buffer = new StringBuffer();
            int maxNumberOfLines = Math.round(maxHeight / gc.getFontMetrics().getHeight());
            this.fCounter = 0;
            LineBreakingReader reader = new LineBreakingReader(this.createReader(hoverInfo, presentation), gc, maxWidth);
            String line = reader.readLine();
            while (line != null) {
                if (this.fEnforceUpperLineLimit && maxNumberOfLines <= 0) break;
                this.append(buffer, line, null);
                this.append(buffer, LINE_DELIM, (TextPresentation)(reader.isFormattedLine() ? presentation : null));
                line = reader.readLine();
                --maxNumberOfLines;
            }
            if (line != null && buffer.length() > 0) {
                this.append(buffer, LINE_DELIM, null);
                this.append(buffer, "...", null);
            }
            String string = this.trim(buffer, presentation);
            return string;
        }
        catch (IOException e) {
            PTPUIPlugin.log(e);
            return null;
        }
        finally {
            gc.dispose();
        }
    }

    private String trim(StringBuffer buffer, TextPresentation presentation) {
        int length = buffer.length();
        int end = length - 1;
        while (end >= 0 && Character.isWhitespace(buffer.charAt(end))) {
            --end;
        }
        if (end == -1) {
            return "";
        }
        if (end < length - 1) {
            buffer.delete(end + 1, length);
        } else {
            end = length;
        }
        int start = 0;
        while (start < end && Character.isWhitespace(buffer.charAt(start))) {
            ++start;
        }
        buffer.delete(0, start);
        presentation.setResultWindow((IRegion)new Region(start, buffer.length()));
        return buffer.toString();
    }
}

