/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.internal.ui.adapters.PropertyAdapterFactory;
import org.eclipse.ptp.internal.ui.adapters.WorkbenchAdapterAdapterFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.consoles.ConsoleManager;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.managers.MachineManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.utils.DebugUtil;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPageFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.ui";
    public static final String EXTENSION_POINT_ID = "rmConfigurations";
    private static PTPUIPlugin plugin;
    private final HashMap<String, RMConfigurationWizardPageFactory> configurationWizardPageFactories = new HashMap();
    private AbstractUIManager machineManager = null;
    private AbstractUIManager jobManager = null;
    private ConsoleManager consoleManager = null;

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPUIPlugin getDefault() {
        return plugin;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getUniqueIdentifier() {
        if (PTPUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public PTPUIPlugin() {
        plugin = this;
    }

    public AbstractUIManager getJobManager() {
        return this.jobManager;
    }

    public AbstractUIManager getMachineManager() {
        return this.machineManager;
    }

    public RMConfigurationWizardPageFactory getRMConfigurationWizardPageFactory(IResourceManagerFactory factory) {
        return this.configurationWizardPageFactories.get(factory.getClass().getName());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugUtil.configurePluginDebugOptions();
        this.registerAdapterFactories();
        this.retrieveConfigurationWizardPageFactories();
        this.machineManager = new MachineManager();
        this.jobManager = new JobManager();
        this.consoleManager = new ConsoleManager();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.machineManager.shutdown();
        this.jobManager.shutdown();
        this.consoleManager.shutdown();
        this.machineManager = null;
        this.jobManager = null;
        this.consoleManager = null;
        plugin = null;
    }

    private void registerAdapterFactories() {
        IAdapterManager manager = Platform.getAdapterManager();
        Object factory = new PropertyAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, IPElement.class);
        manager.registerAdapters((IAdapterFactory)factory, IElement.class);
        factory = new WorkbenchAdapterAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, IPElement.class);
    }

    private void retrieveConfigurationWizardPageFactories() {
        this.configurationWizardPageFactories.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    RMConfigurationWizardPageFactory factory = (RMConfigurationWizardPageFactory)ce.createExecutableExtension("class");
                    Class<? extends IResourceManagerFactory> rmFactoryClass = factory.getRMFactoryClass();
                    this.configurationWizardPageFactories.put(rmFactoryClass.getName(), factory);
                }
                catch (CoreException e) {
                    PTPUIPlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
    }
}

