/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.actions.AbstractResourceManagerSelectionActionDelegate;
import org.eclipse.swt.widgets.Shell;

public class StopResourceManagersObjectActionDelegate
extends AbstractResourceManagerSelectionActionDelegate {
    public void run(IAction action) {
        for (IResourceManagerMenuContribution menuContrib : this.getMenuContribs()) {
            boolean shutdown;
            IResourceManager rmManager = (IResourceManager)menuContrib.getAdapter(IResourceManager.class);
            if (!this.isEnabledFor(rmManager)) continue;
            ResourceManagerAttributes.State state = rmManager.getState();
            if (state == ResourceManagerAttributes.State.STARTED && !(shutdown = MessageDialog.openConfirm((Shell)this.getTargetShell(), (String)UIMessage.getResourceString("StopResourceManagersObjectActionDelegate.Title"), (String)(String.valueOf(UIMessage.getResourceString("StopResourceManagersObjectActionDelegate.Confirm")) + rmManager.getName() + UIMessage.getResourceString("StopResourceManagersObjectActionDelegate.ResourceManager"))))) {
                return;
            }
            try {
                rmManager.shutdown();
            }
            catch (CoreException e) {
                String message = String.valueOf(UIMessage.getResourceString("StopResourceManagersObjectActionDelegate.UnableStopResourceManager")) + rmManager.getName() + "\"";
                Status status = new Status(4, "org.eclipse.ptp.ui", 1, message, (Throwable)e);
                ErrorDialog dlg = new ErrorDialog(this.getTargetShell(), UIMessage.getResourceString("StopResourceManagersObjectActionDelegate.ErrorStopingResourceManager"), message, (IStatus)status, 4);
                dlg.open();
                PTPUIPlugin.log((IStatus)status);
            }
        }
    }

    protected boolean isEnabledFor(IResourceManager rmManager) {
        ResourceManagerAttributes.State state = rmManager.getState();
        return state == ResourceManagerAttributes.State.STARTED || state == ResourceManagerAttributes.State.ERROR;
    }
}

