/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.remote.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.rm.remote.ui.Messages;
import org.eclipse.ptp.rm.remote.ui.preferences.PreferenceConstants;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractRemotePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    public static final String EMPTY_STRING = "";
    private String serverFile = "";
    private boolean loading = true;
    protected Text serverText = null;
    protected Button browseButton = null;
    protected Button fNoneButton = null;
    protected Button fStdioButton = null;
    protected Button fPortForwardingButton = null;
    protected Button fManualButton = null;
    protected WidgetListener listener = new WidgetListener();

    public void dispose() {
        super.dispose();
    }

    public abstract Preferences getPreferences();

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.loadDefaults();
        this.defaultSetting();
        this.updateApplyButton();
    }

    public boolean performOk() {
        this.store();
        Preferences preferences = this.getPreferences();
        preferences.setValue("PROXY_PATH", this.serverFile);
        int options = 0;
        if (this.fStdioButton.getSelection()) {
            options |= 1;
        }
        if (this.fPortForwardingButton.getSelection()) {
            options |= 2;
        }
        if (this.fManualButton.getSelection()) {
            options |= 4;
        }
        preferences.setValue("OPTIONS", options);
        this.savePreferences();
        return true;
    }

    public abstract void savePreferences();

    private void updateOptions(int options) {
        this.fStdioButton.setSelection(false);
        this.fPortForwardingButton.setSelection(false);
        this.fNoneButton.setSelection(true);
        if ((options & 1) == 1) {
            this.fStdioButton.setSelection(true);
            this.fNoneButton.setSelection(false);
        } else if ((options & 2) == 2) {
            this.fPortForwardingButton.setSelection(true);
            this.fNoneButton.setSelection(false);
        }
        if (this.fStdioButton.getSelection()) {
            this.fManualButton.setEnabled(false);
            this.fManualButton.setSelection(false);
        } else {
            this.fManualButton.setSelection((options & 4) == 4);
        }
    }

    private void loadSaved() {
        this.loading = true;
        Preferences preferences = this.getPreferences();
        this.serverFile = preferences.getString("PROXY_PATH");
        this.serverText.setText(this.serverFile);
        this.updateOptions(preferences.getInt("OPTIONS"));
        this.loading = false;
    }

    private void loadDefaults() {
        this.loading = true;
        Preferences preferences = this.getPreferences();
        this.serverFile = preferences.getDefaultString("PROXY_PATH");
        this.serverText.setText(this.serverFile);
        this.updateOptions(preferences.getDefaultInt("OPTIONS"));
        this.loading = false;
    }

    private void store() {
        this.serverFile = this.serverText.getText();
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    private Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        Group bGroup = new Group(composite, 16);
        bGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        bGroup.setLayoutData((Object)this.spanGridData(768, 2));
        bGroup.setText(Messages.getString("RemotePreferencesPage.group_server"));
        new Label((Composite)bGroup, 64).setText(Messages.getString("RemotePreferencesPage.server_text"));
        Composite orteserver = new Composite((Composite)bGroup, 0);
        orteserver.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        orteserver.setLayoutData((Object)this.spanGridData(768, 5));
        new Label(orteserver, 0).setText(Messages.getString("RemotePreferencesPage.server_label"));
        this.serverText = new Text(orteserver, 2052);
        this.serverText.setLayoutData((Object)new GridData(768));
        this.serverText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton((Composite)orteserver, (String)Messages.getString("RemotePreferencesPage.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        Group mxGroup = new Group(composite, 16);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.getString("RemotePreferencesPage.mxOptions"));
        this.fNoneButton = this.createRadioButton((Composite)mxGroup, Messages.getString("RemotePreferencesPage.noneButton"), "mxGroup", (SelectionListener)this.listener);
        this.fPortForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.getString("RemotePreferencesPage.portForwardingButton"), "mxGroup", (SelectionListener)this.listener);
        this.fStdioButton = this.createRadioButton((Composite)mxGroup, Messages.getString("RemotePreferencesPage.stdioButton"), "mxGroup", (SelectionListener)this.listener);
        Group otherGroup = new Group(composite, 16);
        otherGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        otherGroup.setLayoutData((Object)this.spanGridData(768, 2));
        otherGroup.setText(Messages.getString("RemotePreferencesPage.otherOptions"));
        this.fManualButton = this.createCheckButton((Composite)otherGroup, Messages.getString("RemotePreferencesPage.manualButton"));
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected void defaultSetting() {
        this.serverText.setText(this.serverFile);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected void handlePathBrowseButtonSelected() {
        String selectedPath;
        File path;
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(Messages.getString("RemotePreferencesPage.Select"));
        String correctPath = this.getFieldContent(this.serverText.getText());
        if (correctPath != null && (path = new File(correctPath)).exists()) {
            dialog.setFilterPath(path.isFile() ? correctPath : path.getParent());
        }
        if ((selectedPath = dialog.open()) != null) {
            this.serverText.setText(selectedPath);
        }
    }

    protected boolean isValidSetting() {
        String name = this.getFieldContent(this.serverText.getText());
        if (name == null) {
            this.setErrorMessage(Messages.getString("RemotePreferencesPage.Invalid"));
            this.setValid(false);
            return false;
        }
        File path = new File(name);
        if (!path.exists() || !path.isFile()) {
            this.setErrorMessage(Messages.getString("RemotePreferencesPage.Invalid"));
            this.setValid(false);
            return false;
        }
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            return;
        }
        this.setValid(true);
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!AbstractRemotePreferencePage.this.loading && source == AbstractRemotePreferencePage.this.serverText) {
                AbstractRemotePreferencePage.this.updatePreferencePage();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractRemotePreferencePage.this.updatePreferencePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRemotePreferencePage.this.browseButton) {
                AbstractRemotePreferencePage.this.handlePathBrowseButtonSelected();
            } else {
                if (AbstractRemotePreferencePage.this.fStdioButton.getSelection()) {
                    AbstractRemotePreferencePage.this.fManualButton.setEnabled(false);
                    AbstractRemotePreferencePage.this.fManualButton.setSelection(false);
                } else {
                    AbstractRemotePreferencePage.this.fManualButton.setEnabled(true);
                }
                AbstractRemotePreferencePage.this.updatePreferencePage();
            }
        }
    }
}

