/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.ui.DeferredFileStore;
import org.eclipse.ptp.remote.ui.Messages;
import org.eclipse.ptp.remote.ui.RemoteContentProvider;
import org.eclipse.ptp.remote.ui.RemoteResourceComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RemoteResourceBrowser
extends Dialog {
    public static final String EMPTY_STRING = "";
    public static final int FILE_BROWSER = 1;
    public static final int DIRECTORY_BROWSER = 2;
    private static final int widthHint = 300;
    private static final int heightHint = 300;
    private Tree tree;
    private Text remotePathText;
    private Button okButton;
    private int browserType;
    private IRemoteFileManager fileMgr;
    private IPath cwd;
    private String dialogTitle;
    private String dialogLabel;
    private String remotePath = "";

    public RemoteResourceBrowser(IRemoteFileManager fileMgr, Shell parent) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.fileMgr = fileMgr;
        this.cwd = fileMgr.getWorkingDirectory();
        this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        this.setType(3);
    }

    public IPath getPath() {
        if (this.remotePath.equals(EMPTY_STRING)) {
            return null;
        }
        return new Path(this.remotePath);
    }

    public void setTitle(String title) {
        Shell shell;
        this.dialogTitle = title;
        if (this.dialogTitle == null) {
            this.dialogTitle = EMPTY_STRING;
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setText(this.dialogTitle);
        }
    }

    public void setType(int type) {
        this.browserType = type;
        if (type == 1) {
            this.dialogLabel = Messages.RemoteResourceBrowser_fileLabel;
            this.setTitle(Messages.RemoteResourceBrowser_fileTitle);
        } else if (type == 2) {
            this.dialogLabel = Messages.RemoteResourceBrowser_directoryLabel;
            this.setTitle(Messages.RemoteResourceBrowser_directoryTitle);
        } else {
            this.dialogLabel = Messages.RemoteResourceBrowser_resourceLabel;
            this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        }
    }

    private IPath findInitialPath(IPath pathToCheck) {
        IPath path = this.cwd;
        if (pathToCheck.matchingFirstSegments(this.cwd) != this.cwd.segmentCount()) {
            return path;
        }
        if (pathToCheck != null) {
            try {
                IFileInfo info = this.fileMgr.getResource(pathToCheck, (IProgressMonitor)new NullProgressMonitor()).fetchInfo();
                if (info.exists()) {
                    path = pathToCheck;
                }
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return buttons;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.dialogTitle);
        this.remotePathText.setText(this.remotePath);
        return contents;
    }

    public void setInitialPath(String path) {
        IPath initial = this.findInitialPath((IPath)new Path(path));
        this.remotePath = initial.toString();
    }

    protected Control createDialogArea(Composite parent) {
        IFileStore root;
        Composite main = (Composite)super.createDialogArea(parent);
        Label label = new Label(main, 0);
        label.setText(this.dialogLabel);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.remotePathText = new Text(main, 2052);
        this.remotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteResourceBrowser.this.remotePath = RemoteResourceBrowser.this.remotePathText.getText();
                RemoteResourceBrowser.this.updateDialog();
            }
        });
        gd = new GridData(768);
        gd.widthHint = 300;
        this.remotePathText.setLayoutData((Object)gd);
        try {
            root = this.fileMgr.getResource(this.cwd, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            return main;
        }
        this.tree = new Tree(main, 2052);
        GridData data = new GridData(1808);
        data.heightHint = Math.max(main.getParent().getSize().y, 300);
        this.tree.setLayoutData((Object)data);
        TreeViewer treeViewer = new TreeViewer(this.tree){

            public boolean isExpandable(Object element) {
                ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
                if (cp == null) {
                    return false;
                }
                return cp.hasChildren(element);
            }
        };
        treeViewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss;
                Object element;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof DeferredFileStore) {
                    DeferredFileStore dfs = (DeferredFileStore)element;
                    if (RemoteResourceBrowser.this.browserType == 2) {
                        if (dfs.isContainer()) {
                            RemoteResourceBrowser.this.remotePathText.setText(dfs.getFileStore().toURI().getPath());
                        }
                    } else if (dfs.isContainer()) {
                        event.getSelectionProvider().setSelection(null);
                    } else {
                        RemoteResourceBrowser.this.remotePathText.setText(dfs.getFileStore().toURI().getPath());
                    }
                }
            }
        });
        treeViewer.setComparator((ViewerComparator)new RemoteResourceComparator());
        treeViewer.setInput((Object)new DeferredFileStore(root));
        return main;
    }

    private void updateDialog() {
        if (this.remotePathText.getText().equals(EMPTY_STRING)) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }
}

