/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class TaskManager
extends AbstractPDIManager
implements IPDITaskManager {
    private BitList terminatedProcs;
    private BitList suspendedProcs;
    private BitList registeredProcs;
    private BitList pendingProcs;
    private BitList canStepReturnProcs;

    public TaskManager(IPDISession session) {
        super(session, false);
        this.terminatedProcs = new BitList(session.getTotalTasks());
        this.suspendedProcs = new BitList(session.getTotalTasks());
        this.registeredProcs = new BitList(session.getTotalTasks());
        this.pendingProcs = new BitList(session.getTotalTasks());
        this.canStepReturnProcs = new BitList(session.getTotalTasks());
    }

    public boolean canAllStepReturn(BitList tasks) {
        return this.getCannotStepReturnTasks(tasks.copy()).isEmpty();
    }

    public BitList getCannotStepReturnTasks(BitList tasks) {
        tasks.andNot(this.getCanStepReturnTasks());
        return tasks;
    }

    public BitList getCanStepReturnTasks() {
        return this.canStepReturnProcs;
    }

    public BitList getCanStepReturnTasks(BitList tasks) {
        tasks.and(this.getCanStepReturnTasks());
        return tasks;
    }

    public BitList getNonPendingTasks(BitList tasks) {
        tasks.andNot(this.getPendingTasks());
        return tasks;
    }

    public BitList getNonRunningTasks(BitList tasks) {
        tasks.andNot(this.getRunningTasks(tasks.copy()));
        return tasks;
    }

    public BitList getNonSuspendedTasks(BitList tasks) {
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getNonTerminatedTasks(BitList tasks) {
        tasks.andNot(this.getTerminatedTasks());
        return tasks;
    }

    public BitList getPendingTasks() {
        return this.pendingProcs;
    }

    public BitList getPendingTasks(BitList tasks) {
        tasks.and(this.getPendingTasks());
        return tasks;
    }

    public BitList getRegisteredTasks() {
        return this.registeredProcs;
    }

    public BitList getRegisteredTasks(BitList tasks) {
        tasks.and(this.getRegisteredTasks());
        return tasks;
    }

    public BitList getRunningTasks(BitList tasks) {
        tasks.andNot(this.getTerminatedTasks());
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getSuspendedTasks() {
        return this.suspendedProcs;
    }

    public BitList getSuspendedTasks(BitList tasks) {
        tasks.and(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getTerminatedTasks() {
        return this.terminatedProcs;
    }

    public BitList getTerminatedTasks(BitList tasks) {
        tasks.and(this.getTerminatedTasks());
        return tasks;
    }

    public BitList getUnregisteredTasks(BitList tasks) {
        tasks.andNot(this.getRegisteredTasks());
        return tasks;
    }

    public boolean isAllPending(BitList tasks) {
        return this.getNonPendingTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRegistered(BitList tasks) {
        return this.getUnregisteredTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRunning(BitList tasks) {
        return !this.isAllSuspended(tasks) && !this.isAllTerminated(tasks);
    }

    public boolean isAllSuspended(BitList tasks) {
        return this.getNonSuspendedTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllTerminated(BitList tasks) {
        return this.getNonTerminatedTasks(tasks.copy()).isEmpty();
    }

    public void setCanStepReturnTasks(boolean isAdd, BitList tasks) {
        BitList stepReturnTasks = this.getCanStepReturnTasks();
        if (isAdd) {
            this.addTasks(stepReturnTasks, tasks);
        } else {
            this.removeTasks(stepReturnTasks, tasks);
        }
    }

    public void setPendingTasks(boolean isAdd, BitList tasks) {
        BitList pendingTasks = this.getPendingTasks();
        if (isAdd) {
            this.addTasks(pendingTasks, tasks);
        } else {
            this.removeTasks(pendingTasks, tasks);
        }
    }

    public void setRegisterTasks(boolean isAdd, BitList tasks) {
        BitList registeredTasks = this.getRegisteredTasks();
        if (isAdd) {
            this.addTasks(registeredTasks, tasks);
        } else {
            this.removeTasks(registeredTasks, tasks);
        }
    }

    public void setSuspendTasks(boolean isAdd, BitList tasks) {
        BitList suspendedTasks = this.getSuspendedTasks();
        if (isAdd) {
            this.addTasks(suspendedTasks, tasks);
        } else {
            this.removeTasks(suspendedTasks, tasks);
            this.setCanStepReturnTasks(false, tasks);
        }
    }

    public void setTerminateTasks(boolean isAdd, BitList tasks) {
        BitList terminatedTasks = this.getTerminatedTasks();
        if (isAdd) {
            this.addTasks(terminatedTasks, tasks);
            this.setSuspendTasks(false, tasks);
        } else {
            this.removeTasks(terminatedTasks, tasks);
        }
    }

    public void shutdown() {
    }

    public void update(BitList tasks) throws PDIException {
    }

    private synchronized void addTasks(BitList curTasks, BitList newTasks) {
        if (curTasks.size() < newTasks.size()) {
            newTasks.or(curTasks);
            curTasks = newTasks.copy();
        }
        curTasks.or(newTasks);
    }

    private synchronized void removeTasks(BitList curTasks, BitList newTasks) {
        curTasks.andNot(newTasks);
    }
}

