/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.array;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.internal.ui.views.CTable;
import org.eclipse.ptp.debug.internal.ui.views.ICTableCellSelectionListener;
import org.eclipse.ptp.debug.internal.ui.views.PTabFolder;
import org.eclipse.ptp.debug.internal.ui.views.PTabItem;
import org.eclipse.ptp.debug.internal.ui.views.array.AbstractArrayTableModel;
import org.eclipse.ptp.debug.internal.ui.views.array.ArrayMessages;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;

public class ArrayTabItem
extends PTabItem {
    private final String COL_TYPE = "col";
    private final String ROW_TYPE = "row";
    private SashForm sashForm = null;
    private CTable cTable = null;
    private Composite leftContent = null;
    private ArrayTableModel arrayModel = null;
    private IPVariable variable = null;
    private boolean reloadVariable = false;
    String type;
    String name;

    public ArrayTabItem(PTabFolder view, String tabText, IPVariable variable) {
        super(view, tabText);
        this.variable = variable;
        this.reloadVariable = false;
        this.setControl();
    }

    public void init(final IPVariable variable) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                int dim = 0;
                monitor.beginTask(MessageFormat.format("{0}", ArrayMessages.getString("ArrayTabItem.initVariable")), 10);
                try {
                    try {
                        ArrayTabItem.this.name = variable.getName();
                        ArrayTabItem.this.type = variable.getReferenceTypeName();
                        IValue value = variable.getValue();
                        while (value.hasVariables()) {
                            IVariable[] vars;
                            IVariable[] iVariableArray = vars = value.getVariables();
                            if (vars.length != 0) {
                                IVariable var = iVariableArray[0];
                                value = var.getValue();
                            }
                            ArrayTabItem.this.fillDimensionPanel(vars.length - 1);
                            ++dim;
                            monitor.worked(3);
                        }
                    }
                    catch (DebugException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    ArrayTabItem.this.arrayModel = new ArrayTableModel(dim);
                    monitor.done();
                }
            }
        };
        try {
            this.run(false, false, runnable);
        }
        catch (InterruptedException e) {
            this.displayError(e);
        }
        catch (InvocationTargetException e1) {
            this.displayError(e1);
        }
    }

    protected void dispose() {
        this.view.closeTab(this.getTabItem().getText());
        this.resetTable();
        this.variable = null;
        this.getTabItem().dispose();
    }

    public void clearContext() {
        Control[] controlArray = this.leftContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                ((Button)control).setSelection(false);
            } else if (control instanceof Spinner) {
                ((Spinner)control).setSelection(0);
            }
            ++n2;
        }
        this.resetTable();
        this.cTable.redraw();
    }

    public void setReloadVariable(boolean reload) {
        this.reloadVariable = reload;
    }

    public void displayTab() {
        if (!this.displayError) {
            this.fPageBook.showPage((Control)this.sashForm);
        }
    }

    public void createTabPage(Composite parent) {
        this.sashForm = new SashForm(parent, 2304);
        this.sashForm.setLayout((Layout)new FillLayout(256));
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sashForm.SASH_WIDTH = 2;
        this.sashForm.setBackground(parent.getDisplay().getSystemColor(20));
        this.leftPanel((Composite)this.sashForm);
        this.rightPanel((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{1, 3});
    }

    protected Menu createPopupMenu() {
        Menu menu = new Menu((Control)this.cTable);
        MenuItem mItem = new MenuItem(menu, 8);
        mItem.setText(ArrayMessages.getString("ArrayTabItem.resetRange"));
        mItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        return menu;
    }

    public void updateTable(int colIndex, int rowIndex) {
        if (colIndex == -1 && rowIndex == -1) {
            PTPDebugUIPlugin.errorDialog(this.fPageBook.getShell(), ArrayMessages.getString("ArrayTabItem.noIndexErrTitle"), new Exception(ArrayMessages.getString("ArrayTabItem.noIndexErrMsg")));
            return;
        }
    }

    private GridLayout createGridLayout(int column, boolean balance, int marginWidth, int marginHeight) {
        GridLayout layout = new GridLayout(column, balance);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        return layout;
    }

    private GridData createHorizontaGridData(int hozAlign, int width) {
        GridData gd = new GridData(hozAlign, 1, hozAlign == 4, false);
        gd.widthHint = width;
        return gd;
    }

    private void leftPanel(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.leftContent = new Composite((Composite)sc, 0);
        this.leftContent.setLayout((Layout)this.createGridLayout(3, false, 3, 3));
        this.leftContent.setLayoutData((Object)new GridData(4, 1, true, false));
        sc.setContent((Control)this.leftContent);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        new Label(this.leftContent, 8).setText("col");
        new Label(this.leftContent, 8).setText("row");
        Label sliceLabel = new Label(this.leftContent, 8);
        sliceLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        sliceLabel.setText("Slice");
        sc.setMinSize(120, -1);
    }

    private void clearAllCheckboxes(String name) {
        Control[] controlArray = this.leftContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button && control.getToolTipText().equals(name)) {
                ((Button)control).setSelection(false);
            }
            ++n2;
        }
    }

    private void reload() throws CoreException {
        IPStackFrame frame = this.view.getStackFrame();
        IVariable[] iVariableArray = frame.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            if (var instanceof IPVariable) {
                IPVariable pvar = (IPVariable)var;
                String pname = var.getName();
                String ptype = var.getReferenceTypeName();
                if (pname.equals(this.name) && ptype.equals(this.type)) {
                    this.variable = pvar;
                    this.name = pname;
                    this.type = ptype;
                    this.reloadVariable = false;
                    break;
                }
            }
            ++n2;
        }
        if (this.reloadVariable) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No variable found", null));
        }
    }

    public void refreshTable() {
        if (this.reloadVariable) {
            try {
                this.reload();
            }
            catch (CoreException e) {
                PTPDebugUIPlugin.errorDialog(this.fPageBook.getShell(), "Error", e.getStatus());
                return;
            }
        }
        if (this.arrayModel != null) {
            this.setDimensionValues();
            if (this.arrayModel.isAvailable()) {
                this.cTable.setModel(this.arrayModel);
                this.arrayModel.initial();
            } else {
                this.resetTable();
                this.cTable.redraw();
            }
        }
    }

    private void resetTable() {
        this.arrayModel.reset();
        this.cTable.setModel(null);
    }

    /*
     * Unable to fully structure code
     */
    private void setDimensionValues() {
        values = new int[this.arrayModel.getDimension()][3];
        fCol = 1;
        fRow = 1;
        pos = 0;
        this.arrayModel.setColumnCount(1);
        this.arrayModel.setRowCount(1);
        var8_5 = this.leftContent.getChildren();
        var7_6 = var8_5.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            control = var8_5[var6_7];
            if (!(control instanceof Button)) ** GOTO lbl-1000
            if (control.getToolTipText().equals("col")) {
                values[pos][0] = ((Button)control).getSelection() != false ? 1 : 0;
            } else if (control.getToolTipText().equals("row")) {
                values[pos][1] = ((Button)control).getSelection() != false ? 1 : 0;
            } else if (control instanceof Spinner) {
                if (values[pos][0] == 1) {
                    values[pos][2] = ((Spinner)control).getMaximum();
                    fCol = ((Spinner)control).getSelection() + 1;
                    this.arrayModel.setColumnCount(values[pos][2] + 1);
                } else if (values[pos][1] == 1) {
                    values[pos][2] = ((Spinner)control).getMaximum();
                    fRow = ((Spinner)control).getSelection() + 1;
                    this.arrayModel.setRowCount(values[pos][2] + 1);
                } else {
                    values[pos][2] = ((Spinner)control).getSelection();
                }
                ++pos;
            }
            ++var6_7;
        }
        this.arrayModel.setSelection(fCol, fRow);
        this.arrayModel.setValues(values);
    }

    private void fillDimensionPanel(int size) {
        final Button colBtn = new Button(this.leftContent, 32);
        colBtn.setToolTipText("col");
        colBtn.setLayoutData((Object)this.createHorizontaGridData(0x1000000, 20));
        final Button rowBtn = new Button(this.leftContent, 32);
        rowBtn.setLayoutData((Object)this.createHorizontaGridData(0x1000000, 20));
        rowBtn.setToolTipText("row");
        colBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = colBtn.getSelection();
                ArrayTabItem.this.clearAllCheckboxes("col");
                colBtn.setSelection(selected);
                if (selected && rowBtn.getSelection()) {
                    ArrayTabItem.this.arrayModel.reset();
                    rowBtn.setSelection(false);
                }
                ArrayTabItem.this.refreshTable();
            }
        });
        rowBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = rowBtn.getSelection();
                ArrayTabItem.this.clearAllCheckboxes("row");
                rowBtn.setSelection(selected);
                if (selected && colBtn.getSelection()) {
                    ArrayTabItem.this.arrayModel.reset();
                    colBtn.setSelection(false);
                }
                ArrayTabItem.this.refreshTable();
            }
        });
        Spinner spinner = new Spinner(this.leftContent, 2048);
        spinner.setLayoutData((Object)new GridData(4, 1, true, false));
        spinner.setMinimum(0);
        spinner.setMaximum(size);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!colBtn.getSelection() && !rowBtn.getSelection()) {
                    ArrayTabItem.this.arrayModel.reset();
                }
                ArrayTabItem.this.refreshTable();
            }
        });
        this.leftContent.pack(true);
    }

    private void rightPanel(Composite parent) {
        this.cTable = new CTable(parent, 768);
        this.cTable.addCellSelectionListener(new ICTableCellSelectionListener(){

            /*
             * Unable to fully structure code
             */
            public void cellSelected(int col, int row, int statemask) {
                block6: {
                    if (ArrayTabItem.access$6(ArrayTabItem.this) == null) break block6;
                    isCol = false;
                    isRow = false;
                    var9_6 = ArrayTabItem.access$6(ArrayTabItem.this).getChildren();
                    var8_7 = var9_6.length;
                    var7_8 = 0;
                    while (var7_8 < var8_7) {
                        control = var9_6[var7_8];
                        if (!(control instanceof Button)) ** GOTO lbl-1000
                        if (control.getToolTipText().equals("col")) {
                            isCol = ((Button)control).getSelection();
                        } else if (control.getToolTipText().equals("row")) {
                            isRow = ((Button)control).getSelection();
                        } else if (control instanceof Spinner && (isCol || isRow)) {
                            ((Spinner)control).setSelection((isCol != false ? col : row) - 1);
                        }
                        ++var7_8;
                    }
                }
            }

            public void fixedCellSelected(int col, int row, int statemask) {
            }
        });
    }

    private void showTable() {
        this.cTable.redraw();
        this.cTable.setSelection(this.arrayModel.getSelectedColumn(), this.arrayModel.getSelectedRow(), true);
    }

    static /* synthetic */ Composite access$6(ArrayTabItem arrayTabItem) {
        return arrayTabItem.leftContent;
    }

    class ArrayTableModel
    extends AbstractArrayTableModel {
        private int[][] values;
        private int fCol = 1;
        private int fRow = 1;
        private int dimension;
        private Object[][] data = null;

        public ArrayTableModel(int dimension) {
            this.dimension = dimension;
        }

        public Object getContentAt(int col, int row) {
            if (col == this.getFixedColumnCount() - 1) {
                return "" + (row - 1);
            }
            if (row == this.getFixedRowCount() - 1) {
                return "" + (col - 1);
            }
            if (this.data[col][row] == null) {
                return "";
            }
            return this.data[col][row];
        }

        public void setRowCount(int rows) {
            this.rows = rows + this.getFixedRowCount();
        }

        public void setColumnCount(int cols) {
            this.cols = cols + this.getFixedColumnCount();
        }

        public void reset() {
            this.fCol = this.getFixedColumnCount();
            this.fRow = this.getFixedRowCount();
            this.values = null;
            this.data = null;
        }

        public void setValues(int[][] values) {
            this.values = values;
        }

        public int getDimension() {
            return this.dimension;
        }

        public boolean isAvailable() {
            if (this.values == null) {
                return false;
            }
            boolean isCol = false;
            boolean isRow = false;
            int i = 0;
            while (i < this.dimension) {
                boolean bl = isCol ? true : (isCol = this.values[i][0] == 1);
                isRow = isRow ? true : this.values[i][1] == 1;
                ++i;
            }
            if (this.dimension == 1) {
                return isCol || isRow;
            }
            return isCol && isRow;
        }

        public void setSelection(int col, int row) {
            this.fCol = col;
            this.fRow = row;
        }

        public int getSelectedColumn() {
            return this.fCol;
        }

        public int getSelectedRow() {
            return this.fRow;
        }

        private String getValueString(int col, int row) throws DebugException {
            IPVariable var = ArrayTabItem.this.variable;
            int i = 0;
            while (i < this.dimension) {
                IVariable[] vars = var.getValue().getVariables();
                if (vars.length == 0) {
                    throw new DebugException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "No Value found", null));
                }
                var = this.values[i][0] == 1 ? vars[col - 1] : (this.values[i][1] == 1 ? vars[row - 1] : vars[this.values[i][2]]);
                ++i;
            }
            return var.getValue().getValueString();
        }

        public void initial() {
            if (this.data != null) {
                ArrayTabItem.this.showTable();
                return;
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Retrieving values...", ArrayTableModel.this.cols * ArrayTableModel.this.rows);
                    ArrayTableModel.this.data = new Object[ArrayTableModel.this.cols][ArrayTableModel.this.rows];
                    try {
                        int c = ArrayTableModel.this.getFixedColumnCount();
                        while (c < ArrayTableModel.this.cols) {
                            int r = ArrayTableModel.this.getFixedRowCount();
                            while (r < ArrayTableModel.this.rows) {
                                try {
                                    ((ArrayTableModel)ArrayTableModel.this).data[c][r] = ArrayTableModel.this.getValueString(c, r);
                                    monitor.worked(1);
                                }
                                catch (DebugException ex) {
                                    throw new InvocationTargetException(ex);
                                }
                                ++r;
                            }
                            ++c;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    ArrayTabItem.this.showTable();
                }
            };
            try {
                ArrayTabItem.this.run(false, false, runnable);
            }
            catch (InterruptedException e) {
                ArrayTabItem.this.displayError(e);
            }
            catch (InvocationTargetException e1) {
                ArrayTabItem.this.displayError(e1);
            }
        }
    }
}

