/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.remotetools.Activator;
import org.eclipse.ptp.remote.remotetools.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.RemoteToolsFileManager;
import org.eclipse.ptp.remote.remotetools.RemoteToolsServices;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteItem;

public class RemoteToolsFileStore
extends FileStore {
    private IRemoteItem remoteItem;
    private URI remoteURI;
    private RemoteToolsFileManager fileMgr;
    private IRemoteExecutionManager exeMgr;
    private boolean isDirectory;

    public static RemoteToolsFileStore getInstance(URI uri) throws IOException {
        String path = uri.getPath();
        String hostName = uri.getHost();
        IRemoteConnectionManager connMgr = RemoteToolsServices.getInstance().getConnectionManager();
        RemoteToolsConnection conn = (RemoteToolsConnection)connMgr.getConnection(hostName);
        IRemoteFileManager fileMgr = RemoteToolsServices.getInstance().getFileManager(conn);
        return (RemoteToolsFileStore)fileMgr.getResource((IPath)new Path(path), (IProgressMonitor)new NullProgressMonitor());
    }

    public RemoteToolsFileStore(RemoteToolsFileManager mgr, IRemoteItem remoteItem, boolean isDirectory) {
        this.fileMgr = mgr;
        this.exeMgr = mgr.getExecutionManager();
        this.remoteItem = remoteItem;
        this.isDirectory = isDirectory;
        this.remoteURI = mgr.toURI((IPath)new Path(remoteItem.getPath()));
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem[] items;
        try {
            items = this.exeMgr.getRemoteFileTools().listItems(this.remoteItem.getPath());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage()));
        }
        String[] names = new String[items.length];
        int i = 0;
        while (i < items.length) {
            Path path = new Path(items[i].getPath());
            names[i] = path.lastSegment();
            ++i;
        }
        return names;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            this.exeMgr.getRemoteFileTools().removeFile(this.remoteItem.getPath());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not delete file", (Throwable)e));
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo info = new FileInfo(new Path(this.remoteItem.getPath()).lastSegment());
        if (this.remoteItem == null || !this.remoteItem.exists()) {
            info.setExists(false);
            return info;
        }
        info.setExists(true);
        info.setLastModified(this.remoteItem.getModificationTime());
        info.setDirectory(this.isDirectory);
        info.setAttribute(2, !this.remoteItem.isWritable());
        if (!this.isDirectory) {
            IRemoteFile file = (IRemoteFile)this.remoteItem;
            info.setAttribute(4, file.isExecutable());
            info.setLength(file.getSize());
        }
        return info;
    }

    public IFileStore getChild(String name) {
        IPath childPath = new Path(this.remoteItem.getPath()).append(name);
        IFileStore resource = this.fileMgr.lookup(childPath);
        if (resource != null) {
            return resource;
        }
        try {
            return this.fileMgr.getResource(childPath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getName() {
        Path path = new Path(this.remoteItem.getPath());
        if (path.isRoot()) {
            return path.toString();
        }
        return new Path(this.remoteItem.getPath()).lastSegment();
    }

    public IFileStore getParent() {
        Path parent = new Path(this.exeMgr.getRemotePathTools().parent(this.remoteItem.getPath()));
        IFileStore resource = this.fileMgr.lookup((IPath)parent);
        if (resource != null) {
            return resource;
        }
        try {
            return this.fileMgr.getResource((IPath)parent, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        try {
            this.exeMgr.getRemoteFileTools().createDirectory(this.remoteItem.getPath());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "The directory could not be created", (Throwable)e));
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (this.isDirectory) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Is a directory"));
        }
        try {
            return this.exeMgr.getRemoteCopyTools().executeDownload(this.remoteItem.getPath()).getInputStreamFromProcessRemoteFile();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not get input stream", (Throwable)e));
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (this.isDirectory) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Is a directory"));
        }
        try {
            return this.exeMgr.getRemoteCopyTools().executeUpload(this.remoteItem.getPath()).getOutputStreamToProcessRemoteFile();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not open output stream", (Throwable)e));
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        try {
            boolean modified = false;
            if ((options & 0x400) != 0) {
                this.remoteItem.setWriteable(!info.getAttribute(2));
                modified = true;
            }
            if ((options & 0x800) != 0) {
                this.remoteItem.setModificationTime(info.getLastModified());
                modified = true;
            }
            if (modified) {
                this.remoteItem.commitAttributes();
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public URI toURI() {
        return this.remoteURI;
    }
}

