/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.rse.RSEConnection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;

public class RSEFileManager
implements IRemoteFileManager {
    private RSEConnection connection;

    public RSEFileManager(RSEConnection conn) {
        this.connection = conn;
    }

    public IPath browseDirectory(Shell shell, String message, String filterPath) {
        Object retObj;
        IHost host = this.connection.getHost();
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, message, host);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0 && (retObj = dlg.getSelectedObject()) instanceof IRemoteFile) {
            IRemoteFile selectedFile = (IRemoteFile)retObj;
            return new Path(selectedFile.getAbsolutePath());
        }
        return null;
    }

    public IPath browseFile(Shell shell, String message, String filterPath) {
        Object retObj;
        IHost host = this.connection.getHost();
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, host);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0 && (retObj = dlg.getSelectedObject()) instanceof IRemoteFile) {
            IRemoteFile selectedFile = (IRemoteFile)retObj;
            return new Path(selectedFile.getAbsolutePath());
        }
        return null;
    }

    public IFileStore getResource(IPath path, IProgressMonitor monitor) throws IOException {
        return this.connection.getFileSystem().getStore(this.toURI(path));
    }

    public IPath getWorkingDirectory() {
        return new Path("/");
    }

    public IPath toPath(URI uri) {
        return new Path(uri.getPath());
    }

    public URI toURI(IPath path) {
        try {
            return new URI("rse", this.connection.getHost().getHostName(), path.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

