/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteDirectory;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteStatusTools;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;
import org.eclipse.ptp.remotetools.environment.launcher.data.UploadRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.DownloadBackRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.ILaunchProcessCallback;
import org.eclipse.ptp.remotetools.environment.launcher.internal.IRuleAction;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.utils.file.FileRecursiveEnumeration;

public class UploadRuleAction
implements IRuleAction {
    private ILaunchProcessCallback process;
    private UploadRule rule;
    private ExecutionConfiguration configuration;
    private PrintWriter outputWriter;
    private PrintWriter errorWriter;
    private IRemoteExecutionManager manager;
    private DownloadBackRule downloadBackRule;
    private long clockSkew;

    public UploadRuleAction(ILaunchProcessCallback process, UploadRule uploadRule) {
        this.process = process;
        this.rule = uploadRule;
        this.configuration = process.getConfiguration();
        this.outputWriter = process.getOutputWriter();
        this.errorWriter = process.getErrorWriter();
        this.manager = process.getExecutionManager();
    }

    public void run() throws CoreException, CancelException, RemoteConnectionException {
        IPath localPath;
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.outputWriter);
        Assert.isNotNull((Object)this.errorWriter);
        Assert.isNotNull((Object)this.manager);
        if (this.rule.getOverwritePolicy() == 3) {
            IRemoteStatusTools statusTools = this.manager.getRemoteStatusTools();
            try {
                long localTime = System.currentTimeMillis();
                long remoteTime = statusTools.getTime();
                this.clockSkew = localTime - remoteTime;
            }
            catch (RemoteOperationException e) {
                this.errorWriter.println(NLS.bind((String)"   Could not calculate clock difference with remote host: {0}", (Object)e.getMessage()));
                this.errorWriter.println("   Assuming same a remote clock synchronized with local clock.");
                this.clockSkew = 0L;
            }
            if (this.clockSkew < -15000L) {
                this.errorWriter.println("   Warning! Clock at remote target is more recent than local clock. File synchronization may not be correct.");
            } else if (this.clockSkew > 15000L) {
                this.errorWriter.println("   Warning! Clock at remote target is older than local clock. File synchronization may not be correct.");
            }
        }
        IPath defaultRemotePath = this.configuration.getRemoteDirectoryPath();
        IPath remotePath = null;
        if (this.rule.isDefaultRemoteDirectory()) {
            remotePath = defaultRemotePath;
        } else {
            remotePath = LinuxPath.fromString(this.rule.getRemoteDirectory());
            if (!remotePath.isAbsolute()) {
                remotePath = defaultRemotePath.append(remotePath);
            }
        }
        remotePath = remotePath.removeTrailingSeparator();
        Assert.isTrue((boolean)remotePath.isAbsolute(), (String)"remotePath.isAbsolute()");
        IPath[] localPaths = this.rule.getLocalFilesAsPathArray();
        IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int i = 0;
        while (i < localPaths.length) {
            localPath = localPaths[i];
            if (!localPath.isAbsolute()) {
                localPath = workspace.append(localPath);
            }
            localPath = localPath.removeTrailingSeparator();
            Assert.isTrue((boolean)localPath.isAbsolute(), (String)"localPath.isAbsolute()");
            localPaths[i] = localPath;
            ++i;
        }
        i = 0;
        while (i < localPaths.length) {
            localPath = localPaths[i];
            File localFile = localPath.toFile();
            if (!localFile.exists()) {
                this.errorWriter.println(NLS.bind((String)"   Ignoring {0}: Path does not exist locally", (Object)localFile.toString()));
            } else if (localFile.isDirectory()) {
                this.uploadDirectory(localFile, remotePath);
            } else if (localFile.isFile()) {
                this.uploadFile(localFile, remotePath);
            } else {
                this.errorWriter.println(NLS.bind((String)"   Ignoring {0}: Path is not a file nor directory", (Object)localFile.toString()));
            }
            ++i;
        }
        if (this.downloadBackRule != null) {
            this.process.addSynchronizationRule(this.downloadBackRule);
        }
    }

    private void uploadFile(File localFile, IPath remoteDirectoryPath) throws CoreException, CancelException, RemoteConnectionException {
        Assert.isTrue((boolean)localFile.isAbsolute(), (String)"localFile.isAbsolute()");
        Assert.isTrue((boolean)remoteDirectoryPath.isAbsolute(), (String)"remoteDirectoryPath.isAbsolute()");
        IPath remoteFile = remoteDirectoryPath.append(localFile.getName());
        this.outputWriter.println(NLS.bind((String)"   Copying file {0} (local)", (Object)localFile.toString()));
        this.outputWriter.println(NLS.bind((String)"   to file {0} (remote)", (Object)LinuxPath.toString(remoteFile)));
        this.doFileUpload(localFile, remoteFile);
    }

    private void doFileUpload(File localFile, IPath remotePath) throws CoreException, CancelException, RemoteConnectionException {
        IRemoteFile remoteFile;
        if (!localFile.exists()) {
            this.errorWriter.println(NLS.bind((String)"   Ignoring {0}: File does not exist locally", (Object)localFile.toString()));
            return;
        }
        Assert.isTrue((boolean)localFile.isAbsolute(), (String)"localFile.isAbsolute()");
        Assert.isTrue((boolean)localFile.isFile(), (String)"localFile.isFile()");
        Assert.isTrue((boolean)remotePath.isAbsolute(), (String)"remotePath.isAbsolute()");
        String remotePathAsString = LinuxPath.toString(remotePath);
        IRemoteCopyTools copyTools = this.manager.getRemoteCopyTools();
        IRemoteFileTools fileTools = this.manager.getRemoteFileTools();
        if (this.rule.getOverwritePolicy() != 2) {
            long difference;
            remoteFile = null;
            try {
                remoteFile = fileTools.getFile(remotePathAsString);
            }
            catch (RemoteOperationException e) {
                this.errorWriter.println(NLS.bind((String)"   Could not fetch properties for remote file, ignoring it: {0}", (Object)e.getMessage()));
                return;
            }
            if (this.rule.getOverwritePolicy() == 1) {
                if (remoteFile.exists()) {
                    this.outputWriter.println(NLS.bind((String)"   File alredy exists on remote target, ignoring it: {0}", (Object)remotePath));
                    return;
                }
            } else if (this.rule.getOverwritePolicy() == 3 && (difference = localFile.lastModified() - remoteFile.getModificationTime()) < 1000L) {
                this.outputWriter.println(NLS.bind((String)"   A newer file alredy exists on remote target, ignoring it: {0}", (Object)remotePath));
                return;
            }
        }
        try {
            copyTools.uploadFileToFile(localFile, remotePathAsString);
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not upload file: {0}", (Object)e.getMessage()));
            return;
        }
        if (this.rule.isDownloadBack()) {
            if (this.downloadBackRule == null) {
                this.downloadBackRule = new DownloadBackRule();
            }
            this.downloadBackRule.add(localFile, remotePath);
        }
        remoteFile = null;
        try {
            remoteFile = fileTools.getFile(remotePathAsString);
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not fetch properties for uploaded file: {0}", (Object)e.getMessage()));
            return;
        }
        IFileSystem localFileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = localFileSystem.getStore((IPath)new Path(localFile.getPath()));
        IFileInfo fileInfo = fileStore.fetchInfo();
        boolean read = localFile.canRead();
        boolean write = localFile.canWrite();
        boolean execute = fileInfo.getAttribute(4);
        if (this.rule.isAsReadOnly()) {
            write = false;
        }
        if (this.rule.isAsExecutable()) {
            execute = true;
        }
        remoteFile.setExecutable(execute);
        remoteFile.setWriteable(write);
        remoteFile.setReadable(read);
        if (this.rule.isPreserveTimeStamp()) {
            long timestamp = localFile.lastModified();
            remoteFile.setModificationTime(timestamp);
        }
        try {
            remoteFile.commitAttributes();
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not write properties for uploaded file: {0}", (Object)e.getMessage()));
            return;
        }
    }

    private void doDirectoryUpload(File localDir, IPath remotePath) throws RemoteConnectionException, CancelException {
        if (!localDir.exists()) {
            this.errorWriter.println(NLS.bind((String)"   Ignoring {0}: Directory does not exist locally", (Object)localDir.toString()));
            return;
        }
        Assert.isTrue((boolean)localDir.isDirectory(), (String)"localFile.isDirectory()");
        Assert.isTrue((boolean)localDir.isAbsolute(), (String)"localFile.isAbsolute()");
        Assert.isTrue((boolean)remotePath.isAbsolute(), (String)"remotePath.isAbsolute()");
        IRemoteFileTools fileTools = this.manager.getRemoteFileTools();
        try {
            fileTools.assureDirectory(LinuxPath.toString(remotePath));
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not create remote directory: {0}", (Object)e.getMessage()));
            return;
        }
        IRemoteDirectory remoteDirectory = null;
        try {
            remoteDirectory = fileTools.getDirectory(LinuxPath.toString(remotePath));
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not fetch properties for created remote directory: {0}", (Object)e.getMessage()));
            return;
        }
        boolean read = localDir.canRead();
        boolean write = localDir.canWrite();
        boolean execute = true;
        if (this.rule.isAsReadOnly()) {
            write = false;
        }
        remoteDirectory.setAccessible(execute);
        remoteDirectory.setWriteable(write);
        remoteDirectory.setReadable(read);
        if (this.rule.isPreserveTimeStamp()) {
            long timestamp = localDir.lastModified();
            remoteDirectory.setModificationTime(timestamp);
        }
        try {
            remoteDirectory.commitAttributes();
        }
        catch (RemoteOperationException e) {
            this.errorWriter.println(NLS.bind((String)"   Could not write properties for uploaded directory: {0}", (Object)e.getMessage()));
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void uploadDirectory(File localDir, IPath remotePath) throws CoreException, CancelException, RemoteConnectionException {
        Assert.isTrue((boolean)localDir.isAbsolute(), (String)"localDir.isAbsolute()");
        Assert.isTrue((boolean)remotePath.isAbsolute(), (String)"remotePath.isAbsolute()");
        this.outputWriter.println(NLS.bind((String)"   Copying contents of directory {0} (local)", (Object)localDir.toString()));
        this.outputWriter.println(NLS.bind((String)"   into directory {0} (remote)", (Object)LinuxPath.toString(remotePath)));
        enumeration = null;
        enumeration = new FileRecursiveEnumeration(localDir);
        rootPath = new Path(localDir.getAbsolutePath());
        rootPathLength = rootPath.segmentCount();
        ** GOTO lbl25
        {
            this.errorWriter.println(NLS.bind((String)"   Could not read file/directory: {0}", (Object)enumeration.nextException()));
            do {
                if (enumeration.hasMoreExceptions()) continue block0;
                file = (File)enumeration.nextElement();
                filePath = new Path(file.getAbsolutePath());
                relativePath = filePath.removeFirstSegments(rootPathLength);
                remoteFilePath = remotePath.append(relativePath);
                if (file.isDirectory()) {
                    this.outputWriter.println(NLS.bind((String)"   Create remote directory {0}", (Object)LinuxPath.toString(remoteFilePath)));
                    this.doDirectoryUpload(file, remoteFilePath);
                    continue;
                }
                this.outputWriter.println(NLS.bind((String)"   Upload {0}", (Object)LinuxPath.toString(relativePath)));
                this.doFileUpload(file, remoteFilePath);
lbl25:
                // 3 sources

            } while (enumeration.hasMoreElements());
        }
        while (enumeration.hasMoreExceptions()) {
            this.errorWriter.println(NLS.bind((String)"   Could not read file/directory: {0}", (Object)enumeration.nextException()));
        }
    }
}

