/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AddResourceManagerAction
extends Action {
    private final Shell shell;

    public AddResourceManagerAction(Shell shell) {
        super("Add Resource Manager...");
        this.shell = shell;
    }

    public void dispose() {
    }

    public void run() {
        IResourceManagerFactory[] resourceManagerFactories = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFactories();
        if (resourceManagerFactories.length == 0) {
            MessageBox dialog = new MessageBox(this.shell, 34);
            dialog.setText("No Resource Managers Factories");
            dialog.setMessage("No Resource Managers Factories are plugged into this application");
            dialog.open();
            return;
        }
        RMConfigurationWizard wizard = new RMConfigurationWizard(resourceManagerFactories);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        int status = dialog.open();
        if (status != 0) {
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

