/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.ElementHandler;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class JobManager
extends AbstractUIManager {
    protected Map<String, IElementHandler> jobElementHandlerList = new HashMap<String, IElementHandler>();
    protected Map<String, IPJob> jobList = new HashMap<String, IPJob>();
    protected IPJob cur_job = null;
    protected IPQueue cur_queue = null;
    protected final String DEFAULT_TITLE = "Please select a job";

    public void addJob(IPJob job) {
        if (job != null) {
            IElementSet set = this.createElementHandler(job).getSetRoot();
            ArrayList<IElement> elements = new ArrayList<IElement>();
            IPProcess[] iPProcessArray = job.getProcesses();
            int n = iPProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPProcess proc = iPProcessArray[n2];
                if (proc != null && !set.contains(proc.getID())) {
                    elements.add(this.createProcessElement(set, proc.getID(), proc.getProcessIndex(), proc));
                }
                ++n2;
            }
            set.addElements(elements.toArray(new IElement[0]));
        }
    }

    public void addProcess(IPProcess proc) {
        IPJob job = proc.getJob();
        IElementSet set = this.createElementHandler(job).getSetRoot();
        if (!set.contains(proc.getID())) {
            set.addElements(new IElement[]{this.createProcessElement(set, proc.getID(), proc.getProcessIndex(), proc)});
        }
    }

    public void clear() {
        this.jobList.clear();
        this.jobElementHandlerList.clear();
    }

    public IElementHandler createElementHandler(IPJob job) {
        IElementHandler handler = this.getElementHandler(job.getID());
        if (handler == null) {
            handler = new ElementHandler();
            this.jobList.put(job.getID(), job);
            this.jobElementHandlerList.put(job.getID(), handler);
        }
        return handler;
    }

    public IPJob findJobById(String job_id) {
        return this.jobList.get(job_id);
    }

    public IPProcess findProcess(IPJob job, String task_id) {
        if (job == null) {
            return null;
        }
        return job.getProcessByIndex(task_id);
    }

    public IPProcess findProcess(String proc_id) {
        IPJob job = this.getJob();
        if (job != null) {
            return job.getProcessById(proc_id);
        }
        return null;
    }

    public String getCurrentSetId() {
        return this.cur_set_id;
    }

    public IElementHandler getElementHandler(String id) {
        return this.jobElementHandlerList.get(id);
    }

    public String getFullyQualifiedName(String id) {
        IResourceManager rm;
        IPQueue queue;
        if (id.equals("")) {
            return "Please select a job";
        }
        IPJob job = this.getJob();
        if (job != null && (queue = job.getQueue()) != null && (rm = queue.getResourceManager()) != null) {
            return String.valueOf(rm.getName()) + ": " + queue.getName() + ":" + job.getName();
        }
        return "";
    }

    public IPJob getJob() {
        return this.cur_job;
    }

    public IPJob[] getJobs() {
        return this.jobList.values().toArray(new IPJob[0]);
    }

    public String getName(String id) {
        IPJob job = this.findJobById(id);
        if (job == null) {
            return "";
        }
        return job.getName();
    }

    public String getProcessStatusText(IPProcess proc) {
        if (proc != null) {
            return proc.getState().toString();
        }
        return "Error";
    }

    public IPQueue getQueue() {
        return this.cur_queue;
    }

    public IPQueue[] getQueues() {
        if (this.cur_queue != null) {
            return this.cur_queue.getResourceManager().getQueues();
        }
        return new IPQueue[0];
    }

    public String[] getSets(String jid) {
        IElementHandler eHandler = this.getElementHandler(jid);
        if (eHandler == null) {
            return new String[0];
        }
        IElement[] elements = eHandler.getElements();
        String[] sets = new String[elements.length];
        int i = 1;
        while (i < sets.length + 1) {
            String tmp = elements[i - 1].getID();
            if (!tmp.equals("Root")) {
                if (i == sets.length) {
                    sets[i - 1] = tmp;
                } else {
                    sets[i] = tmp;
                }
            }
            ++i;
        }
        if (sets.length > 0) {
            sets[0] = "Root";
        }
        return sets;
    }

    public int getStatus(String id) {
        IPProcess proc;
        IPJob job = this.getJob();
        if (job != null && (proc = job.getProcessById(id)) != null) {
            return proc.getState().ordinal();
        }
        return ProcessAttributes.State.UNKNOWN.ordinal();
    }

    public boolean hasStoppedJob() {
        IPJob[] iPJobArray = this.getJobs();
        int n = iPJobArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPJob job = iPJobArray[n2];
            if (job.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IPElement initial(IPUniverse universe) {
        IResourceManager[] iResourceManagerArray = universe.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            IPQueue[] iPQueueArray = rm.getQueues();
            int n3 = iPQueueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPQueue queue = iPQueueArray[n4];
                IPJob[] iPJobArray = queue.getJobs();
                int n5 = iPJobArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IPJob job = iPJobArray[n6];
                    this.addJob(job);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        this.setCurrentSetId("Root");
        return null;
    }

    public boolean isCurrentSetContainProcess(String jid, String processID) {
        IPJob job = this.getJob();
        if (job != null) {
            if (!job.getID().equals(jid)) {
                return false;
            }
            IElementHandler elementHandler = this.getElementHandler(jid);
            if (elementHandler == null) {
                return false;
            }
            IElementSet set = (IElementSet)elementHandler.getElementByID(this.getCurrentSetId());
            if (set == null) {
                return false;
            }
            return set.contains(processID);
        }
        return false;
    }

    public boolean isJobStop(String job_id) {
        if (this.isNoJob(job_id)) {
            return true;
        }
        IPJob job = this.findJobById(job_id);
        return job == null || job.isTerminated();
    }

    public boolean isNoJob(String jid) {
        return jid == null || jid.length() == 0;
    }

    public void removeAllStoppedJobs() {
        HashMap<String, IPQueue> queues = new HashMap<String, IPQueue>();
        IPJob[] iPJobArray = this.getJobs();
        int n = iPJobArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPJob job = iPJobArray[n2];
            IPQueue queue = job.getQueue();
            if (!queues.containsKey(queue.getID())) {
                queue.getResourceManager().removeTerminatedJobs(queue);
                queues.put(queue.getID(), queue);
            }
            ++n2;
        }
    }

    public void removeJob(IPJob job) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String jid = job.getID();
        ILaunch[] iLaunchArray = launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            String launchedJobID = launch.getAttribute(ElementAttributes.getIdAttributeDefinition().getId());
            if (launchedJobID != null && launchedJobID.equals(jid)) {
                launchManager.removeLaunch(launch);
            }
            ++n2;
        }
        this.jobList.remove(jid);
        this.removeElementHandler(job);
        this.fireJobChangedEvent(1, null, jid);
    }

    public void removeProcess(IPProcess proc) {
        IElementSet set;
        IElement element;
        IElementHandler elementHandler = this.jobElementHandlerList.get(proc.getJob().getID());
        if (elementHandler != null && (element = (set = elementHandler.getSetRoot()).getElementByID(proc.getID())) != null) {
            set.removeElement(proc.getID());
        }
    }

    public void setCurrentSetId(String set_id) {
        this.cur_set_id = set_id;
    }

    public void setJob(IPJob job) {
        String new_id;
        String old_id = this.cur_job == null ? "" : this.cur_job.getID();
        String string = new_id = job == null ? "" : job.getID();
        if (job != null) {
            this.addJob(job);
        }
        this.cur_job = job;
        this.fireJobChangedEvent(0, new_id, old_id);
    }

    public void setQueue(IPQueue queue) {
        if (queue != this.cur_queue) {
            this.cur_queue = queue;
            this.setJob(null);
        }
    }

    public void shutdown() {
        this.clear();
        this.modelPresentation = null;
        super.shutdown();
    }

    public int size() {
        return this.jobList.size();
    }

    public void terminateJob() throws CoreException {
        IPJob job = this.getJob();
        if (job != null) {
            job.getQueue().getResourceManager().terminateJob(job);
        }
    }

    private void removeElementHandler(IPJob job) {
        IElementHandler elementHandler = this.getElementHandler(job.getID());
        if (elementHandler != null) {
            elementHandler.removeAllRegistered();
            elementHandler.clean();
        }
        this.jobElementHandlerList.remove(job.getID());
    }

    protected IElement createProcessElement(IElementSet set, String key, String taskID, IPProcess process) {
        return new Element(set, key, taskID, (IPElement)process){

            public int compareTo(IElement e) {
                return new Integer(this.getName()).compareTo(new Integer(e.getName()));
            }
        };
    }
}

