/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedNodeEvent;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewNodeEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveNodeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.INodeChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIUtils;
import org.eclipse.ptp.ui.actions.ParallelAction;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.managers.MachineManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelSetView;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParallelMachinesView
extends AbstractParallelSetView
implements ISelectionProvider {
    public static final String BOTH_VIEW = "0";
    public static final String MACHINE_VIEW = "1";
    public static final String INFO_VIEW = "2";
    private ListenerList listeners = new ListenerList();
    private final IModelManagerChildListener modelManagerListener = new MMChildListener();
    private final IResourceManagerChildListener resourceManagerListener = new RMChildListener();
    private final IMachineChildListener machineListener = new MachineChildListener();
    private final INodeChildListener nodeListener = new NodeChildListener();
    private ISelection selection = null;
    protected String cur_selected_element_id = "";
    protected Menu jobPopupMenu = null;
    protected SashForm upperSashForm = null;
    protected SashForm sashForm = null;
    protected TableViewer machineTableViewer = null;
    protected TableViewer processTableViewer = null;
    protected TableViewer nodeAttrTableViewer = null;
    protected Composite elementViewComposite = null;
    protected Composite infoComposite = null;
    protected ParallelAction terminateAllAction = null;
    protected String current_view = "0";

    public ParallelMachinesView() {
        this(PTPUIPlugin.getDefault().getMachineManager());
    }

    public ParallelMachinesView(IManager manager) {
        super(manager);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void changeMachine(String id) {
        IPMachine machine = ((MachineManager)this.manager).findMachineById(id);
        this.changeMachineRefresh(machine);
    }

    public void changeMachineRefresh(final IPMachine machine) {
        UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

            public void run() {
                if (!ParallelMachinesView.this.elementViewComposite.isDisposed()) {
                    ParallelMachinesView.this.changeMachine(machine);
                    ParallelMachinesView.this.machineTableViewer.refresh(true);
                    ParallelMachinesView.this.machineTableViewer.setSelection((ISelection)(machine == null ? new StructuredSelection() : new StructuredSelection((Object)machine)), true);
                    ParallelMachinesView.this.nodeAttrTableViewer.refresh();
                    ParallelMachinesView.this.processTableViewer.refresh();
                }
            }
        });
    }

    public void changeView(String view_flag) {
        this.current_view = view_flag;
        if (this.current_view.equals(MACHINE_VIEW)) {
            this.machineTableViewer.getTable().setVisible(true);
            this.elementViewComposite.setVisible(false);
            this.infoComposite.setVisible(false);
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.sashForm.setWeights(nArray);
        } else if (this.current_view.equals(INFO_VIEW)) {
            this.machineTableViewer.getTable().setVisible(false);
            this.elementViewComposite.setVisible(true);
            this.infoComposite.setVisible(true);
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.sashForm.setWeights(nArray);
        } else {
            this.machineTableViewer.getTable().setVisible(true);
            this.elementViewComposite.setVisible(true);
            this.infoComposite.setVisible(true);
        }
    }

    public void dispose() {
        this.elementViewComposite.dispose();
        super.dispose();
    }

    public void doubleClick(IElement element) {
        boolean isElementRegistered = element.isRegistered();
        this.unregister();
        if (!isElementRegistered) {
            this.getCurrentElementHandler().addToRegister(new IElement[]{element});
        }
        this.nodeAttrTableViewer.refresh();
        this.processTableViewer.refresh();
    }

    public String getCurrentID() {
        IPMachine machine = this.getMachineManager().getCurrentMachine();
        if (machine != null) {
            return machine.getID();
        }
        return "";
    }

    public synchronized IPMachine getCurrentMachine() {
        return this.getMachineManager().getCurrentMachine();
    }

    public String getCurrentView() {
        return this.current_view;
    }

    public Image getImage(int index1, int index2) {
        return ParallelImages.nodeImages[index1][index2];
    }

    public String getRulerIndex(Object obj, int index) {
        Object nodeObj;
        if (obj instanceof IElement && (nodeObj = this.convertElementObject((IElement)obj)) instanceof IPNode) {
            return ((IPNode)nodeObj).getNodeNumber();
        }
        return super.getRulerIndex(obj, index);
    }

    public ISelection getSelection() {
        if (this.selection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    public String[] getToolTipText(Object obj) {
        IElementHandler setManager = this.getCurrentElementHandler();
        if (obj == null || !(obj instanceof IPNode) || setManager == null || this.cur_element_set == null) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        IPNode node = (IPNode)obj;
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getName());
        IElementSet[] sets = setManager.getSetsWithElement(node.getID());
        if (sets.length > 1) {
            buffer.append("\n Set: ");
        }
        int i = 1;
        while (i < sets.length) {
            buffer.append(sets[i].getID());
            if (i < sets.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return new String[]{buffer.toString()};
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void repaint(boolean all) {
        if (all && !this.machineTableViewer.getTable().isDisposed()) {
            this.machineTableViewer.refresh(true);
        }
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.setSelection(this.selection);
    }

    public void setFocus() {
        super.setFocus();
        IPMachine machine = this.getCurrentMachine();
        if (machine == null) {
            this.changeMachine((String)null);
        }
    }

    public void setSelection(ISelection selection) {
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(e);
                }
            });
            ++i;
        }
    }

    public void unregister() {
        IElementHandler elementHandler = this.getCurrentElementHandler();
        elementHandler.removeFromRegister(elementHandler.getRegistered());
    }

    public void updateAction() {
        super.updateAction();
    }

    public void updateMachineSet() {
        IElementHandler setManager = this.getCurrentElementHandler();
        this.selectSet(setManager == null ? null : setManager.getSetRoot());
    }

    private MachineManager getMachineManager() {
        return (MachineManager)this.manager;
    }

    private IPNode getRegisteredNode() {
        this.cur_selected_element_id = "";
        IElementHandler elementHandler = this.getCurrentElementHandler();
        if (elementHandler == null || this.cur_element_set == null || elementHandler.totalRegistered() == 0) {
            return null;
        }
        String firstRegisteredElementID = elementHandler.getRegistered()[0].getID();
        if (!this.cur_element_set.contains(firstRegisteredElementID)) {
            return null;
        }
        this.cur_selected_element_id = firstRegisteredElementID;
        return this.getMachineManager().findNode(this.cur_selected_element_id);
    }

    protected void changeMachine(IPMachine machine) {
        this.selectMachine(machine);
        this.update();
    }

    protected Object convertElementObject(IElement element) {
        if (element == null) {
            return null;
        }
        return this.getMachineManager().findNode(element.getID());
    }

    protected Composite createLowerRegions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Group nodeGroup = new Group(composite, 2048);
        nodeGroup.setLayout((Layout)new FillLayout());
        GridData gdtext = new GridData(1808);
        gdtext.grabExcessVerticalSpace = true;
        gdtext.grabExcessHorizontalSpace = true;
        gdtext.horizontalAlignment = 4;
        gdtext.verticalAlignment = 4;
        nodeGroup.setLayoutData((Object)gdtext);
        nodeGroup.setText("Node Attributes");
        Group procGroup = new Group(composite, 2048);
        procGroup.setLayout((Layout)new FillLayout());
        GridData gdlist = new GridData(1808);
        gdlist.grabExcessVerticalSpace = true;
        gdlist.grabExcessHorizontalSpace = true;
        gdlist.horizontalAlignment = 4;
        gdlist.verticalAlignment = 4;
        procGroup.setLayoutData((Object)gdlist);
        procGroup.setText("Process Info");
        this.nodeAttrTableViewer = new TableViewer((Composite)nodeGroup, 68352);
        Table nodeAttrTable = this.nodeAttrTableViewer.getTable();
        TableColumn col = new TableColumn(nodeAttrTable, 16384);
        col.setText("Attribute");
        col.setWidth(80);
        col.setResizable(true);
        col = new TableColumn(nodeAttrTable, 16384);
        col.setText("Value");
        col.setWidth(200);
        col.setResizable(false);
        nodeAttrTable.setHeaderVisible(true);
        nodeAttrTable.setLinesVisible(true);
        nodeAttrTable.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                int width = table.getClientArea().width;
                switch (table.getColumnCount()) {
                    case 1: {
                        table.getColumn(0).setWidth(width);
                        break;
                    }
                    case 2: {
                        TableColumn col0 = table.getColumn(0);
                        TableColumn col1 = table.getColumn(1);
                        if (col0.getWidth() + col1.getWidth() >= width) break;
                        col1.setWidth(width - col0.getWidth());
                    }
                }
            }
        });
        this.nodeAttrTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IAttribute) {
                    IAttribute attr = (IAttribute)element;
                    switch (columnIndex) {
                        case 0: {
                            return ((IAttributeDefinition)((Object)attr.getDefinition())).getName();
                        }
                        case 1: {
                            return attr.getValueAsString();
                        }
                    }
                    return "unknown " + columnIndex;
                }
                return "";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.nodeAttrTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IPNode node;
                if (inputElement instanceof AbstractUIManager && (node = ParallelMachinesView.this.getRegisteredNode()) != null) {
                    return node.getDisplayAttributes();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.nodeAttrTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object a1, Object a2) {
                IAttribute attr1 = (IAttribute)a1;
                IAttribute attr2 = (IAttribute)a2;
                IAttributeDefinition def1 = attr1.getDefinition();
                IAttributeDefinition def2 = attr2.getDefinition();
                return def1.compareTo((Object)def2);
            }
        });
        this.nodeAttrTableViewer.setInput((Object)this.manager);
        this.processTableViewer = new TableViewer((Composite)procGroup, 68352);
        Table processTable = this.processTableViewer.getTable();
        new TableColumn(processTable, 16384).setWidth(300);
        processTable.setLinesVisible(true);
        processTable.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                int width = table.getClientArea().width;
                switch (table.getColumnCount()) {
                    case 1: {
                        table.getColumn(0).setWidth(width);
                        break;
                    }
                    case 2: {
                        TableColumn col0 = table.getColumn(0);
                        TableColumn col1 = table.getColumn(1);
                        if (col0.getWidth() + col1.getWidth() >= width) break;
                        col1.setWidth(width - col0.getWidth());
                    }
                }
            }
        });
        this.processTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ParallelMachinesView.this.openProcessViewer((IPProcess)sel.getFirstElement());
            }
        });
        this.processTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IPProcess) {
                    IPProcess process = (IPProcess)element;
                    return ParallelImages.procImages[process.getState().ordinal()][0];
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IPProcess) {
                    IPProcess process = (IPProcess)element;
                    return String.valueOf(process.getJob().getName()) + ":" + process.getName();
                }
                return "";
            }
        });
        this.processTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IPNode node;
                if (inputElement instanceof AbstractUIManager && (node = ParallelMachinesView.this.getRegisteredNode()) != null) {
                    return node.getProcesses();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.processTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object p1, Object p2) {
                IPProcess proc1 = (IPProcess)p1;
                IPProcess proc2 = (IPProcess)p2;
                String name1 = String.valueOf(proc1.getJob().getName()) + ":" + proc1.getName();
                String name2 = String.valueOf(proc2.getJob().getName()) + ":" + proc2.getName();
                return name1.compareTo(name2);
            }
        });
        this.processTableViewer.setInput((Object)this.manager);
        return composite;
    }

    protected void createMachineContextMenu() {
        MenuManager menuMgr = new MenuManager("#machinepopupmenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("actiongroup"));
                manager.add((IContributionItem)new Separator("emptygroup"));
                ParallelMachinesView.this.fillMachineContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.machineTableViewer.getTable());
        this.machineTableViewer.getTable().setMenu(menu);
    }

    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        super.buildInToolBarActions(toolBarMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createView(Composite parent) {
        IModelManager mm;
        parent.setLayout((Layout)new FillLayout(512));
        parent.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.upperSashForm = new SashForm((Composite)this.sashForm, 256);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.machineTableViewer = new TableViewer((Composite)this.upperSashForm, 2052);
        this.machineTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.machineTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                IPMachine machine;
                EnumeratedAttribute attr;
                if (element instanceof IPMachine && (attr = (EnumeratedAttribute)(machine = (IPMachine)element).getAttribute((IAttributeDefinition)MachineAttributes.getStateAttributeDefinition())) != null) {
                    return ParallelImages.machineImages[attr.getValueIndex()];
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IPMachine) {
                    return ((IPMachine)element).getName();
                }
                return "";
            }
        });
        this.machineTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof AbstractUIManager) {
                    return ((MachineManager)inputElement).getMachines();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.machineTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object j1, Object j2) {
                return ((IPMachine)j1).getName().compareTo(((IPMachine)j2).getName());
            }
        });
        this.machineTableViewer.setInput((Object)this.manager);
        this.machineTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection = ParallelMachinesView.this.machineTableViewer.getSelection();
                TableItem item = ParallelMachinesView.this.machineTableViewer.getTable().getItem(new Point(e.x, e.y));
                if (item == null && !selection.isEmpty()) {
                    ParallelMachinesView.this.machineTableViewer.getTable().deselectAll();
                    ParallelMachinesView.this.changeMachineRefresh(null);
                } else if (item != null) {
                    IPMachine machine = (IPMachine)item.getData();
                    if (machine == null) {
                        ParallelMachinesView.this.changeMachineRefresh(null);
                    } else if (selection.isEmpty()) {
                        ParallelMachinesView.this.changeMachineRefresh(machine);
                    } else {
                        String cur_id = ParallelMachinesView.this.getCurrentID();
                        if (cur_id == null || !cur_id.equals(machine.getID())) {
                            ParallelMachinesView.this.changeMachineRefresh(machine);
                        }
                    }
                }
            }
        });
        this.createMachineContextMenu();
        this.elementViewComposite = this.createElementView((Composite)this.upperSashForm);
        this.machineTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.infoComposite = this.createLowerRegions((Composite)this.sashForm);
        this.changeView(this.current_view);
        IModelManager iModelManager = mm = PTPCorePlugin.getDefault().getModelManager();
        synchronized (iModelManager) {
            IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
            int n = iResourceManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                rm.addChildListener(this.resourceManagerListener);
                ++n2;
            }
            mm.addListener(this.modelManagerListener);
        }
    }

    protected void fillMachineContextMenu(IMenuManager menuManager) {
    }

    protected void initialElement() {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] iResourceManagerArray = universe.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            IPMachine[] iPMachineArray = rm.getMachines();
            int n3 = iPMachineArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPMachine machine = iPMachineArray[n4];
                machine.addChildListener(this.machineListener);
                ++n4;
            }
            ++n2;
        }
        this.changeMachineRefresh((IPMachine)this.manager.initial(universe));
    }

    protected void initialView() {
        this.initialElement();
        this.update();
    }

    protected void selectMachine(IPMachine machine) {
        IPNode node;
        int n;
        int n2;
        IPNode[] iPNodeArray;
        IPMachine old = this.getMachineManager().getCurrentMachine();
        if (old != null) {
            iPNodeArray = old.getNodes();
            n2 = iPNodeArray.length;
            n = 0;
            while (n < n2) {
                node = iPNodeArray[n];
                node.removeChildListener(this.nodeListener);
                ++n;
            }
        }
        this.getMachineManager().setMachine(machine);
        if (machine != null) {
            iPNodeArray = machine.getNodes();
            n2 = iPNodeArray.length;
            n = 0;
            while (n < n2) {
                node = iPNodeArray[n];
                node.addChildListener(this.nodeListener);
                ++n;
            }
        }
        this.updateMachineSet();
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.addChildListener(ParallelMachinesView.this.resourceManagerListener);
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            e.getResourceManager().removeChildListener(ParallelMachinesView.this.resourceManagerListener);
        }
    }

    private final class MachineChildListener
    implements IMachineChildListener {
        private MachineChildListener() {
        }

        public void handleEvent(IChangedNodeEvent e) {
            ParallelMachinesView.this.refresh(true);
        }

        public void handleEvent(final INewNodeEvent e) {
            final boolean isCurrent = e.getSource().equals(ParallelMachinesView.this.getCurrentMachine());
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    for (IPNode node : e.getNodes()) {
                        if (isCurrent) {
                            node.addChildListener(ParallelMachinesView.this.nodeListener);
                        }
                        ParallelMachinesView.this.getMachineManager().addNode(node);
                    }
                    if (isCurrent) {
                        ParallelMachinesView.this.updateMachineSet();
                        ParallelMachinesView.this.repaint(true);
                    }
                }
            });
        }

        public void handleEvent(final IRemoveNodeEvent e) {
            final boolean isCurrent = e.getSource().equals(ParallelMachinesView.this.getCurrentMachine());
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    for (IPNode node : e.getNodes()) {
                        if (isCurrent) {
                            node.removeChildListener(ParallelMachinesView.this.nodeListener);
                        }
                        ParallelMachinesView.this.getMachineManager().removeNode(node);
                    }
                    if (isCurrent) {
                        ParallelMachinesView.this.updateMachineSet();
                        ParallelMachinesView.this.repaint(true);
                        ((MachineChildListener)MachineChildListener.this).ParallelMachinesView.this.nodeAttrTableViewer.refresh();
                        ((MachineChildListener)MachineChildListener.this).ParallelMachinesView.this.processTableViewer.refresh();
                    }
                }
            });
        }
    }

    private final class NodeChildListener
    implements INodeChildListener {
        private NodeChildListener() {
        }

        public void handleEvent(IChangedProcessEvent e) {
            if (e.getSource() instanceof IPNode) {
                if ((IPNode)e.getSource() == ParallelMachinesView.this.getRegisteredNode()) {
                    UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                        public void run() {
                            ((NodeChildListener)NodeChildListener.this).ParallelMachinesView.this.processTableViewer.refresh();
                        }
                    });
                }
                ParallelMachinesView.this.refresh(false);
            }
        }

        public void handleEvent(INewProcessEvent e) {
            if (e.getSource() instanceof IPNode && (IPNode)e.getSource() == ParallelMachinesView.this.getRegisteredNode()) {
                UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        ((NodeChildListener)NodeChildListener.this).ParallelMachinesView.this.processTableViewer.refresh();
                    }
                });
                ParallelMachinesView.this.refresh(false);
            }
        }

        public void handleEvent(final IRemoveProcessEvent e) {
            if (e.getSource() instanceof IPNode) {
                UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        IPNode node = (IPNode)e.getSource();
                        if (node == ParallelMachinesView.this.getRegisteredNode()) {
                            ((NodeChildListener)NodeChildListener.this).ParallelMachinesView.this.processTableViewer.refresh();
                        }
                    }
                });
                ParallelMachinesView.this.refresh(false);
            }
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private RMChildListener() {
        }

        public void handleEvent(IChangedMachineEvent e) {
        }

        public void handleEvent(IChangedQueueEvent e) {
        }

        public void handleEvent(INewMachineEvent e) {
            for (IPMachine machine : e.getMachines()) {
                machine.addChildListener(ParallelMachinesView.this.machineListener);
                ParallelMachinesView.this.changeMachineRefresh(machine);
            }
        }

        public void handleEvent(INewQueueEvent e) {
        }

        public void handleEvent(final IRemoveMachineEvent e) {
            UIUtils.safeRunAsyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    for (IPMachine machine : e.getMachines()) {
                        machine.removeChildListener(ParallelMachinesView.this.machineListener);
                        ParallelMachinesView.this.getMachineManager().removeMachine(machine);
                    }
                    ParallelMachinesView.this.changeMachineRefresh(null);
                }
            });
        }

        public void handleEvent(IRemoveQueueEvent e) {
        }
    }
}

