/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.toolopts;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.ToolOption;
import org.eclipse.ptp.perf.toolopts.ToolPane;
import org.eclipse.ptp.perf.toolopts.ToolPaneListener;
import org.eclipse.ptp.perf.toolopts.ToolParser;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToolMaker {
    public static PerformanceTool[] makeTools(File tooldef) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        ToolParser tparser = new ToolParser();
        try {
            factory.newSAXParser().parse(tooldef, (DefaultHandler)tparser);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PerformanceTool[] tparr = new PerformanceTool[tparser.performanceTools.size()];
        tparser.performanceTools.toArray(tparr);
        return tparr;
    }

    protected static ToolOption finishToolOption(ToolOption toolopt, String paneID) {
        if (toolopt.type > 5) {
            toolopt.type = 0;
        }
        if (toolopt.optName == null) {
            if (toolopt.optLabel != null) {
                toolopt.optName = toolopt.optLabel;
            } else {
                return null;
            }
        }
        String upname = String.valueOf(paneID) + "_" + toolopt.optName.toUpperCase();
        toolopt.confArgString = String.valueOf(upname) + "_ARGUMENT_SAVED";
        toolopt.confStateString = String.valueOf(upname) + "_BUTTON_STATE";
        toolopt.confDefString = String.valueOf(upname) + "_ARGUMENT_DEFAULT";
        toolopt.optionLine = new StringBuffer(toolopt.optName);
        if (toolopt.type > 0) {
            toolopt.optionLine.append("=\"\"");
        }
        toolopt.optionLine.append(' ');
        return toolopt;
    }

    protected static void makeToolPane(Composite comp, ToolPane pane, SelectionListener browseListener, ToolPaneListener checkListener) {
        comp.setLayout((Layout)ToolMaker.createGridLayout(3, false, 0, 0));
        comp.setLayoutData((Object)ToolMaker.spanGridData(768, 5));
        ToolMaker.createVerticalSpacer(comp, 3);
        if (pane.displayOptions) {
            pane.showOpts = new Text(comp, 2626);
            GridData showOptGD = new GridData();
            showOptGD.horizontalAlignment = 4;
            showOptGD.verticalAlignment = 4;
            showOptGD.horizontalSpan = 3;
            showOptGD.grabExcessHorizontalSpace = true;
            showOptGD.minimumHeight = pane.showOpts.getLineHeight() * 3;
            showOptGD.heightHint = pane.showOpts.getLineHeight() * 3;
            pane.showOpts.setEditable(false);
            pane.showOpts.setLayoutData((Object)showOptGD);
        }
        Composite invis = new Composite(comp, 0);
        invis.setVisible(false);
        GridData gridData = new GridData(8);
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        invis.setLayoutData((Object)gridData);
        int i = 0;
        while (i < pane.options.length) {
            if (pane.options[i].visible) {
                ToolMaker.displayToolOption(comp, pane.options[i], pane.browseListener, checkListener);
            } else {
                ToolMaker.displayToolOption(invis, pane.options[i], pane.browseListener, checkListener);
            }
            ++i;
        }
        invis.setSize(0, 0);
        invis.moveBelow(null);
    }

    private static void initializeCheckLabel(Composite comp, ToolOption toolOpt) {
        if (!toolOpt.required) {
            toolOpt.unitCheck = ToolMaker.createCheckButton(comp, toolOpt.optLabel);
            toolOpt.unitCheck.setToolTipText(toolOpt.toolTip);
        } else {
            toolOpt.reqLabel = new Label(comp, 0);
            toolOpt.reqLabel.setText(toolOpt.optLabel);
            toolOpt.reqLabel.setToolTipText(toolOpt.toolTip);
        }
    }

    protected static void displayToolOption(Composite comp, ToolOption toolOpt, SelectionListener browseListener, ToolPaneListener checkListener) {
        if (toolOpt.type == 0) {
            ToolMaker.initializeCheckLabel(comp, toolOpt);
            new Label(comp, 0);
            new Label(comp, 0);
        } else if (toolOpt.type == 1) {
            ToolMaker.initializeCheckLabel(comp, toolOpt);
            toolOpt.argbox = new Text(comp, 2052);
            toolOpt.argbox.setLayoutData((Object)new GridData(768));
            if (checkListener != null) {
                toolOpt.argbox.addModifyListener((ModifyListener)checkListener);
            }
            new Label(comp, 0);
        } else {
            ToolMaker.initializeCheckLabel(comp, toolOpt);
            toolOpt.argbox = new Text(comp, 2052);
            toolOpt.argbox.setLayoutData((Object)new GridData(768));
            if (checkListener != null) {
                toolOpt.argbox.addModifyListener((ModifyListener)checkListener);
            }
            toolOpt.browser = ToolMaker.createPushButton(comp, "Browse");
            if (browseListener != null) {
                toolOpt.browser.addSelectionListener(browseListener);
            }
        }
        if (checkListener != null && toolOpt.unitCheck != null) {
            toolOpt.unitCheck.addSelectionListener((SelectionListener)checkListener);
        }
    }

    protected static Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    protected static Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        return button;
    }

    protected static void optBrowse(ToolOption opt) {
        if (opt.type == 2) {
            String selectedPath;
            File path;
            DirectoryDialog dialog = new DirectoryDialog(ToolMaker.getShell());
            dialog.setText(opt.toolTip);
            String correctPath = opt.argbox.getText();
            if (correctPath != null && (path = new File(correctPath)).exists()) {
                dialog.setFilterPath(path.isFile() ? correctPath : path.getParent());
            }
            if ((selectedPath = dialog.open()) != null) {
                opt.argbox.setText(selectedPath);
            }
        } else if (opt.type == 3) {
            String selectedPath;
            File path;
            FileDialog dialog = new FileDialog(ToolMaker.getShell());
            dialog.setText(opt.toolTip);
            String correctPath = opt.argbox.getText();
            if (correctPath != null && (path = new File(correctPath)).exists()) {
                dialog.setFilterPath(path.isFile() ? correctPath : path.getParent());
            }
            if ((selectedPath = dialog.open()) != null) {
                opt.argbox.setText(selectedPath);
            }
        }
    }

    protected static Shell getShell() {
        Display thisDisplay = PlatformUI.getWorkbench().getDisplay();
        return new Shell(thisDisplay.getActiveShell());
    }

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected static void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }
}

