/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerMenuContribution;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceManagerSelectionActionDelegate
implements IObjectActionDelegate,
IActionDelegate2 {
    private Shell targetShell;
    private List<IResourceManagerMenuContribution> menuContribs = new ArrayList<IResourceManagerMenuContribution>();

    public void dispose() {
        this.menuContribs.clear();
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.menuContribs.clear();
        this.menuContribs.addAll(ss.toList());
        boolean isEnabled = this.isEnabled();
        action.setEnabled(isEnabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetShell = targetPart.getSite().getShell();
    }

    protected List<IResourceManagerMenuContribution> getMenuContribs() {
        return this.menuContribs;
    }

    protected Shell getTargetShell() {
        return this.targetShell;
    }

    protected boolean isEnabled() {
        if (this.menuContribs.size() == 0) {
            return false;
        }
        boolean isEnabled = true;
        for (IResourceManagerMenuContribution menuContrib : this.menuContribs) {
            IResourceManager rmManager = (IResourceManager)menuContrib.getAdapter(IResourceManager.class);
            if (rmManager == null) {
                return false;
            }
            if (this.isEnabledFor(rmManager)) continue;
            isEnabled = false;
            break;
        }
        return isEnabled;
    }

    protected abstract boolean isEnabledFor(IResourceManager var1);
}

