/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.ptp.remote.PTPRemotePlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private final IModelManagerChildListener modelManagerChildListener = new MMChildListener();
    private final IResourceManagerChildListener resourceManagerChildListener = new RMChildListener();
    private final IQueueChildListener queueChildListener = new QueueChildListener();
    protected Map<IPJob, JobSubmission> jobSubmissions = new HashMap<IPJob, JobSubmission>();

    protected static String getArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    protected static String getDebuggerExePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
    }

    protected static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    protected static boolean getDebuggerStopInMainFlag(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
    }

    protected static String getDebuggerWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    protected static String getExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
    }

    protected static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
    }

    protected static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    protected static String getQueueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.QUEUE_NAME", null);
    }

    protected static String getResourceManagerUniqueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
    }

    protected static String getWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractParallelLaunchConfigurationDelegate() {
        IModelManager mm;
        IModelManager iModelManager = mm = PTPCorePlugin.getDefault().getModelManager();
        synchronized (iModelManager) {
            IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
            int n = iResourceManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                IPQueue[] iPQueueArray = rm.getQueues();
                int n3 = iPQueueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPQueue queue = iPQueueArray[n4];
                    queue.addChildListener(this.queueChildListener);
                    ++n4;
                }
                rm.addChildListener(this.resourceManagerChildListener);
                ++n2;
            }
            mm.addListener(this.modelManagerChildListener);
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    private IAttribute<?, ?, ?>[] getResourceAttributes(ILaunchConfiguration configuration) throws CoreException {
        String queueName = AbstractParallelLaunchConfigurationDelegate.getQueueName(configuration);
        IResourceManager rm = this.getResourceManager(configuration);
        AbstractRMLaunchConfigurationFactory rmFactory = PTPLaunchPlugin.getDefault().getRMLaunchConfigurationFactory(rm);
        if (rmFactory == null) {
            return new IAttribute[0];
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = rmFactory.create(rm);
        IPQueue queue = rm.getQueueByName(queueName);
        if (queue != null) {
            return rmDynamicTab.getAttributes(rm, queue, configuration);
        }
        return new IAttribute[0];
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), code, message, exception));
    }

    protected abstract void doCompleteJobLaunch(ILaunchConfiguration var1, String var2, IPLaunch var3, AttributeManager var4, IPDebugger var5, IPJob var6);

    protected AttributeManager getAttributeManager(ILaunchConfiguration configuration) throws CoreException {
        String[] envArr;
        String[] argArr;
        IPQueue queue;
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.No_ResourceManager"), null, 0);
        }
        AttributeManager attrMgr = new AttributeManager();
        IPath programPath = this.verifyExecutablePath(configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getExecutableNameAttributeDefinition().create(programPath.lastSegment()));
        String path = programPath.removeLastSegments(1).toString();
        if (path != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(path));
        }
        if ((queue = rm.getQueueByName(AbstractParallelLaunchConfigurationDelegate.getQueueName(configuration))) != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getQueueIdAttributeDefinition().create(queue.getID()));
        }
        attrMgr.addAttributes(this.getResourceAttributes(configuration));
        Boolean stopInMainFlag = AbstractParallelLaunchConfigurationDelegate.getDebuggerStopInMainFlag(configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerStopInMainFlagAttributeDefinition().create(stopInMainFlag));
        String wd = this.verifyWorkDirectory(configuration);
        if (wd != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(wd));
        }
        if ((argArr = this.getProgramParameters(configuration)) != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])argArr));
        }
        if ((envArr = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration)) != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getEnvironmentAttributeDefinition().create((Comparable[])envArr));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getLaunchedByPTPFlagAttributeDefinition().create(Boolean.valueOf(true)));
        return attrMgr;
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        IPDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = PTPDebugCorePlugin.getDefault().getDebugConfiguration(AbstractParallelLaunchConfigurationDelegate.getDebuggerID(config));
        }
        catch (CoreException e) {
            System.out.println("ParallelLaunchConfigurationDelegate.getDebugConfig() Error");
            throw e;
        }
        return dbgCfg;
    }

    protected IPath getProgramFile(ILaunchConfiguration configuration) throws CoreException {
        Path programPath;
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        if (fileName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_not_specified"), null, 1);
        }
        if (!(programPath = new Path(fileName)).isAbsolute()) {
            programPath = project.getFile((IPath)programPath).getLocation();
        }
        if (!programPath.toFile().exists()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Path_not_found", programPath.toString())), 104);
        }
        return programPath;
    }

    protected String[] getProgramParameters(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        String temp = AbstractParallelLaunchConfigurationDelegate.getArguments(configuration);
        if (temp != null && temp.length() > 0) {
            arguments.add(temp);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    protected IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        String rmUniqueName = AbstractParallelLaunchConfigurationDelegate.getResourceManagerUniqueName(configuration);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return rm;
            }
            ++n2;
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitJob(ILaunchConfiguration configuration, String mode, IPLaunch launch, AttributeManager attrMgr, IPDebugger debugger, IProgressMonitor monitor) throws CoreException {
        Map<IPJob, JobSubmission> map = this.jobSubmissions;
        synchronized (map) {
            IPJob job;
            IResourceManager rm = this.getResourceManager(configuration);
            if (rm == null) {
                this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.No_ResourceManager"), null, 0);
            }
            if ((job = rm.submitJob(configuration, attrMgr, monitor)) != null) {
                JobSubmission jobSub = new JobSubmission(configuration, mode, launch, attrMgr, debugger);
                this.jobSubmissions.put(job, jobSub);
            }
        }
    }

    protected IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration) throws CoreException {
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        Path programPath = new Path(fileName);
        if (!programPath.isAbsolute()) {
            programPath = project.getFile((IPath)programPath).getLocation();
        }
        return this.verifyBinary(project, (IPath)programPath);
    }

    protected IBinaryParser.IBinaryObject verifyBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        FileNotFoundException exception = new FileNotFoundException(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Program_is_not_a_recongnized_executable"));
        int code = 107;
        MultiStatus status = new MultiStatus(PTPCorePlugin.getUniqueIdentifier(), code, LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Program_is_not_a_recongnized_executable"), (Throwable)exception);
        status.add((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), code, exception == null ? "" : exception.getLocalizedMessage(), (Throwable)exception));
        throw new CoreException((IStatus)status);
    }

    protected void verifyDebuggerPath(String dbgPath, ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.verifyResource(dbgPath, configuration);
        if (path == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Debugger_path_not_found"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Path_not_found", dbgPath)), 104);
        }
    }

    protected IPath verifyExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        String exePath = AbstractParallelLaunchConfigurationDelegate.getExecutablePath(configuration);
        IPath path = this.verifyResource(exePath, configuration);
        if (path == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Application_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Path_not_found", exePath)), 1);
        }
        return path;
    }

    protected boolean verifyPath(String path) {
        Path programPath = new Path(path);
        return programPath != null && !programPath.isEmpty() && programPath.toFile().exists();
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String proName = AbstractParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (proName == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_not_specified"), null, 1);
        }
        if ((project = this.getProject(proName)) == null || !project.exists() || !project.isOpen()) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Project_does_not_exist_or_is_not_a_project"), null, 1);
        }
        return project;
    }

    protected IPath verifyResource(String path, ILaunchConfiguration configuration) throws CoreException {
        IResourceManagerConfiguration conf;
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        if (rm != null && (conf = rm.getConfiguration()) instanceof AbstractRemoteResourceManagerConfiguration) {
            AbstractRemoteResourceManagerConfiguration remConf = (AbstractRemoteResourceManagerConfiguration)conf;
            IRemoteServices remoteServices = PTPRemotePlugin.getDefault().getRemoteServices(remConf.getRemoteServicesId());
            if (remoteServices != null) {
                IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
                IRemoteConnection conn = connMgr.getConnection(remConf.getConnectionName());
                IRemoteFileManager fileManager = remoteServices.getFileManager(conn);
                try {
                    Path resPath = new Path(path);
                    IFileStore res = fileManager.getResource((IPath)resPath, (IProgressMonitor)new NullProgressMonitor());
                    if (res.fetchInfo().exists()) {
                        return resPath;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workPath = AbstractParallelLaunchConfigurationDelegate.getWorkDirectory(configuration);
        IPath path = workPath == null ? this.verifyExecutablePath(configuration).removeLastSegments(1) : this.verifyResource(workPath, configuration);
        if (path == null) {
            this.abort(LaunchMessages.getResourceString("AbstractParallelLaunchConfigurationDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedResourceString("AbstractParallelLaunchConfigurationDelegate.Path_not_found", path.toString())), 1);
        }
        return path.toString();
    }

    private class JobSubmission {
        private ILaunchConfiguration configuration;
        private String mode;
        private IPLaunch launch;
        private AttributeManager attrMgr;
        private IPDebugger debugger;

        public JobSubmission(ILaunchConfiguration configuration, String mode, IPLaunch launch, AttributeManager attrMgr, IPDebugger debugger) {
            this.configuration = configuration;
            this.mode = mode;
            this.launch = launch;
            this.attrMgr = attrMgr;
            this.debugger = debugger;
        }

        public AttributeManager getAttrMgr() {
            return this.attrMgr;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.configuration;
        }

        public IPDebugger getDebugger() {
            return this.debugger;
        }

        public IPLaunch getLaunch() {
            return this.launch;
        }

        public String getMode() {
            return this.mode;
        }
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.addChildListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerChildListener);
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            e.getResourceManager().removeChildListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerChildListener);
        }
    }

    private final class QueueChildListener
    implements IQueueChildListener {
        private QueueChildListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(IChangedJobEvent e) {
            for (IPJob job : e.getJobs()) {
                JobAttributes.State state;
                IAttribute attr = job.getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition());
                if (attr == null || (state = (JobAttributes.State)((EnumeratedAttribute)attr).getValue()) != JobAttributes.State.RUNNING) continue;
                Map<IPJob, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
                synchronized (map) {
                    JobSubmission jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(job);
                    if (jobSub != null) {
                        AbstractParallelLaunchConfigurationDelegate.this.doCompleteJobLaunch(jobSub.getConfiguration(), jobSub.getMode(), jobSub.getLaunch(), jobSub.getAttrMgr(), jobSub.getDebugger(), job);
                        AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.remove(job);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(INewJobEvent e) {
            for (IPJob job : e.getJobs()) {
                IAttribute launchAttr = job.getAttribute((IAttributeDefinition)JobAttributes.getLaunchedByPTPFlagAttributeDefinition());
                if (launchAttr == null || !((BooleanAttribute)launchAttr).getValue().booleanValue()) continue;
                Map<IPJob, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
                synchronized (map) {
                    JobSubmission jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(job);
                    IAttribute debugAttr = job.getAttribute((IAttributeDefinition)JobAttributes.getDebugFlagAttributeDefinition());
                    if (debugAttr != null) {
                        ((BooleanAttribute)debugAttr).getValue().booleanValue();
                    }
                }
            }
        }

        public void handleEvent(IRemoveJobEvent e) {
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private RMChildListener() {
        }

        public void handleEvent(IChangedMachineEvent e) {
        }

        public void handleEvent(IChangedQueueEvent e) {
        }

        public void handleEvent(INewMachineEvent e) {
        }

        public void handleEvent(INewQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.addChildListener(AbstractParallelLaunchConfigurationDelegate.this.queueChildListener);
            }
        }

        public void handleEvent(IRemoveMachineEvent e) {
        }

        public void handleEvent(IRemoveQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.removeChildListener(AbstractParallelLaunchConfigurationDelegate.this.queueChildListener);
            }
        }
    }
}

