/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchImages;
import org.eclipse.ptp.launch.internal.ui.LaunchMessages;
import org.eclipse.ptp.launch.ui.PLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourcesTab
extends PLaunchConfigurationTab {
    private Combo queueCombo;
    private final WidgetListener combosListener = new WidgetListener();
    private ScrolledComposite launchAttrsScrollComposite;
    private final Map<Integer, IPQueue> queues = new HashMap<Integer, IPQueue>();
    private final Map<IPQueue, Integer> queueIndices = new HashMap<IPQueue, Integer>();
    private ILaunchConfiguration launchConfiguration = null;
    private final Map<IResourceManager, IRMLaunchConfigurationDynamicTab> rmDynamicTabs = new HashMap<IResourceManager, IRMLaunchConfigurationDynamicTab>();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();

    public boolean canSave() {
        this.setErrorMessage(null);
        IResourceManager rm = this.getResourceManager(this.getLaunchConfiguration());
        if (rm == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
            return false;
        }
        IPQueue queue = this.getQueueFromCombo();
        if (queue == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Queue"));
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (rmDynamicTab == null || launchComp == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Control", rm.getName()));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.canSave((Control)launchComp, rm, queue);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        new Label(comp, 0).setText(LaunchMessages.getResourceString("ResourcesTab.Queue_Label"));
        this.queueCombo = new Combo(comp, 8);
        this.queueCombo.addSelectionListener((SelectionListener)this.combosListener);
        Group attrGroup = new Group(comp, 16);
        attrGroup.setText(LaunchMessages.getResourceString("ResourcesTab.Launch_Attributes"));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        attrGroup.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        attrGroup.setLayout((Layout)gridLayout);
        ScrolledComposite scrollComp = this.createLaunchAttributeControlComposite((Composite)attrGroup, 2);
        this.setLaunchAttrsScrollComposite(scrollComp);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.launch.parallel_tab.gif");
    }

    public String getName() {
        return LaunchMessages.getResourceString("ResourcesTab.Resources");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            IResourceManager rm = this.getResourceManager(configuration);
            if (rm == null) {
                this.queueCombo.setEnabled(false);
                this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
                return;
            }
            this.queueCombo.setEnabled(rm.getQueues().length > 1);
            this.loadQueueCombo(rm);
            IPQueue queue = this.getQueueFromName(rm, configuration.getAttribute("org.eclipse.ptp.launch.QUEUE_NAME", ""));
            if (queue == null) {
                this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.Invalid_Queue"));
                return;
            }
            this.setQueueComboSelection(queue);
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
            ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
            if (rmDynamicTab == null || launchComp == null) {
                this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", rm.getName()));
                return;
            }
            this.updateLaunchAttributeControls(rm, queue, this.getLaunchConfiguration());
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("CommonTab.common.Exception_occurred_reading_configuration_EXCEPTION", e.getStatus().getMessage()));
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        IRMLaunchConfigurationDynamicTab rmDynamicTab;
        IPQueue queue;
        IResourceManager rm;
        block9: {
            block8: {
                block7: {
                    this.setErrorMessage(null);
                    this.setMessage(null);
                    try {
                        rm = this.getResourceManager(configuration);
                        if (rm != null) break block7;
                        this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
                        return false;
                    }
                    catch (CoreException e) {
                        this.setErrorMessage(LaunchMessages.getFormattedResourceString("CommonTab.common.Exception_occurred_reading_configuration_EXCEPTION", e.getStatus().getMessage()));
                        return false;
                    }
                }
                this.loadQueueCombo(rm);
                queue = this.getQueueFromName(rm, configuration.getAttribute("org.eclipse.ptp.launch.QUEUE_NAME", ""));
                if (queue != null) break block8;
                this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.Invalid_Queue"));
                return false;
            }
            assert (queue == this.getQueueFromCombo());
            rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
            if (rmDynamicTab != null) break block9;
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", rm.getName()));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.isValid(configuration, rm, queue);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.QUEUE_NAME", this.getQueueNameFromCombo());
        IResourceManager rm = this.getResourceManager((ILaunchConfiguration)configuration);
        if (rm != null) {
            RMLaunchValidation validation;
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
            if (rmDynamicTab == null) {
                this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", rm.getName()));
                return;
            }
            IPQueue queue = this.getQueueFromCombo();
            if (queue != null && !(validation = rmDynamicTab.performApply(configuration, rm, queue)).isSuccess()) {
                this.setErrorMessage(validation.getMessage());
                return;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResourceManager rm = this.getResourceManager((ILaunchConfiguration)configuration);
        if (rm == null) {
            this.setErrorMessage(LaunchMessages.getResourceString("ResourcesTab.No_Resource_Manager"));
            return;
        }
        IPQueue queue = this.getQueueDefault(rm);
        String queueName = queue != null ? queue.getName() : "";
        configuration.setAttribute("org.eclipse.ptp.launch.QUEUE_NAME", queueName);
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        if (rmDynamicTab == null) {
            this.setErrorMessage(LaunchMessages.getFormattedResourceString("ResourcesTab.No_Launch_Configuration", rm.getName()));
        } else {
            rmDynamicTab.setDefaults(configuration, rm, queue);
        }
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    private ScrolledComposite createLaunchAttributeControlComposite(Composite parent, int colspan) {
        ScrolledComposite attrComp = new ScrolledComposite(parent, 2816);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = colspan;
        attrComp.setLayoutData((Object)gridData);
        attrComp.setExpandHorizontal(true);
        attrComp.setExpandVertical(true);
        return attrComp;
    }

    private IRMLaunchConfigurationDynamicTab createRMLaunchConfigurationDynamicTab(IResourceManager rm) throws CoreException {
        AbstractRMLaunchConfigurationFactory rmFactory = PTPLaunchPlugin.getDefault().getRMLaunchConfigurationFactory(rm);
        if (rmFactory == null) {
            return null;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = rmFactory.create(rm);
        if (rmDynamicTab == null) {
            return null;
        }
        rmDynamicTab.addContentsChangedListener(this.launchContentsChangedListener);
        return rmDynamicTab;
    }

    private ScrolledComposite getLaunchAttrsScrollComposite() {
        return this.launchAttrsScrollComposite;
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    private IPQueue getQueueDefault(IResourceManager rm) {
        IPQueue[] queues = rm.getQueues();
        if (queues.length == 0) {
            return null;
        }
        return queues[0];
    }

    private IPQueue getQueueFromCombo() {
        if (this.queueCombo != null) {
            int i = this.queueCombo.getSelectionIndex();
            return this.queues.get(i);
        }
        return null;
    }

    private IPQueue getQueueFromName(IResourceManager rm, String queueName) {
        IPQueue[] queues;
        if (rm == null) {
            return null;
        }
        IPQueue[] iPQueueArray = queues = rm.getQueues();
        int n = queues.length;
        int n2 = 0;
        while (n2 < n) {
            IPQueue queue = iPQueueArray[n2];
            if (queue.getName().equals(queueName)) {
                return queue;
            }
            ++n2;
        }
        return null;
    }

    private String getQueueNameFromCombo() {
        IPQueue queue = this.getQueueFromCombo();
        if (queue == null) {
            return "";
        }
        return queue.getName();
    }

    private IRMLaunchConfigurationDynamicTab getRMLaunchConfigurationDynamicTab(IResourceManager rm) {
        if (!this.rmDynamicTabs.containsKey(rm)) {
            try {
                IRMLaunchConfigurationDynamicTab rmDynamicTab = this.createRMLaunchConfigurationDynamicTab(rm);
                this.rmDynamicTabs.put(rm, rmDynamicTab);
                return rmDynamicTab;
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e);
                return null;
            }
        }
        return this.rmDynamicTabs.get(rm);
    }

    private void loadQueueCombo(IResourceManager rm) {
        this.queueCombo.removeAll();
        this.queues.clear();
        if (rm == null) {
            return;
        }
        IPQueue[] qs = rm.getQueues();
        int i = 0;
        while (i < qs.length) {
            this.queueCombo.add(qs[i].getName());
            this.queues.put(i, qs[i]);
            this.queueIndices.put(qs[i], i);
            ++i;
        }
        this.queueCombo.select(0);
    }

    private void queueSelectionChanged() {
        IResourceManager rm = this.getResourceManager(this.getLaunchConfiguration());
        IPQueue queue = this.getQueueFromCombo();
        this.updateLaunchAttributeControls(rm, queue, this.getLaunchConfiguration());
        this.updateLaunchConfigurationDialog();
    }

    private void setLaunchAttrsScrollComposite(ScrolledComposite comp) {
        this.launchAttrsScrollComposite = comp;
    }

    private void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
    }

    private void setQueueComboSelection(IPQueue queue) {
        Integer results = this.queueIndices.get(queue);
        int i = 0;
        if (results != null) {
            i = results;
        }
        this.queueCombo.select(i);
        this.queueSelectionChanged();
    }

    private void updateLaunchAttributeControls(IResourceManager rm, IPQueue queue, ILaunchConfiguration launchConfiguration) {
        ScrolledComposite launchAttrsScrollComp = this.getLaunchAttrsScrollComposite();
        launchAttrsScrollComp.setContent(null);
        Control[] controlArray = launchAttrsScrollComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        if (rmDynamicTab != null) {
            try {
                rmDynamicTab.createControl((Composite)launchAttrsScrollComp, rm, queue);
                Control dynControl = rmDynamicTab.getControl();
                launchAttrsScrollComp.setContent(dynControl);
                Point size = dynControl.computeSize(-1, -1);
                launchAttrsScrollComp.setMinSize(size);
                rmDynamicTab.initializeFrom((Control)launchAttrsScrollComp, rm, queue, launchConfiguration);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e);
            }
        }
        launchAttrsScrollComp.layout(true);
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            ResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }

    private final class WidgetListener
    extends SelectionAdapter {
        private WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == ResourcesTab.this.queueCombo) {
                ResourcesTab.this.queueSelectionChanged();
            }
        }
    }
}

