/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.orte.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.orte.core.ORTEPreferenceManager;
import org.eclipse.ptp.rm.orte.core.rmsystem.ORTEResourceManager;
import org.eclipse.ptp.rm.orte.core.rmsystem.ORTEResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ui.IMemento;

public class ORTEResourceManagerFactory
extends AbstractResourceManagerFactory {
    public ORTEResourceManagerFactory() {
        super("ORTE");
    }

    public IResourceManagerConfiguration copyConfiguration(IResourceManagerConfiguration configuration) {
        return (IResourceManagerConfiguration)configuration.clone();
    }

    public IResourceManagerControl create(IResourceManagerConfiguration confIn) {
        ORTEResourceManagerConfiguration configuration = (ORTEResourceManagerConfiguration)confIn;
        PTPCorePlugin plugin = PTPCorePlugin.getDefault();
        IPUniverseControl universe = (IPUniverseControl)plugin.getUniverse();
        return new ORTEResourceManager(universe.getNextResourceManagerId(), universe, (IResourceManagerConfiguration)configuration);
    }

    public IResourceManagerConfiguration createConfiguration() {
        ORTEResourceManagerConfiguration conf = new ORTEResourceManagerConfiguration(this);
        Preferences preferences = ORTEPreferenceManager.getPreferences();
        conf.setProxyServerPath(preferences.getString("PROXY_PATH"));
        conf.setOptions(preferences.getInt("OPTIONS"));
        return conf;
    }

    public IResourceManagerConfiguration loadConfiguration(IMemento memento) {
        return ORTEResourceManagerConfiguration.load(this, memento);
    }
}

