/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.view;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.view.ArtifactWithParent;
import org.eclipse.ptp.pldt.mpi.analysis.view.MPIArtifactMarkingVisitor;

public class BarrierArtifacts {
    private ICallGraph CG_;
    private ScanReturn scanReturn_;
    private MPIArtifactMarkingVisitor visitor_;
    private String markerID = "org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMarker";

    public BarrierArtifacts(ICallGraph cg, MPIArtifactMarkingVisitor visitor) {
        this.CG_ = cg;
        this.visitor_ = visitor;
    }

    public void run() {
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            int depth = 2;
            wsResource.deleteMarkers(this.markerID, false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        ICallGraphNode n = this.CG_.topEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            List<BarrierTable.BarrierInfo> barriers = node.getAllBarriers();
            this.scanReturn_ = new ScanReturn();
            for (BarrierTable.BarrierInfo bar : barriers) {
                SourceInfo sourceInfo = bar.getSourceInfo();
                ArtifactWithParent awp = new ArtifactWithParent(node.getFileName(), sourceInfo.getStartingLine(), 1, node.getFuncName(), "Artifact Call", sourceInfo, 0, 0, "", bar.getID() - 4);
                this.scanReturn_.addArtifact((Artifact)awp);
            }
            this.visitor_.visitFile(node.getResource(), this.scanReturn_.getArtifactList());
            n = n.topNext();
        }
    }
}

