/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.remote.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.IRemoteServices;
import org.eclipse.ptp.remote.PTPRemotePlugin;
import org.eclipse.ptp.remote.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.remote.ui.Messages;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRemoteResourceManagerConfigurationWizardPage
extends RMConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private AbstractRemoteResourceManagerConfiguration config;
    private String proxyFile = "";
    private String proxyArgs = "";
    private String localAddr = "";
    private IRemoteServices remoteServices = null;
    private IRemoteConnectionManager connectionManager = null;
    private IRemoteConnection connection = null;
    private boolean loading = true;
    private boolean isValid;
    private boolean muxPortFwd = false;
    private boolean portFwdSupported = true;
    private boolean manualLaunch = false;
    private Text serverText = null;
    private Button optionsButton = null;
    private Button browseButton = null;
    private Button noneButton = null;
    private Button portForwardingButton = null;
    private Button manualButton = null;
    private WidgetListener listener = new WidgetListener();
    private Button newConnectionButton;
    private Combo remoteCombo;
    private Combo connectionCombo;
    private Combo localAddrCombo;

    public AbstractRemoteResourceManagerConfigurationWizardPage(RMConfigurationWizard wizard, String title) {
        super(wizard, title);
        this.setPageComplete(false);
        this.isValid = false;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    public void initializeLocalHostCombo() {
        TreeSet<String> addrs = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> alladdr = ni.getInetAddresses();
                while (alladdr.hasMoreElements()) {
                    InetAddress ip = alladdr.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    addrs.add(this.fixHostName(ip.getCanonicalHostName()));
                }
            }
        }
        catch (Exception exception) {}
        if (addrs.size() == 0) {
            addrs.add("localhost");
        }
        this.localAddrCombo.removeAll();
        int index = 0;
        int selection = -1;
        for (String addr : addrs) {
            this.localAddrCombo.add(addr);
            if (this.localAddr.equals(EMPTY_STRING) && addr.equals("localhost") || addr.equals(this.localAddr)) {
                selection = index;
            }
            ++index;
        }
        if (selection < 0) {
            if (!this.localAddr.equals(EMPTY_STRING)) {
                this.localAddrCombo.add(this.localAddr);
            }
            selection = this.localAddrCombo.getItemCount() - 1;
        }
        this.localAddrCombo.select(selection);
    }

    public boolean performOk() {
        this.store();
        int options = 0;
        if (this.muxPortFwd) {
            options |= 2;
        }
        if (this.manualLaunch) {
            options |= 4;
        }
        if (this.remoteServices != null) {
            this.config.setRemoteServicesId(this.remoteServices.getId());
        }
        if (this.connection != null) {
            this.config.setConnectionName(this.connection.getName());
        }
        this.config.setLocalAddress(this.localAddr);
        this.config.setProxyServerPath(this.proxyFile);
        this.config.setInvocationOptions(this.proxyArgs);
        this.config.setOptions(options);
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initContents();
        }
        super.setVisible(visible);
    }

    private void createContents(Composite parent) {
        Composite remoteComp = new Composite(parent, 0);
        GridLayout remoteLayout = new GridLayout();
        remoteLayout.numColumns = 4;
        remoteLayout.marginWidth = 0;
        remoteComp.setLayout((Layout)remoteLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        remoteComp.setLayoutData((Object)gd);
        Label label = new Label(remoteComp, 0);
        label.setText(Messages.getString("RemoteConfigurationWizard.provider"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.remoteCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.remoteCombo.setLayoutData((Object)gd);
        label = new Label(remoteComp, 0);
        label.setText(Messages.getString("RemoteConfigurationWizard.location"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.connectionCombo.setLayoutData((Object)gd);
        this.newConnectionButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.getString("RemoteConfigurationWizard.newButton"), null);
        label = new Label(remoteComp, 0);
        label.setText(Messages.getString("RemoteConfigurationWizard.path"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.serverText = new Text(remoteComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 100;
        this.serverText.setLayoutData((Object)gd);
        this.serverText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.getString("RemoteConfigurationWizard.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        this.optionsButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.getString("RemoteConfigurationWizard.optionsButton"), null);
        this.optionsButton.addSelectionListener((SelectionListener)this.listener);
        Group mxGroup = new Group(parent, 16);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.getString("RemoteConfigurationWizard.mxOptions"));
        this.noneButton = this.createRadioButton((Composite)mxGroup, Messages.getString("RemoteConfigurationWizard.noneButton"), "mxGroup", (SelectionListener)this.listener);
        this.noneButton.addSelectionListener((SelectionListener)this.listener);
        Composite addrComp = new Composite((Composite)mxGroup, 0);
        GridLayout addrLayout = new GridLayout();
        addrLayout.numColumns = 2;
        addrLayout.marginWidth = 0;
        addrLayout.marginLeft = 15;
        addrComp.setLayout((Layout)addrLayout);
        gd = new GridData(768);
        addrComp.setLayoutData((Object)gd);
        label = new Label(addrComp, 0);
        label.setText(Messages.getString("RemoteConfigurationWizard.localAddress"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.localAddrCombo = new Combo(addrComp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.localAddrCombo.setLayoutData((Object)gd);
        this.portForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.getString("RemoteConfigurationWizard.portForwardingButton"), "mxGroup", (SelectionListener)this.listener);
        this.portForwardingButton.addSelectionListener((SelectionListener)this.listener);
        this.manualButton = this.createCheckButton(parent, Messages.getString("RemoteConfigurationWizard.manualButton"));
        this.manualButton.addSelectionListener((SelectionListener)this.listener);
        this.registerListeners();
    }

    private String fixHostName(String hostname) {
        try {
            if (hostname.endsWith(".in-addr.arpa")) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostname;
    }

    private void initContents() {
        this.loading = true;
        this.config = (AbstractRemoteResourceManagerConfiguration)this.getConfigurationWizard().getConfiguration();
        this.loadSaved();
        this.updateSettings();
        this.defaultSetting();
        this.initializeRemoteServicesCombo();
        this.initializeLocalHostCombo();
        this.updatePage();
        this.loading = false;
    }

    private void loadSaved() {
        int options;
        this.proxyFile = this.config.getProxyServerPath();
        this.proxyArgs = this.config.getInvocationOptionsStr();
        this.localAddr = this.config.getLocalAddress();
        String rmID = this.config.getRemoteServicesId();
        if (rmID != null) {
            this.remoteServices = PTPRemotePlugin.getDefault().getRemoteServices(rmID);
            String conn = this.config.getConnectionName();
            if (this.remoteServices != null && conn != null) {
                this.connection = this.remoteServices.getConnectionManager().getConnection(conn);
            }
        }
        this.muxPortFwd = ((options = this.config.getOptions()) & 2) == 2;
        this.manualLaunch = (options & 4) == 4;
    }

    private void registerListeners() {
        this.remoteCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleRemoteServiceSelected();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateSettings();
            }
        });
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleConnectionSelected();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
        this.newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleNewRemoteConnectionSelected();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
        this.localAddrCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateSettings();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        });
    }

    private void setValid(boolean complete) {
        this.isValid = complete;
        this.setPageComplete(this.isValid);
    }

    private void store() {
        if (this.serverText != null) {
            this.proxyFile = this.serverText.getText();
        }
    }

    private void updateSettings() {
        if (!this.loading) {
            this.muxPortFwd = this.portForwardingButton.getSelection();
            this.manualLaunch = this.manualButton.getSelection();
        }
        if (!this.loading || this.localAddr.equals(EMPTY_STRING)) {
            this.localAddr = this.localAddrCombo.getText();
        }
        if (this.muxPortFwd && !this.portFwdSupported) {
            this.muxPortFwd = false;
        }
        if (this.muxPortFwd && this.manualLaunch) {
            this.manualLaunch = false;
        }
        if (this.noneButton != null) {
            this.noneButton.setSelection(!this.muxPortFwd);
        }
        if (this.portForwardingButton != null) {
            this.portForwardingButton.setSelection(this.muxPortFwd);
            this.portForwardingButton.setEnabled(this.portFwdSupported);
        }
        if (this.localAddrCombo != null) {
            this.localAddrCombo.setEnabled(!this.muxPortFwd);
        }
        if (this.manualButton != null) {
            this.manualButton.setSelection(this.manualLaunch && !this.muxPortFwd);
            this.manualButton.setEnabled(!this.muxPortFwd);
        }
    }

    protected String createOptionsDialog(Shell shell, String initialOptions) {
        InputDialog dialog = new InputDialog(shell, Messages.getResourceString("RemoteConfigurationWizard.optionsTitle"), Messages.getString("RemoteConfigurationWizard.options"), initialOptions, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return initialOptions;
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected void defaultSetting() {
        this.serverText.setText(this.proxyFile);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected void handleConnectionSelected() {
        int currentSelection = this.connectionCombo.getSelectionIndex();
        if (currentSelection >= 0 && this.connectionManager != null) {
            String connectionName = this.connectionCombo.getItem(currentSelection);
            this.connection = this.connectionManager.getConnection(connectionName);
        }
        if (this.connection != null) {
            this.portFwdSupported = this.connection.supportsTCPPortForwarding();
        }
        this.updateSettings();
        this.updatePage();
    }

    protected void handleNewRemoteConnectionSelected() {
        if (this.connectionManager != null) {
            this.connectionManager.newConnection(this.getShell());
            this.handleRemoteServiceSelected();
        }
    }

    protected void handlePathBrowseButtonSelected() {
        if (this.connection != null) {
            if (!this.connection.isOpen()) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            AbstractRemoteResourceManagerConfigurationWizardPage.this.connection.open(monitor);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException(Messages.getString("RemoteConfigurationWizard.cancelMessage"));
                            }
                        }
                        catch (RemoteConnectionException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("RemoteConfigurationWizard.connectionError"), (String)Messages.getString("RemoteConfigurationWizard.connectionErrorMessage"), (IStatus)new Status(4, "org.eclipse.ptp.rm.remote", e.getCause().getMessage()));
                }
                catch (InterruptedException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.getString("RemoteConfigurationWizard.connectionError"), (String)Messages.getString("RemoteConfigurationWizard.connectionErrorMessage"), (IStatus)new Status(4, "org.eclipse.ptp.rm.remote", e.getMessage()));
                }
            }
            if (this.connection.isOpen()) {
                IRemoteFileManager fileMgr = this.remoteServices.getFileManager(this.connection);
                String correctPath = this.serverText.getText();
                IPath selectedPath = fileMgr.browseFile(this.getShell(), Messages.getString("RemoteConfigurationWizard.select"), correctPath);
                if (selectedPath != null) {
                    this.serverText.setText(selectedPath.toString());
                }
            }
        }
    }

    protected void handleRemoteServiceSelected() {
        IRemoteServices[] allRemoteServices = PTPRemotePlugin.getDefault().getAllRemoteServices();
        int selectionIndex = this.remoteCombo.getSelectionIndex();
        if (allRemoteServices != null && allRemoteServices.length > 0 && selectionIndex >= 0) {
            this.remoteServices = allRemoteServices[selectionIndex];
            this.connectionManager = this.remoteServices.getConnectionManager();
            IRemoteConnection[] connections = this.connectionManager.getConnections();
            this.connectionCombo.removeAll();
            int selected = connections.length - 1;
            int i = 0;
            while (i < connections.length) {
                this.connectionCombo.add(connections[i].getName());
                if (this.connection != null && connections[i].equals(this.connection)) {
                    selected = i;
                }
                ++i;
            }
            if (connections.length > 0) {
                if (!this.loading) {
                    selected = connections.length - 1;
                    this.connection = null;
                }
                this.connectionCombo.select(selected);
                this.handleConnectionSelected();
            }
            this.newConnectionButton.setEnabled(this.connectionManager.supportsNewConnections());
        }
    }

    protected void initializeRemoteServicesCombo() {
        IRemoteServices[] allServices = PTPRemotePlugin.getDefault().getAllRemoteServices();
        IRemoteServices defServices = this.remoteServices != null ? this.remoteServices : PTPRemotePlugin.getDefault().getDefaultServices();
        int defIndex = allServices.length - 1;
        this.remoteCombo.removeAll();
        int i = 0;
        while (i < allServices.length) {
            this.remoteCombo.add(allServices[i].getName());
            if (allServices[i].equals(defServices)) {
                defIndex = i;
            }
            ++i;
        }
        if (allServices.length > 0) {
            this.remoteCombo.select(defIndex);
            this.handleRemoteServiceSelected();
            this.handleConnectionSelected();
        }
    }

    protected boolean isValidSetting() {
        String name;
        if (this.serverText != null && (name = this.getFieldContent(this.serverText.getText())) == null) {
            this.setErrorMessage(Messages.getString("RemoteConfigurationWizard.invalid"));
            return false;
        }
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            this.setValid(false);
        } else {
            this.performOk();
            this.setValid(true);
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!AbstractRemoteResourceManagerConfigurationWizardPage.this.loading && source == AbstractRemoteResourceManagerConfigurationWizardPage.this.serverText) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.browseButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handlePathBrowseButtonSelected();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.optionsButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.proxyArgs = AbstractRemoteResourceManagerConfigurationWizardPage.this.createOptionsDialog(AbstractRemoteResourceManagerConfigurationWizardPage.this.getShell(), AbstractRemoteResourceManagerConfigurationWizardPage.this.proxyArgs);
            } else {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateSettings();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updatePage();
            }
        }
    }
}

