/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rdt.services.Activator;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceModelManager;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.internal.core.Service;
import org.eclipse.ptp.rdt.services.internal.core.ServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.ui.IServiceProviderConfiguration;
import org.eclipse.ptp.rdt.services.ui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelManager
implements IServiceModelManager {
    private static final String SERVICE_EXTENSION_ID = "services";
    private static final String PROVIDER_EXTENSION_ID = "providers";
    private static final String SERVICE_ELEMENT_NAME = "service";
    private static final String NATURE_ELEMENT_NAME = "nature";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SERVICE_ID = "serviceId";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_UI_CLASS = "configurationUIClass";
    private Map<IProject, Set<IServiceConfiguration>> projectConfigurations = new HashMap<IProject, Set<IServiceConfiguration>>();
    private Map<IProject, IServiceConfiguration> activeConfigurations = new HashMap<IProject, IServiceConfiguration>();
    private Map<String, IServiceConfiguration> configurations = new HashMap<String, IServiceConfiguration>();
    private Map<IProject, Set<IService>> projectServices = new HashMap<IProject, Set<IService>>();
    private Map<String, IService> services = null;
    private Map<String, IServiceProviderDescriptor> serviceProviders = null;
    private Set<IService> serviceSet = null;
    private Map<String, Set<IService>> natureServices = null;

    @Override
    public void addConfiguration(IProject project, IServiceConfiguration conf) {
        Set<IServiceConfiguration> confs = this.projectConfigurations.get(project);
        if (confs != null) {
            confs.add(conf);
        }
    }

    @Override
    public IServiceConfiguration getActiveConfiguration(IProject project) {
        return this.activeConfigurations.get(project);
    }

    @Override
    public IServiceConfiguration getConfiguration(IProject project, String name) {
        return this.configurations.get(name);
    }

    @Override
    public Set<IServiceConfiguration> getConfigurations(IProject project) {
        return this.projectConfigurations.get(project);
    }

    public IServiceProvider getServiceProvider(IServiceProviderDescriptor desc) {
        IServiceProvider provider = null;
        IExtension extension = Platform.getExtensionRegistry().getExtension(desc.getId());
        if (extension != null) {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(PROVIDER_ELEMENT_NAME)) {
                    try {
                        provider = (IServiceProvider)element.createExecutableExtension(ATTR_CLASS);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return provider;
    }

    public IServiceProviderConfiguration getServiceProviderConfigurationUI(IServiceProviderDescriptor desc) {
        IServiceProviderConfiguration config = null;
        IExtension extension = Platform.getExtensionRegistry().getExtension(desc.getId());
        if (extension != null) {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(PROVIDER_ELEMENT_NAME)) {
                    try {
                        config = (IServiceProviderConfiguration)element.createExecutableExtension(ATTR_UI_CLASS);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return config;
    }

    @Override
    public Set<IService> getServices() {
        this.loadServices();
        return this.serviceSet;
    }

    @Override
    public Set<IService> getServices(IProject project) {
        return this.projectServices.get(project);
    }

    @Override
    public Set<IService> getServices(String natureId) {
        this.loadServices();
        return this.natureServices.get(natureId);
    }

    @Override
    public void removeConfiguration(IProject project, IServiceConfiguration conf) {
        Set<IServiceConfiguration> confs = this.projectConfigurations.get(project);
        if (confs != null) {
            confs.remove(conf);
        }
    }

    @Override
    public void setActiveConfiguration(IProject project, IServiceConfiguration configuration) {
        this.activeConfigurations.put(project, configuration);
    }

    private void loadServices() {
        IService service;
        String name;
        String id;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        int n3;
        int n4;
        IExtension[] iExtensionArray;
        if (this.services != null) {
            return;
        }
        this.services = new HashMap<String, IService>();
        this.serviceProviders = new HashMap<String, IServiceProviderDescriptor>();
        this.serviceSet = new HashSet<IService>();
        this.natureServices = new HashMap<String, Set<IService>>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", SERVICE_EXTENSION_ID);
        if (extensionPoint != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(SERVICE_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        IConfigurationElement[] natureConf = element.getChildren(NATURE_ELEMENT_NAME);
                        HashSet<String> natures = new HashSet<String>();
                        if (natureConf != null) {
                            IConfigurationElement[] iConfigurationElementArray2 = natureConf;
                            int n5 = natureConf.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement nature = iConfigurationElementArray2[n6];
                                String natureId = nature.getAttribute(ATTR_ID);
                                if (workspace.getNatureDescriptor(natureId) != null) {
                                    natures.add(natureId);
                                }
                                ++n6;
                            }
                        }
                        service = new Service(id, name, natures);
                        this.serviceSet.add(service);
                        this.services.put(id, service);
                        for (String nature : natures) {
                            Set<IService> svcs = this.natureServices.get(nature);
                            if (svcs == null) {
                                svcs = new HashSet<IService>();
                                this.natureServices.put(nature, svcs);
                            }
                            svcs.add(service);
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.services", PROVIDER_EXTENSION_ID)) != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(PROVIDER_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        String serviceId = element.getAttribute(ATTR_SERVICE_ID);
                        ServiceProviderDescriptor desc = new ServiceProviderDescriptor(id, name, serviceId);
                        service = this.services.get(id);
                        if (service != null) {
                            this.serviceProviders.put(id, desc);
                            service.addServiceProvider(desc);
                        } else {
                            Activator.getDefault().logErrorMessage(Messages.getFormattedString("Services_invalidServiceId", serviceId));
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
    }
}

