/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.ui.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ControlsRelationshipHandler {
    Map controlsRelationship;
    ControlRelationshipListener controlHandler;
    boolean enableWhenMasterEnabled;

    public ControlsRelationshipHandler(Map controlsRelationship, boolean enableWhenMasterEnabled) {
        this.controlsRelationship = controlsRelationship;
        this.controlHandler = new ControlRelationshipListener();
        this.enableWhenMasterEnabled = enableWhenMasterEnabled;
    }

    public ControlsRelationshipHandler() {
        this(new HashMap(), true);
    }

    public ControlsRelationshipHandler(Button master, Control[] slaves, boolean enableWhenTrue) {
        this(new HashMap(), enableWhenTrue);
        this.addControlRelationship(master, slaves);
    }

    public ControlsRelationshipHandler(Button master, Control slave, boolean enableWhenTrue) {
        this(new HashMap(), enableWhenTrue);
        this.addControlRelationship(master, slave);
    }

    public void addControlRelationship(Button master, Control[] slaves) {
        this.controlsRelationship.put(master, slaves);
        master.addSelectionListener((SelectionListener)this.controlHandler);
    }

    public void addControlRelationship(Button master, Control slave) {
        this.controlsRelationship.put(master, new Control[]{slave});
        master.addSelectionListener((SelectionListener)this.controlHandler);
    }

    public void deleteControlRelationship(Button master) {
        this.controlsRelationship.remove(master);
        master.removeSelectionListener((SelectionListener)this.controlHandler);
    }

    public void manageDependentControls(Button btn) {
        Set masterSet = this.controlsRelationship.keySet();
        for (Button master : masterSet) {
            Object obj = this.controlsRelationship.get(master);
            if (obj == null) continue;
            Control[] controlList = (Control[])obj;
            int i = 0;
            while (i < controlList.length) {
                if (btn == master && btn.getSelection()) {
                    controlList[i].setEnabled(this.enableWhenMasterEnabled);
                } else {
                    controlList[i].setEnabled(!this.enableWhenMasterEnabled);
                }
                ++i;
            }
        }
    }

    class ControlRelationshipListener
    extends SelectionAdapter {
        ControlRelationshipListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            ControlsRelationshipHandler.this.manageDependentControls((Button)arg0.widget);
        }
    }
}

