/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.ui.swt;

import org.eclipse.ptp.remotetools.utils.ui.swt.GenericControlMold;
import org.eclipse.ptp.remotetools.utils.ui.swt.TextMold;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class GenericControlGroup
extends Composite {
    Label label;
    Button button;
    Control customControl;
    boolean buttonEnabled = true;

    public GenericControlGroup(Composite parent, int bitmask, int rows, int chars) {
        super(parent, 0);
        this.createContents(bitmask, rows, chars);
    }

    public GenericControlGroup(Composite parent, GenericControlMold mold) {
        super(parent, 0);
        int rows = 0;
        int chars = 0;
        if (mold.hasHeight()) {
            rows = mold.getHeight();
        }
        if (mold.hasWidth()) {
            chars = mold.getWidth();
        }
        this.createContents(mold.bitmask, rows, chars);
        if (mold.label != null) {
            this.setLabel(mold.label);
        }
        if (mold.buttonLabel != null) {
            this.setButtonLabel(mold.buttonLabel);
        }
        if (mold.tooltip != null) {
            this.setToolTip(mold.tooltip);
        }
    }

    protected void createContents(int bitmask, int rows, int chars) {
        this.createLayout(bitmask);
        this.createLabel(bitmask);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.customControl = this.createCustomControl(bitmask, gd);
        if (rows > 0) {
            gd.heightHint = this.getControlCharHeight(this.customControl) * rows;
        }
        if (chars > 0) {
            gd.widthHint = this.getControlCharWidth(this.customControl) * chars;
        }
        this.customControl.setLayoutData((Object)gd);
        this.createButton(bitmask);
    }

    protected void createLayout(int bitmask) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 5;
        layout.numColumns = 1;
        if ((bitmask & GenericControlMold.HAS_LABEL) != 0 && (bitmask & GenericControlMold.LABELABOVE) == 0) {
            ++layout.numColumns;
        }
        if ((bitmask & GenericControlMold.HASBUTTON) != 0) {
            ++layout.numColumns;
        }
        this.setLayout((Layout)layout);
        if (this.getParent().getLayout() instanceof GridLayout && ((bitmask & TextMold.GRID_DATA_ALIGNMENT_FILL) != 0 || (bitmask & TextMold.GRID_DATA_GRAB_EXCESS_SPACE) != 0 || (bitmask & TextMold.GRID_DATA_SPAN) != 0)) {
            GridData gdpp = new GridData();
            if ((bitmask & GenericControlMold.GRID_DATA_ALIGNMENT_FILL) != 0) {
                gdpp.horizontalAlignment = 4;
            }
            if ((bitmask & GenericControlMold.GRID_DATA_GRAB_EXCESS_SPACE) != 0) {
                gdpp.grabExcessHorizontalSpace = true;
            }
            if ((bitmask & GenericControlMold.GRID_DATA_SPAN) != 0) {
                GridLayout glayout = (GridLayout)this.getParent().getLayout();
                gdpp.horizontalSpan = glayout.numColumns;
            }
            this.setLayoutData(gdpp);
        }
    }

    protected void createLabel(int bitmask) {
        if ((bitmask & GenericControlMold.HAS_LABEL) != 0) {
            this.label = new Label((Composite)this, 0);
            GridData gd = new GridData();
            gd.horizontalAlignment = 16384;
            gd.verticalAlignment = 0x1000000;
            gd.verticalSpan = 1;
            if ((bitmask & GenericControlMold.LABELABOVE) != 0) {
                gd.horizontalSpan = ((GridLayout)this.getLayout()).numColumns;
            }
            this.label.setLayoutData((Object)gd);
        }
    }

    protected abstract Control createCustomControl(int var1, GridData var2);

    protected void createButton(int bitmask) {
        if ((bitmask & GenericControlMold.HASBUTTON) != 0) {
            this.button = new Button((Composite)this, 524288);
            GridData gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.verticalAlignment = 128;
            gd.verticalSpan = 1;
            gd.horizontalSpan = 1;
            this.button.setLayoutData((Object)gd);
        }
    }

    protected int getControlCharWidth(Control control) {
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        int width = fm.getAverageCharWidth();
        gc.dispose();
        return width;
    }

    protected int getControlCharHeight(Control control) {
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        int height = fm.getHeight();
        gc.dispose();
        return height;
    }

    public Button getButton() {
        return this.button;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableButton();
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        this.customControl.setEnabled(enabled);
    }

    public void setButtonEnabled(boolean enabled) {
        this.buttonEnabled = enabled;
        this.enableButton();
    }

    private void enableButton() {
        if (this.button != null) {
            this.button.setEnabled(this.buttonEnabled && this.getEnabled());
        }
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label.getText();
        }
        return null;
    }

    public void setLabel(String text) {
        if (this.label == null) {
            throw new IllegalArgumentException("ControlGroup has not a label");
        }
        this.label.setText(text);
    }

    public String getButtonLabel() {
        if (this.button != null) {
            return this.button.getText();
        }
        return null;
    }

    public void setButtonLabel(String text) {
        if (this.button == null) {
            throw new IllegalArgumentException("ControlGroup has not a button");
        }
        this.button.setText(text);
    }

    public void setToolTip(String text) {
        this.setToolTipText(text);
        if (this.button != null) {
            this.button.setToolTipText(text);
        }
        if (this.label != null) {
            this.label.setToolTipText(text);
        }
    }
}

