/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.perf.AbstractPerformanceDataManager;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.tau.TAUPortalUploadDialog;
import org.eclipse.ptp.perf.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.perf.tau.perfdmf.views.PerfDMFView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TAUPerformanceDataManager
extends AbstractPerformanceDataManager {
    private static String getTauMakefile(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("tau_makefile.performance.options.configuration_id", null);
    }

    public void cleanup() {
    }

    public void process(String projname, ILaunchConfiguration configuration, String projectLocation) throws CoreException {
        String directory = projectLocation;
        String makename = TAUPerformanceDataManager.getTauMakefile(configuration);
        String projtype = makename.substring(makename.lastIndexOf("tau-") + 4);
        boolean tracout = configuration.getAttribute("use_epilog", false) || configuration.getAttribute("use_vampirtrace", false) || configuration.getAttribute("use_tau_tracing", false) || configuration.getAttribute("use_perf_library", false) || projtype.indexOf("-trace") >= 0;
        boolean profout = configuration.getAttribute("use_callpath_profiling", false) || configuration.getAttribute("use_tau_phases", false) || configuration.getAttribute("use_memory_profiling", false) || projtype.indexOf("-profile") >= 0 || projtype.indexOf("-headroom") >= 0;
        boolean haveprofiles = !tracout || profout;
        String tbpath = BuildLaunchUtils.getToolPath((String)"tau");
        String now = BuildLaunchUtils.getNow();
        if (projtype.indexOf("-perf") > 0) {
            TAUPerformanceDataManager.managePerfFiles(directory, tbpath);
        }
        if (haveprofiles) {
            boolean runtauinc = configuration.getAttribute("use_tauinc_script", false);
            boolean keepprofs = configuration.getAttribute("keep_profile_files", false);
            boolean useportal = configuration.getAttribute("upload_profiles_to_portal", false);
            TAUPerformanceDataManager.manageProfiles(directory, projname, projtype, tbpath, PerfDMFView.extractDatabaseName((String)configuration.getAttribute("perfdmf_database_configuration", null)), now, keepprofs, useportal, runtauinc);
        }
    }

    public void view() {
    }

    private static void manageProfiles(final String directory, final String projname, final String projtype, final String tbpath, final String database, final String now, final boolean keepprofs, final boolean useportal, final boolean runtauinc) throws CoreException {
        File[] profiles = null;
        File dir = new File(directory);
        class Profilefilter
        implements FilenameFilter {
            Profilefilter() {
            }

            public boolean accept(File dir, String name) {
                return name.indexOf("profile.") == 0;
            }
        }
        Profilefilter profil = new Profilefilter();
        profiles = dir.listFiles(profil);
        final boolean multipapi = projtype.indexOf("multiplecounters") >= 0 && projtype.indexOf("papi") >= 0;
        File[] counterdirs = null;
        class Counterfilter
        implements FileFilter {
            Counterfilter() {
            }

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().indexOf("MULTI__") == 0;
            }
        }
        Counterfilter countfil = null;
        if (multipapi) {
            countfil = new Counterfilter();
            counterdirs = dir.listFiles(countfil);
        }
        File[] rem = null;
        rem = multipapi ? counterdirs : profiles;
        final File[] remprofs = rem;
        if (rem.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (runtauinc) {
                        String mpilistname = String.valueOf(projname) + "_" + projtype + "_" + now + ".includelist";
                        String tauinc = "cd " + directory + " ; " + tbpath + File.separator + "tauinc.sh > " + mpilistname;
                        System.out.println(tauinc);
                        try {
                            String[] cmd = new String[]{"sh", "-c", tauinc};
                            Runtime.getRuntime().exec(cmd);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String ppkname = String.valueOf(projname) + "_" + projtype + "_" + now + ".ppk";
                    String paraprof = String.valueOf(tbpath) + File.separator + "paraprof --pack " + ppkname;
                    System.out.println(paraprof);
                    String ppk = String.valueOf(directory) + File.separator + ppkname;
                    BuildLaunchUtils.runTool((String)paraprof, null, (File)new File(directory));
                    File ppkFile = new File(ppk);
                    boolean hasdb = false;
                    try {
                        hasdb = database != null && !database.equals("No databases available") ? PerfDMFUIPlugin.addPerformanceData((String)projname, (String)projtype, (String)directory, (String)database) : false;
                        if (!hasdb) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your perfdmf database failed.  Please make sure that you have successfully run perfdmf_configure with your selected TAU installation.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (useportal) {
                        hasdb = true;
                        try {
                            TAUPortalUploadDialog pwDialog = new TAUPortalUploadDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ppkFile);
                            if (pwDialog.open() != 0 && pwDialog.open() != 1) {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your online database failed.  Please make sure that the given URL, username and password are correct.");
                                hasdb = false;
                            }
                        }
                        catch (Exception exception) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your online database failed.  Please make sure that the given URL, username and password are correct.");
                            hasdb = false;
                        }
                    }
                    int i = 0;
                    while (i < remprofs.length) {
                        if (multipapi) {
                            File[] profs = remprofs[i].listFiles();
                            int j = 0;
                            while (j < profs.length) {
                                profs[j].delete();
                                ++j;
                            }
                        }
                        remprofs[i].delete();
                        ++i;
                    }
                    if (!keepprofs && hasdb) {
                        ppkFile.delete();
                    } else {
                        File profdir = new File(String.valueOf(directory) + File.separator + "Profiles" + File.separator + projtype + File.separator + now);
                        profdir.mkdirs();
                        ppkFile.renameTo(new File(profdir + File.separator + ppkFile.getName()));
                    }
                }
            });
        }
        if (rem.length <= 0) {
            System.out.println("No profile data generated!  Check for build and runtime errors!");
        }
    }

    private static void managePerfFiles(String directory, String tbpath) throws CoreException {
        File dir = new File(directory);
        class Perffilter
        implements FilenameFilter {
            Perffilter() {
            }

            public boolean accept(File dir, String name) {
                return name.indexOf("perf_data.") == 0;
            }
        }
        Perffilter seekdir = new Perffilter();
        File[] perfdir = dir.listFiles(seekdir);
        if (perfdir == null || perfdir.length < 1) {
            return;
        }
        String perf2tau = String.valueOf(tbpath) + File.separator + "perf2tau";
        BuildLaunchUtils.runTool((String)perf2tau, null, (File)dir);
    }

    public String getName() {
        return "process-TAU-data";
    }
}

