/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildLaunchUtils {
    public static String findToolBinPath(String toolfind, String suggPath, String queryText, String queryMessage, Shell selshell) {
        String vtbinpath = BuildLaunchUtils.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = BuildLaunchUtils.askToolPath(suggPath, queryText, queryMessage, selshell)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    public static String findToolBinPath(String toolfind, String suggPath, String toolName, Shell selshell) {
        String vtbinpath = BuildLaunchUtils.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = BuildLaunchUtils.askToolPath(suggPath, toolName, selshell)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    public static String getToolPath(String toolID) {
        String toolBinID;
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        String path = pstore.getString(toolBinID = "performance_tool_bin_directory." + toolID);
        if (path != null) {
            return path;
        }
        return "";
    }

    public static void getAllToolPaths(PerformanceTool[] tools, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Shell ourshell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        int i = 0;
        while (i < tools.length) {
            for (Map.Entry me2 : tools[i].groupApp.entrySet()) {
                entry = (String)me2.getKey();
                if (entry.equals("internal")) continue;
                String toolBinID = "performance_tool_bin_directory." + entry;
                if (!force && !pstore.getString(toolBinID).equals("")) continue;
                pstore.setValue(toolBinID, BuildLaunchUtils.findToolBinPath((String)me2.getValue(), null, entry, ourshell));
            }
            ++i;
        }
    }

    public static String checkToolEnvPath(String toolname) {
        if (Platform.getOS().toLowerCase().trim().indexOf("win") >= 0) {
            return null;
        }
        String pPath = null;
        try {
            Process p = Runtime.getRuntime().exec("which " + toolname);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            pPath = reader.readLine();
            while (reader.readLine() != null) {
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pPath == null) {
            return null;
        }
        File test = new File(pPath);
        File toolin = new File(toolname);
        if (test.getPath().equals(toolin.getPath())) {
            return null;
        }
        if (test.exists()) {
            return test.getParentFile().getPath();
        }
        return null;
    }

    public static String askToolPath(String archpath, String toolText, String toolMessage, Shell selshell) {
        File path;
        if (selshell == null) {
            return null;
        }
        DirectoryDialog dialog = new DirectoryDialog(selshell);
        dialog.setText(toolText);
        dialog.setMessage(toolMessage);
        if (archpath != null && (path = new File(archpath)).exists()) {
            dialog.setFilterPath(path.isFile() ? archpath : path.getParent());
        }
        return dialog.open();
    }

    public static String askToolPath(String archpath, String toolName, Shell selshell) {
        return BuildLaunchUtils.askToolPath(archpath, "Select " + toolName + " Bin Directory", "Please select the directory containing " + toolName, selshell);
    }

    public static String getNow() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public static void runTool(String tool, String[] env, File directory) {
        String s = new String();
        try {
            Process p = Runtime.getRuntime().exec(tool, env, directory);
            int i = p.waitFor();
            if (i == 0) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    System.out.println(s);
                }
            } else {
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = stdErr.readLine()) != null) {
                    System.out.println(s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

