/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.AbstractPerformanceDataManager;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.internal.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.ToolApp;
import org.eclipse.ptp.perf.toolopts.ToolIO;

public class PerformanceLaunchSteps
implements IPerformanceLaunchConfigurationConstants {
    private IManagedProject managedBuildProj = null;
    private IConfiguration newBuildConfig = null;
    private IConfiguration olddefbuildconf = null;
    private ICProject thisCProject = null;
    private IProject thisProject = null;
    private String progPath = null;
    private String application = null;
    private String buildConf = null;
    private String projectLocation = null;
    private String outputLocation = null;
    private String saveApp = null;
    private String saveArgs = null;
    private boolean swappedArgs = false;
    private boolean runbuilt = false;
    private final PerformanceTool tool;
    private String appnameattrib = null;
    private String apppathattrib = null;
    private ILaunchConfiguration configuration = null;
    private Map<String, String> IOMap = null;

    public PerformanceLaunchSteps(ILaunchConfiguration conf, String ana, String projnameattrib, String apa) throws CoreException {
        this.appnameattrib = ana;
        this.apppathattrib = apa;
        this.configuration = conf;
        this.thisProject = PerformanceLaunchSteps.getProject(projnameattrib, this.configuration);
        this.thisCProject = CCorePlugin.getDefault().getCoreModel().create(this.thisProject);
        this.outputLocation = this.projectLocation = this.thisCProject.getResource().getLocation().toOSString();
        this.tool = Activator.getTool(this.configuration.getAttribute("selected_performance_tool", null));
        this.IOMap = new HashMap<String, String>();
        this.buildConf = this.configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", null);
    }

    private static IProject getProject(String projnameattrib, ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(projnameattrib, null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    public void buildIndstrumented(IProgressMonitor monitor) throws Exception {
        if (this.tool == null) {
            throw new Exception("No valid tool configuration found");
        }
        this.runbuilt = true;
        if (this.tool.recompile) {
            if (!ManagedBuildManager.canGetBuildInfo((IResource)this.thisCProject.getResource())) {
                this.standardMakeBuild(monitor);
            } else {
                this.managedMakeBuild(monitor);
            }
        }
    }

    public void standardMakeBuild(IProgressMonitor monitor) throws CoreException {
        File compilerInclude = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc");
        File compilerDef = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc.default");
        try {
            if (compilerInclude.exists()) {
                int len;
                FileInputStream in = new FileInputStream(compilerInclude);
                FileOutputStream out = new FileOutputStream(compilerDef);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            BufferedWriter makeOut = new BufferedWriter(new FileWriter(compilerInclude));
            String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCcCompiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCxxCompiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getF90Compiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MakeTargetManager targetMan = new MakeTargetManager();
        targetMan.startup();
        IMakeTarget[] targs = targetMan.getTargets((IContainer)this.thisProject);
        IMakeTarget select = null;
        int i = 0;
        while (i < targs.length) {
            if (targs[i].getName().equals("all")) {
                select = targs[i];
                break;
            }
            System.out.println(String.valueOf(targs[i].getName()) + " " + targs[i].getTargetBuilderID());
            ++i;
        }
        if (select == null) {
            System.out.println("No Make Target: all");
            this.runbuilt = false;
            return;
        }
        System.out.println(select.getBuildLocation());
        select.build(monitor);
        targetMan.shutdown();
        if (compilerDef.exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(compilerDef);
                FileOutputStream out = new FileOutputStream(compilerInclude);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.runbuilt = true;
    }

    public void managedMakeBuild(IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.thisCProject.getResource());
        if (info == null || !info.isValid()) {
            System.out.println("No info!!!");
            this.runbuilt = false;
            return;
        }
        this.managedBuildProj = info.getManagedProject();
        if (this.managedBuildProj == null) {
            System.out.println("No managed project!!!");
            this.runbuilt = false;
            return;
        }
        this.olddefbuildconf = info.getDefaultConfiguration();
        String binary = info.getBuildArtifactName();
        String bextension = info.getBuildArtifactExtension();
        if (bextension.length() > 0) {
            binary = String.valueOf(binary) + "." + bextension;
        }
        IConfiguration[] buildconfigs = info.getManagedProject().getConfigurations();
        IConfiguration selectedconf = null;
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                selectedconf = buildconfigs[i];
                break;
            }
            ++i;
        }
        if (selectedconf == null) {
            System.out.println("No Conf Selected");
            this.runbuilt = false;
            return;
        }
        if (selectedconf.getName() == null) {
            System.out.println("Selected conf has no name");
            this.runbuilt = false;
            return;
        }
        String basename = selectedconf.getName();
        String newname = null;
        String addname = this.configuration.getAttribute("performance_tool_build_configuration_name_modifier." + this.tool.toolID, "PerformanceAnalysis");
        newname = String.valueOf(basename) + "_" + addname;
        if (addname.equals("PerformanceAnalysis")) {
            newname = String.valueOf(newname) + "_" + this.tool.toolName;
        }
        IConfiguration[] confs = this.managedBuildProj.getConfigurations();
        int i2 = 0;
        while (i2 < confs.length) {
            if (confs[i2].getName().equals(newname) || confs[i2].getName().indexOf(newname) >= 0) {
                this.managedBuildProj.removeConfiguration(confs[i2].getId());
            }
            ++i2;
        }
        this.newBuildConfig = this.managedBuildProj.createConfigurationClone(selectedconf, String.valueOf(selectedconf.getId()) + "." + ManagedBuildManager.getRandomNumber());
        if (this.newBuildConfig == null) {
            System.out.println("No config!");
        }
        this.newBuildConfig.setName(newname);
        IToolChain chain = this.newBuildConfig.getToolChain();
        ITool[] tools = chain.getTools();
        String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
        int i3 = 0;
        while (i3 < tools.length) {
            String toolid = tools[i3].getId();
            if (toolid.indexOf(".c.") >= 0) {
                if (this.tool.replaceCompiler) {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getCcCompiler(), this.configuration)) + " " + allargs);
                } else {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getCcCompiler(), this.configuration)) + " " + allargs + " " + tools[i3].getToolCommand());
                }
            }
            if (toolid.indexOf(".cpp.") >= 0) {
                if (this.tool.replaceCompiler) {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getCxxCompiler(), this.configuration)) + " " + allargs);
                } else {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getCxxCompiler(), this.configuration)) + " " + allargs + " " + tools[i3].getToolCommand());
                }
            }
            if (toolid.indexOf(".fortran.") >= 0) {
                if (this.tool.replaceCompiler) {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getF90Compiler(), this.configuration)) + " " + allargs);
                } else {
                    tools[i3].setToolCommand(String.valueOf(this.getToolCommand(this.tool.getF90Compiler(), this.configuration)) + " " + allargs + " " + tools[i3].getToolCommand());
                }
            }
            ++i3;
        }
        ManagedBuildManager.saveBuildInfo((IProject)this.thisCProject.getProject(), (boolean)true);
        ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.newBuildConfig);
        try {
            this.thisProject.build(6, monitor);
        }
        catch (Exception exception) {
            this.runbuilt = false;
            return;
        }
        this.progPath = String.valueOf(newname) + File.separator + binary;
        IFile programPath = this.thisProject.getFile(this.progPath);
        if (this.apppathattrib != null) {
            this.outputLocation = this.thisProject.getFile(newname).getLocation().toOSString();
        }
        while (!programPath.exists() || !programPath.getLocation().toFile().exists()) {
            if (monitor != null && monitor.isCanceled()) {
                ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
                this.runbuilt = false;
                throw new OperationCanceledException();
            }
            long numMillisecondsToSleep = 1000L;
            try {
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException interruptedException) {}
            programPath = this.thisProject.getFile(this.progPath);
        }
        if (this.configuration.getAttribute("build_but_do_not_run_instrumented_executable", false)) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
            this.runbuilt = false;
            return;
        }
        this.runbuilt = true;
    }

    public boolean performLaunch(LaunchConfigurationDelegate paraDel, ILaunch launch, IProgressMonitor monitor) throws Exception {
        if (this.tool == null) {
            throw new Exception("No valid tool configuration found");
        }
        if (!this.runbuilt) {
            return false;
        }
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        this.application = confWC.getAttribute(this.appnameattrib, null);
        if (this.tool.recompile) {
            confWC.setAttribute(this.appnameattrib, this.progPath);
            if (this.apppathattrib != null) {
                IFile path = this.thisProject.getFile(this.progPath);
                confWC.setAttribute(this.apppathattrib, path.getLocation().toString());
            }
        }
        if (this.tool.prependExecution) {
            String prog = confWC.getAttribute(this.appnameattrib, "");
            String arg = confWC.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
            this.saveApp = prog;
            this.saveArgs = arg;
            if (this.tool.execUtils != null && this.tool.execUtils.length > 0) {
                String firstExecUtil = PerformanceLaunchSteps.getToolExecutable(this.tool.execUtils[0]);
                if (firstExecUtil == null) {
                    throw new Exception("Tool " + firstExecUtil + " not found");
                }
                confWC.setAttribute(this.appnameattrib, firstExecUtil);
                String otherUtils = this.getToolArguments(this.tool.execUtils[0], this.configuration);
                int i = 1;
                while (i < this.tool.execUtils.length) {
                    otherUtils = String.valueOf(otherUtils) + " " + this.getToolCommand(this.tool.execUtils[i], this.configuration);
                    ++i;
                }
                this.swappedArgs = true;
                confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", String.valueOf(otherUtils) + " " + prog + " " + arg);
            }
        }
        this.configuration = confWC.doSave();
        paraDel.launch(this.configuration, "run", launch, monitor);
        if (!launch.isTerminated()) {
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    this.cleanup();
                    throw new OperationCanceledException();
                }
                Thread.sleep(1000L);
            }
        }
        return true;
    }

    public void cleanup() throws CoreException {
        if (this.tool.recompile && ManagedBuildManager.canGetBuildInfo((IResource)this.thisCProject.getResource())) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
        }
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        if (this.tool.prependExecution && this.swappedArgs) {
            confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.saveApp);
            confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.saveArgs);
        }
        confWC.setAttribute(this.appnameattrib, this.application);
        this.configuration = confWC.doSave();
    }

    public void postlaunch(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            this.cleanup();
            throw new OperationCanceledException();
        }
        if (this.tool.analysisCommands != null && this.tool.analysisCommands.length > 0) {
            File projectLoc = new File(this.outputLocation);
            int i = 0;
            while (i < this.tool.analysisCommands.length) {
                if (this.tool.analysisCommands[i].toolGroup == null || !this.tool.analysisCommands[i].toolGroup.equals("internal")) {
                    String runTool = this.getToolCommand(this.tool.analysisCommands[i], this.configuration);
                    if (runTool != null) {
                        BuildLaunchUtils.runTool(runTool, null, projectLoc);
                    } else {
                        System.out.println("The command " + this.tool.analysisCommands[i].toolCommand + " could not be run because the application is not in your path.");
                    }
                } else {
                    AbstractPerformanceDataManager manager = Activator.getPerfDataManager(this.tool.analysisCommands[i].toolCommand);
                    if (manager != null) {
                        manager.process(this.thisCProject.getElementName(), this.configuration, this.outputLocation);
                    }
                }
                ++i;
            }
        }
        this.cleanup();
    }

    private String getToolArguments(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return "";
        }
        String allargs = String.valueOf(app.getArguments(configuration).replaceAll("replace_this_string_with_the_project_path", this.projectLocation)) + this.parseInput(app) + " " + this.parseOutput(app);
        return allargs;
    }

    private String parseInput(ToolApp app) {
        String input = "";
        String oneIn = "";
        if (app.inputArgs != null) {
            int i = 0;
            while (i < app.inputArgs.length) {
                oneIn = "";
                if (app.inputArgs[i].pathFlag != null) {
                    oneIn = String.valueOf(oneIn) + app.inputArgs[i].pathFlag + " ";
                }
                if (!this.IOMap.containsKey(app.inputArgs[i].ID)) {
                    return "";
                }
                input = String.valueOf(input) + this.IOMap.get(app.inputArgs[i].ID);
                ++i;
            }
        }
        return input;
    }

    private String parseOutput(ToolApp app) {
        String output = "";
        if (app.outputArgs != null) {
            int i = 0;
            while (i < app.outputArgs.length) {
                if (app.outputArgs[i].pathFlag != null) {
                    output = String.valueOf(output) + app.outputArgs[i].pathFlag + " ";
                }
                output = this.IOMap.containsKey(app.outputArgs[i].ID) ? String.valueOf(output) + this.IOMap.get(app.outputArgs[i].ID) : String.valueOf(output) + this.createOutputPath(app.outputArgs[i]);
                ++i;
            }
        }
        return output;
    }

    private String createOutputPath(ToolIO IO) {
        String opath = String.valueOf(this.projectLocation) + File.separator + IO.ID + File.separator + BuildLaunchUtils.getNow();
        File ofile = new File(opath);
        ofile.mkdirs();
        this.IOMap.put(IO.ID, opath);
        return opath;
    }

    private static String getToolExecutable(ToolApp app) {
        String command = app.toolCommand;
        String toolPath = BuildLaunchUtils.getToolPath(app.toolGroup);
        if (toolPath != null) {
            command = String.valueOf(toolPath) + File.separator + command;
        }
        return command;
    }

    private String getToolCommand(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        String command = PerformanceLaunchSteps.getToolExecutable(app);
        if (command == null) {
            return null;
        }
        return String.valueOf(command) + " " + this.getToolArguments(app, configuration);
    }
}

