/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.internal.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.ToolPane;
import org.eclipse.ptp.perf.toolopts.ToolPaneListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PerformanceAnalysisTab
extends AbstractLaunchConfigurationTab
implements IPerformanceLaunchConfigurationConstants {
    protected boolean noPTP = false;
    protected final PerformanceTool[] tools = Activator.getTools();
    protected Combo toolTypes;
    protected Button buildonlyCheck;
    protected Button noParallelRun;
    protected Button keepprofsCheck;
    protected final ToolPane[] panes = Activator.getToolPanes();
    protected WidgetListener listener = new WidgetListener();

    public PerformanceAnalysisTab(boolean noPar) {
        this.noPTP = noPar;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        FillLayout topLayout = new FillLayout();
        comp.setLayout((Layout)topLayout);
        TabFolder tabParent = new TabFolder(comp, 2048);
        TabItem toolTab = new TabItem(tabParent, 0);
        toolTab.setText("Tool Selection");
        ScrolledComposite scrollTool = new ScrolledComposite((Composite)tabParent, 512);
        Composite toolComp = new Composite((Composite)scrollTool, 0);
        toolTab.setControl((Control)scrollTool);
        toolComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(1, false, 0, 0));
        toolComp.setLayoutData((Object)PerformanceAnalysisTab.spanGridData(768, 5));
        this.createVerticalSpacer(toolComp, 1);
        Composite toolComboComp = new Composite(toolComp, 0);
        toolComboComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(2, false, 0, 0));
        toolComboComp.setLayoutData((Object)new GridData(768));
        Label makeLab = new Label(toolComboComp, 0);
        makeLab.setText("Select Analysis Tool:");
        this.toolTypes = new Combo(toolComboComp, 2060);
        this.toolTypes.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(toolComp, 1);
        this.buildonlyCheck = this.createCheckButton(toolComp, "Build the instrumented executable but do not launch it");
        this.buildonlyCheck.addSelectionListener((SelectionListener)this.listener);
        toolComp.pack();
        int toolCompHeight = toolComp.computeSize((int)-1, (int)-1).y;
        scrollTool.setContent((Control)toolComp);
        scrollTool.setMinSize(400, toolCompHeight);
        scrollTool.setExpandHorizontal(true);
        scrollTool.setExpandVertical(true);
        TabItem optionTab = null;
        ScrolledComposite scrollOption = null;
        Composite optionComp = null;
        int optionCompHeight = 400;
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                if (!this.panes[i].virtual) {
                    optionTab = new TabItem(tabParent, 0);
                    optionTab.setText(this.panes[i].toolName);
                    scrollOption = new ScrolledComposite((Composite)tabParent, 512);
                    optionComp = new Composite((Composite)scrollOption, 0);
                    optionTab.setControl((Control)scrollOption);
                    optionComp.setLayout((Layout)PerformanceAnalysisTab.createGridLayout(1, false, 0, 0));
                    optionComp.setLayoutData((Object)PerformanceAnalysisTab.spanGridData(768, 5));
                    this.panes[i].makeToolPane(optionComp, (ToolPaneListener)new OptionsPaneListener(this.panes[i]));
                    optionComp.pack();
                    optionCompHeight = optionComp.computeSize((int)-1, (int)-1).y;
                    scrollOption.setContent((Control)optionComp);
                    scrollOption.setMinSize(400, optionCompHeight);
                    scrollOption.setExpandHorizontal(true);
                    scrollOption.setExpandVertical(true);
                }
                ++i;
            }
        }
    }

    public void updateComboFromSelection() {
        System.out.println("change startup");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                this.panes[i].setDefaults(configuration);
                ++i;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.toolTypes.removeAll();
        if (this.tools == null || this.tools.length == 0) {
            this.toolTypes.add("Specify a valid tool configuration file in Performance Tool preferences");
            if (this.tools == null) {
                this.toolTypes.select(0);
                return;
            }
        }
        BuildLaunchUtils.getAllToolPaths(this.tools, false);
        int i = 0;
        while (i < this.tools.length) {
            this.toolTypes.add(this.tools[i].toolName);
            ++i;
        }
        this.toolTypes.select(0);
        try {
            int toolDex = this.toolTypes.indexOf(configuration.getAttribute("selected_performance_tool", ""));
            if (toolDex >= 0) {
                this.toolTypes.select(toolDex);
            } else {
                this.toolTypes.select(0);
                if (configuration.getAttribute("selected_performance_tool", "").equals("")) {
                    this.updateLaunchConfigurationDialog();
                }
            }
            this.buildonlyCheck.setSelection(configuration.getAttribute("build_but_do_not_run_instrumented_executable", false));
            if (this.panes != null) {
                int i2 = 0;
                while (i2 < this.panes.length) {
                    this.panes[i2].OptUpdate();
                    this.panes[i2].initializePane(configuration);
                    ++i2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String selectedtool = this.toolTypes.getItem(this.toolTypes.getSelectionIndex());
        configuration.setAttribute("selected_performance_tool", selectedtool);
        if (this.tools != null && this.tools.length >= 1) {
            if (this.toolTypes.getSelectionIndex() == 0) {
                configuration.setAttribute("use_tau_launch_system", true);
            } else {
                configuration.setAttribute("use_tau_launch_system", false);
            }
            configuration.setAttribute("true_if_using_performance_analysis_execution_utility", this.tools[this.toolTypes.getSelectionIndex()].prependExecution);
            configuration.setAttribute("true_if_recompiling_for_analysis", this.tools[this.toolTypes.getSelectionIndex()].recompile);
        }
        configuration.setAttribute("build_but_do_not_run_instrumented_executable", this.buildonlyCheck.getSelection());
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                this.panes[i].performApply(configuration);
                configuration.setAttribute(this.panes[i].configID, this.panes[i].getOptionString());
                ++i;
            }
        }
    }

    protected String getFieldContent(IntegerFieldEditor editorField) {
        return this.getFieldContent(editorField.getStringValue());
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getName() {
        return "Performance Analysis";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    protected class OptionsPaneListener
    extends ToolPaneListener {
        OptionsPaneListener(ToolPane tool) {
            super(tool);
        }

        protected void localAction() {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent evt) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }
}

