/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteOperation;
import org.eclipse.ptp.remotetools.core.KeyAuthToken;
import org.eclipse.ptp.remotetools.core.PasswdAuthToken;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.RemoteTunnel;
import org.eclipse.ptp.remotetools.internal.core.ConnectionProperties;
import org.eclipse.ptp.remotetools.internal.ssh.CipherTypes;
import org.eclipse.ptp.remotetools.internal.ssh.ConnectionLocks;
import org.eclipse.ptp.remotetools.internal.ssh.ControlChannel;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionObserver;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.RemotePortForwardingPool;

public class Connection
implements IRemoteConnection {
    private JSch jsch;
    Session defaultSession;
    private AuthToken authToken;
    private String username;
    private String hostname;
    private int port;
    private int timeout;
    private String cipherType;
    private SSHUserInfo sshuserinfo = new SSHUserInfo();
    private ArrayList executionManagers;
    Set tunnels;
    Set executions;
    ChannelSftp sftpChannel;
    Hashtable activeProcessTable;
    private int nextInternalPID;
    private ControlChannel controlChannel;
    private ExecutionObserver executionObserver;
    ArrayList connectionPool = new ArrayList();
    HashMap channelToConnectioPool;
    protected ConnectionLocks connectionLocks;
    RemotePortForwardingPool forwardingPool;

    public Connection(AuthToken authToken, String hostname, int port, String cipherType, int timeout) {
        this.jsch = new JSch();
        this.authToken = authToken;
        this.username = authToken.getUsername();
        this.hostname = hostname;
        this.port = port;
        this.timeout = timeout;
        this.cipherType = cipherType;
        if (authToken instanceof PasswdAuthToken) {
            this.sshuserinfo.isPasswdBased = true;
            this.sshuserinfo.password = ((PasswdAuthToken)authToken).getPassword();
        } else if (authToken instanceof KeyAuthToken) {
            KeyAuthToken token = (KeyAuthToken)authToken;
            this.sshuserinfo.isPasswdBased = false;
            this.sshuserinfo.passphrase = token.getPassphrase();
        } else {
            throw new RuntimeException(Messages.Connection_AuthenticationTypeNotSupported);
        }
    }

    public Connection(AuthToken authToken, String hostname, int port, String cipherType) {
        this(authToken, hostname, port, CipherTypes.CIPHER_DEFAULT, ConnectionProperties.defaultTimeout);
    }

    public Connection(AuthToken authToken, String hostname) {
        this(authToken, hostname, ConnectionProperties.defaultPort, CipherTypes.CIPHER_DEFAULT, ConnectionProperties.defaultTimeout);
    }

    public Connection(AuthToken authToken, String hostname, int port) {
        this(authToken, hostname, port, CipherTypes.CIPHER_DEFAULT, ConnectionProperties.defaultTimeout);
    }

    public synchronized void connect() throws RemoteConnectionException {
        this.nextInternalPID = 0;
        if (this.authToken instanceof KeyAuthToken) {
            KeyAuthToken token = (KeyAuthToken)this.authToken;
            try {
                this.jsch.addIdentity(token.getKeyPath().getAbsolutePath());
            }
            catch (JSchException e) {
                throw new RemoteConnectionException(Messages.Connection_Connect_InvalidPrivateKey, e);
            }
        }
        try {
            this.defaultSession = this.jsch.getSession(this.username, this.hostname, this.port);
            this.defaultSession.setUserInfo((UserInfo)this.sshuserinfo);
        }
        catch (JSchException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSession, e);
        }
        this.setSessionCipherType(this.defaultSession);
        try {
            this.defaultSession.connect(this.timeout);
        }
        catch (JSchException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedConnect, e);
        }
        catch (Exception e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedUnsupportedKeySize, e);
        }
        try {
            this.controlChannel = new ControlChannel(this);
            this.controlChannel.open();
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateControlChannel, e);
        }
        try {
            this.sftpChannel = (ChannelSftp)this.defaultSession.openChannel("sftp");
            this.sftpChannel.connect();
        }
        catch (JSchException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSFTPConnection, e);
        }
        this.executionObserver = new ExecutionObserver(this);
        this.executionObserver.setPriority(50);
        this.executionObserver.setSystem(true);
        this.connectionPool = new ArrayList();
        ConnectionSlot slot = new ConnectionSlot(this.defaultSession, ConnectionProperties.initialDefaultSessionLoad);
        this.connectionPool.add(slot);
        this.executionManagers = new ArrayList();
        this.tunnels = new HashSet();
        this.executions = new HashSet();
        this.activeProcessTable = new Hashtable();
        this.channelToConnectioPool = new HashMap();
        this.forwardingPool = new RemotePortForwardingPool(this);
    }

    public synchronized IRemoteExecutionManager createRemoteExecutionManager() throws RemoteConnectionException {
        ExecutionManager e = new ExecutionManager(this);
        this.executionManagers.add(e);
        return e;
    }

    protected synchronized void releaseExcutionManager(ExecutionManager manager) {
        this.executionManagers.remove(manager);
    }

    public synchronized void disconnect() {
        if (this.executionManagers != null) {
            Iterator iterator = this.executionManagers.iterator();
            while (iterator.hasNext()) {
                ExecutionManager manager = (ExecutionManager)iterator.next();
                manager.close();
                iterator = this.executionManagers.iterator();
            }
        }
        if (this.executionObserver != null) {
            this.executionObserver.cancel();
        }
        if (this.controlChannel != null) {
            this.controlChannel.close();
        }
        if (this.sftpChannel != null) {
            this.sftpChannel.disconnect();
        }
        if (this.connectionPool != null) {
            for (ConnectionSlot slot : this.connectionPool) {
                slot.session.disconnect();
            }
        }
        this.defaultSession = null;
        this.sftpChannel = null;
        this.controlChannel = null;
        this.connectionPool = null;
        this.executionObserver = null;
        this.executions = null;
        this.executionManagers = null;
        this.tunnels = null;
        if (this.forwardingPool != null) {
            this.forwardingPool.disconnect();
            this.forwardingPool = null;
        }
    }

    public synchronized boolean isConnected() {
        if (this.defaultSession == null) {
            return false;
        }
        return this.defaultSession.isConnected();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUsername() {
        return this.username;
    }

    protected ChannelExec createExecChannel(boolean isInConnectionPool) throws RemoteConnectionException {
        if (isInConnectionPool) {
            ChannelExec channel;
            ConnectionSlot suggestedSlot = null;
            for (ConnectionSlot slot : this.connectionPool) {
                if (slot.numberUsedChannels >= ConnectionProperties.maxChannelsPerConnection) continue;
                suggestedSlot = slot;
                break;
            }
            if (suggestedSlot == null) {
                suggestedSlot = this.createConnecitonSlot();
            }
            try {
                channel = (ChannelExec)suggestedSlot.session.openChannel("exec");
            }
            catch (JSchException e) {
                throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
            }
            ++suggestedSlot.numberUsedChannels;
            this.channelToConnectioPool.put(channel, suggestedSlot);
            return channel;
        }
        try {
            return (ChannelExec)this.defaultSession.openChannel("exec");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
        }
    }

    protected void releaseChannel(Channel channel) {
        channel.disconnect();
        ConnectionSlot slot = (ConnectionSlot)this.channelToConnectioPool.remove(channel);
        if (slot != null) {
            --slot.numberUsedChannels;
        }
    }

    protected RemoteTunnel createTunnel(int localPort, String addressOnRemoteHost, int portOnRemoteHost) throws RemoteConnectionException, LocalPortBoundException {
        RemoteTunnel tunnel = new RemoteTunnel(localPort, portOnRemoteHost, addressOnRemoteHost);
        if (this.tunnels.contains(tunnel)) {
            throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
        }
        try {
            this.defaultSession.setPortForwardingL(tunnel.getLocalPort(), tunnel.getAddressOnRemoteHost(), tunnel.getPortOnRemoteHost());
        }
        catch (JSchException e) {
            if (e.getMessage().matches("PortForwardingL: local port .* is already registered.")) {
                throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
            }
            throw new RemoteConnectionException(Messages.Connection_CreateTunnel_FailedCreateTunnel, e);
        }
        this.tunnels.add(tunnel);
        return tunnel;
    }

    protected void releaseTunnel(RemoteTunnel tunnel) throws RemoteConnectionException {
        if (!this.tunnels.contains(tunnel)) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_PortNotAllocedForTunnel);
        }
        try {
            RemoteTunnel remoteTunnel = tunnel;
            this.defaultSession.delPortForwardingL(remoteTunnel.getLocalPort());
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_FailedRemoveTunnel, e);
        }
        this.tunnels.remove(tunnel);
    }

    protected ChannelSftp getDefaultSFTPChannel() {
        return this.sftpChannel;
    }

    protected synchronized int createNextPIID() {
        return ++this.nextInternalPID % Integer.MAX_VALUE;
    }

    protected synchronized void setPID(int piid, int pid) {
        KillableExecution rce = (KillableExecution)this.activeProcessTable.get(new Integer(piid));
        if (rce != null) {
            rce.setPID(pid);
        }
    }

    protected synchronized void registerObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            this.activeProcessTable.put(new Integer(killableExecution.getInternaID()), killableExecution);
            this.executionObserver.newCommand();
        }
    }

    protected synchronized void unregisterObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            this.activeProcessTable.remove(new Integer(killableExecution.getInternaID()));
        }
    }

    protected String getKillablePrefix(KillableExecution execution) {
        return this.controlChannel.getKillablePrefix(execution.getInternaID());
    }

    protected void killExecution(KillableExecution execution) {
        this.controlChannel.killRemoteProcess(execution.getPID());
    }

    private ConnectionSlot createConnecitonSlot() throws RemoteConnectionException {
        Session newSession = null;
        try {
            newSession = this.jsch.getSession(this.username, this.hostname, this.port);
            newSession.setUserInfo((UserInfo)this.sshuserinfo);
            this.setSessionCipherType(newSession);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedCreateNewSession, e);
        }
        try {
            newSession.connect(this.timeout);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedConnectNewSession, e);
        }
        ConnectionSlot slot = new ConnectionSlot(newSession);
        this.connectionPool.add(slot);
        return slot;
    }

    private void setSessionCipherType(Session session) {
        if (!this.cipherType.equals(CipherTypes.CIPHER_DEFAULT)) {
            if (!CipherTypes.getCipherTypesMap().containsKey(this.cipherType)) {
                throw new RuntimeException(Messages.Connection_SetCipherType_CipherNotSupported);
            }
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("cipher.s2c", this.cipherType);
            config.put("cipher.c2s", this.cipherType);
            session.setConfig(config);
        }
    }

    protected void test() throws RemoteConnectionException {
        for (ConnectionSlot slot : this.connectionPool) {
            if (slot.session.isConnected()) continue;
            throw new RemoteConnectionException("SSH connection to remote host was lost");
        }
        if (!this.sftpChannel.isConnected()) {
            throw new RemoteConnectionException("SFTP connection to remote host was lost");
        }
        if (!this.controlChannel.shell.isConnected()) {
            throw new RemoteConnectionException("Control channel connection to remote host was lost");
        }
    }

    private class ConnectionSlot {
        Session session = null;
        int numberUsedChannels = 0;

        ConnectionSlot(Session session) {
            this.session = session;
        }

        ConnectionSlot(Session session, int initialLoad) {
            this.session = session;
            this.numberUsedChannels = initialLoad;
        }
    }

    private class SSHUserInfo
    implements UserInfo {
        public String password;
        public String passphrase;
        public boolean isPasswdBased;

        private SSHUserInfo() {
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassphrase(String message) {
            return !this.isPasswdBased;
        }

        public boolean promptPassword(String message) {
            return this.isPasswdBased;
        }

        public void showMessage(String message) {
        }
    }
}

