/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteDirectory;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteDirectory;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFile;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileRecursiveEnumeration;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteItem;

public class FileTools
implements IRemoteFileTools {
    protected ExecutionManager manager;
    public int cachedUserID;
    public Set cachedGroupIDSet;

    protected FileTools(ExecutionManager manager) {
        this.manager = manager;
    }

    public void moveFile(String from, String to) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("mv -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    public void copyFile(String from, String to) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(from);
        this.validateRemotePath(to);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("cp -f " + pathTool.quote(from, true) + " " + pathTool.quote(to, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    public void removeFile(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("rm -rf " + pathTool.quote(file, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    public void createDirectory(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        IRemotePathTools pathTool = this.manager.getRemotePathTools();
        try {
            this.executeCommand("mkdir -p " + pathTool.quote(file, true));
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    public void assureDirectory(String directory) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        if (!this.hasDirectory(directory)) {
            this.createDirectory(directory);
        }
    }

    protected void test() throws RemoteConnectionException, CancelException {
        this.manager.test();
        this.manager.testCancel();
    }

    protected SftpATTRS fetchRemoteAttr(String path) throws RemoteOperationException {
        try {
            SftpATTRS attrs = this.manager.getConnection().getDefaultSFTPChannel().stat(path);
            return attrs;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return null;
            }
            throw new RemoteOperationException(Messages.RemoteFileTools_FetchRemoteAttr_FailedFetchAttr);
        }
    }

    public boolean hasDirectory(String directory) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(directory);
        RemoteItem item = (RemoteItem)this.getItem(directory);
        if (item == null) {
            return false;
        }
        if (!item.exists()) {
            return false;
        }
        return item.isDirectory();
    }

    public boolean hasFile(String file) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(file);
        RemoteItem item = (RemoteItem)this.getItem(file);
        if (item == null) {
            return false;
        }
        if (!item.exists()) {
            return false;
        }
        return item.isFile();
    }

    public boolean hasItem(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(path);
        RemoteItem item = (RemoteItem)this.getItem(path);
        if (item == null) {
            return false;
        }
        return item.exists();
    }

    public boolean canExecute(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isExecutable();
    }

    public boolean canRead(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isReadable();
    }

    public boolean canWrite(String remotePath) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.test();
        this.validateRemotePath(remotePath);
        RemoteItem item = (RemoteItem)this.getItem(remotePath);
        return item.isWritable();
    }

    protected void executeCommand(String command) throws RemoteConnectionException, RemoteExecutionException, CancelException {
        this.manager.executionTools.executeBashCommand(command);
    }

    void validateRemotePath(String path) throws RemoteOperationException {
        if (!path.startsWith("/")) {
            throw new RemoteOperationException(String.valueOf(path) + Messages.RemoteFileTools_ValidateRemotePath_NotValid);
        }
    }

    String concatenateRemotePath(String p1, String p2) {
        if (p1.endsWith("/")) {
            return String.valueOf(p1) + p2;
        }
        return String.valueOf(p1) + "/" + p2;
    }

    String parentOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(0, index));
    }

    String suffixOfRemotePath(String path) {
        int index = (path = this.removeTrailingSlash(path)).lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return this.removeTrailingSlash(path.substring(index + 1));
    }

    String addTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    String removeTrailingSlash(String path) {
        if (!path.equals("/") && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public IRemoteItem[] listItems(String root) throws RemoteOperationException {
        Vector files;
        this.validateRemotePath(root);
        try {
            files = this.manager.getConnection().getDefaultSFTPChannel().ls(root);
        }
        catch (SftpException e) {
            throw new RemoteOperationException(Messages.RemoteFileTools_ListFiles_FailedListRemote, e);
        }
        ArrayList<RemoteItem> result = new ArrayList<RemoteItem>();
        Enumeration enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)enumeration.nextElement();
            String fileName = entry.getFilename();
            String pathName = this.concatenateRemotePath(root, fileName);
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                result.add(new RemoteDirectory(this, pathName, entry.getAttrs()));
                continue;
            }
            result.add(new RemoteFile(this, pathName, entry.getAttrs()));
        }
        IRemoteItem[] resultArray = new IRemoteItem[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public IRemoteFile getFile(String filePath) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(filePath);
        filePath = this.removeTrailingSlash(filePath);
        this.cacheUserData();
        RemoteFile remfile = new RemoteFile(this, filePath);
        remfile.refreshAttributes();
        if (!remfile.isFile()) {
            throw new RemoteOperationException("Not a file");
        }
        return remfile;
    }

    private void cacheUserData() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.cachedGroupIDSet == null) {
            this.cachedGroupIDSet = this.manager.getRemoteStatusTools().getGroupIDSet();
            this.cachedUserID = this.manager.getRemoteStatusTools().getUserID();
        }
    }

    public IRemoteDirectory getDirectory(String directoryPath) throws RemoteOperationException, RemoteConnectionException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(directoryPath);
        directoryPath = this.removeTrailingSlash(directoryPath);
        this.cacheUserData();
        RemoteDirectory remfile = new RemoteDirectory(this, directoryPath);
        remfile.refreshAttributes();
        if (!remfile.isDirectory()) {
            throw new RemoteOperationException("Not a directory");
        }
        return remfile;
    }

    public IRemoteItem getItem(String path) throws RemoteConnectionException, RemoteOperationException, CancelException, RemoteOperationException {
        this.test();
        this.validateRemotePath(path);
        path = this.removeTrailingSlash(path);
        this.cacheUserData();
        RemoteItem newitem = new RemoteItem(this, path);
        newitem.refreshAttributes();
        newitem = newitem.isDirectory() ? new RemoteDirectory(newitem) : new RemoteFile(newitem);
        return newitem;
    }

    public IRemoteCopyTools getRemoteCopyTools() throws RemoteConnectionException {
        return this.manager.getRemoteCopyTools();
    }

    public IRemoteFileEnumeration createFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileEnumeration(this, path);
    }

    public IRemoteFileEnumeration createRecursiveFileEnumeration(String path) throws RemoteOperationException, RemoteConnectionException, CancelException {
        return new RemoteFileRecursiveEnumeration(this, path);
    }

    void uploadPermissions(File file, String remoteFilePath) throws RemoteConnectionException, RemoteOperationException, CancelException {
        IRemoteItem item = this.getItem(remoteFilePath);
        item.setReadable(file.canRead());
        item.setWriteable(file.canWrite());
        item.commitAttributes();
    }
}

