/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public abstract class AbstractResourceManagerConfiguration
implements IResourceManagerConfiguration {
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_NAME = "name";
    private static final String TAG_UNIQUE_NAME = "uniqName";
    private static final String TAG_FACTORY_ID = "factoryId";
    private String description;
    private String name;
    private final String resourceManagerId;
    private final String resourceManagerType;
    private final String uniqueName;
    private final IResourceManagerFactory factory;

    public static CommonConfig loadCommon(IResourceManagerFactory factory, IMemento memento) {
        String factoryId = memento.getString(TAG_FACTORY_ID);
        if (!factoryId.equals(factory.getId())) {
            throw new IllegalStateException("Incompatable factory with factoryId stored id" + factoryId + ", factory id:" + factory.getId());
        }
        String name = memento.getString(TAG_NAME);
        String desc = memento.getString(TAG_DESCRIPTION);
        String uniqueName = memento.getString(TAG_UNIQUE_NAME);
        return new CommonConfig(name, desc, uniqueName);
    }

    protected static String generateUniqueName() {
        long time = System.currentTimeMillis();
        return "RMID:" + Long.toString(time);
    }

    public AbstractResourceManagerConfiguration(CommonConfig commonConfig, IResourceManagerFactory factory) {
        this.name = commonConfig.getName();
        this.description = commonConfig.getDescription();
        this.resourceManagerId = factory.getId();
        this.resourceManagerType = factory.getName();
        this.uniqueName = commonConfig.getUniqueName();
        this.factory = factory;
    }

    public Object clone() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public IResourceManagerFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceManagerId() {
        return this.resourceManagerId;
    }

    public String getType() {
        return this.resourceManagerType;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void save(IMemento memento) {
        memento.putString(TAG_FACTORY_ID, this.getResourceManagerId());
        memento.putString(TAG_NAME, this.getName());
        memento.putString(TAG_DESCRIPTION, this.getDescription());
        memento.putString(TAG_UNIQUE_NAME, this.getUniqueName());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class CommonConfig {
        private final String name;
        private final String description;
        private final String uniqueName;

        public CommonConfig() {
            this("", "", AbstractResourceManagerConfiguration.generateUniqueName());
        }

        public CommonConfig(String name, String desc, String uniqueName) {
            this.name = name;
            this.description = desc;
            this.uniqueName = uniqueName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }
    }
}

