/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

public class PIndexedValue
extends AbstractPValue
implements IIndexedValue {
    private IPDIVariable pdiVariable;
    private IVariable[] fVariables;
    private int fOffset;
    private int fSize;

    public PIndexedValue(AbstractPVariable parent, IPDIVariable variable, int offset, int size) {
        super(parent);
        this.fVariables = new IVariable[size];
        this.pdiVariable = variable;
        this.fOffset = offset;
        this.fSize = size;
    }

    protected void setChanged(boolean changed) {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).setChanged(changed);
            }
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).dispose();
            }
            ++i;
        }
    }

    protected void reset() {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).resetValue();
            }
            ++i;
        }
    }

    protected void preserve() {
        this.resetStatus();
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] != null) {
                ((AbstractPVariable)this.fVariables[i]).preserve();
            }
            ++i;
        }
    }

    public IAIF getAIF() throws DebugException {
        try {
            return this.pdiVariable.getAIF();
        }
        catch (PDIException e) {
            PIndexedValue.targetRequestFailed(e.getMessage(), e);
            return null;
        }
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getAIF().getType().toString();
    }

    public String getValueString() throws DebugException {
        return "[" + this.fOffset + " - " + this.fSize + "]";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables0(this.getInitialOffset(), this.getSize());
    }

    public boolean hasVariables() throws DebugException {
        return this.getSize() > 0;
    }

    public IVariable getVariable(int offset) throws DebugException {
        if (offset >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("PIndexedValue.0"), null);
        }
        return this.getVariables0(offset, 1)[0];
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        if (offset >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("PIndexedValue.1"), null);
        }
        if (offset + length - 1 >= this.getSize()) {
            PIndexedValue.requestFailed(CoreModelMessages.getString("PIndexedValue.2"), null);
        }
        return this.getVariables0(offset, length);
    }

    public int getSize() throws DebugException {
        return this.getSize0();
    }

    public int getInitialOffset() {
        return this.fOffset;
    }

    private int getPartitionSize(int index) {
        int psize = this.getPreferredPartitionSize();
        int size = this.getSize0();
        int pcount = size / psize + 1;
        if (pcount - 1 < index) {
            return 0;
        }
        return pcount - 1 == index ? size % psize : psize;
    }

    private int getPartitionIndex(int offset) {
        return offset / this.getPreferredPartitionSize();
    }

    private int getPreferredPartitionSize() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVariable[] getVariables0(int offset, int length) throws DebugException {
        IVariable[] result = new IVariable[length];
        int firstIndex = this.getPartitionIndex(offset);
        int lastIndex = this.getPartitionIndex(offset + Math.max(length - 1, 0));
        int i = firstIndex;
        while (i <= lastIndex) {
            PIndexedValue pIndexedValue = this;
            synchronized (pIndexedValue) {
                if (!this.isPartitionLoaded(i)) {
                    this.loadPartition(i);
                }
            }
            ++i;
        }
        System.arraycopy(this.fVariables, offset, result, 0, length);
        return result;
    }

    private boolean isPartitionLoaded(int index) {
        return this.fVariables[index * this.getPreferredPartitionSize()] != null;
    }

    private void loadPartition(int index) throws DebugException {
        int prefSize = this.getPreferredPartitionSize();
        int psize = this.getPartitionSize(index);
        int findex = index * prefSize;
        IPDIVariable[] pdiVars = new IPDIVariable[]{};
        try {
            pdiVars = this.pdiVariable.getChildren(findex, psize);
        }
        catch (PDIException e) {
            PIndexedValue.requestFailed(e.getMessage(), null);
        }
        int i = 0;
        while (i < pdiVars.length) {
            this.fVariables[i + findex] = PVariableFactory.createLocalVariable(this, pdiVars[i]);
            ++i;
        }
    }

    private int getSize0() {
        return this.fSize;
    }
}

