/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends AbstractUIPlugin {
    private static CommonPlugin plugin;
    private ResourceBundle resourceBundle;
    private static boolean eclipseTraceOn;
    private static boolean haveReadTraceStatus;

    static {
        eclipseTraceOn = false;
        haveReadTraceStatus = false;
    }

    public static boolean getTraceOn() {
        if (!haveReadTraceStatus) {
            String traceFilter = Platform.getDebugOption((String)"org.eclipse.ptp.pldt.common/debug/pldtTrace");
            if (traceFilter != null) {
                System.out.println("CommonPlugin.getTraceOn(): pldtTrace trace filtering is on; traceFilter= " + traceFilter);
                eclipseTraceOn = true;
            }
            haveReadTraceStatus = true;
        }
        return eclipseTraceOn;
    }

    public CommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        boolean versOK;
        super.start(context);
        this.getPreferenceStore().setDefault("showAnalysisConfirmation", true);
        Bundle cdtBundle = Platform.getBundle((String)"org.eclipse.cdt.core");
        String version = (String)cdtBundle.getHeaders().get("Bundle-Version");
        System.out.println("CDT version: " + version);
        boolean bl = versOK = version.startsWith("4.0.2") || version.startsWith("4.0.3") || version.startsWith("5");
        if (!versOK) {
            System.out.println("**Warning, wrong version of CDT.  Version 4.0.2 or higher is required with PLDT 2.0");
            String msg = "This is PLDT 2.0 which requires CDT Version 4.0.2 or higher.";
            msg = String.valueOf(msg) + "\nThis eclipse installation contains CDT version " + version;
            MessageDialog.openError(null, (String)"Version mismatch", (String)msg);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ptp.pldt.common", (String)path);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.ptp.pldt.common.CommonPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static void log(int type, String msg) {
        String pluginID = CommonPlugin.getDefault().getBundle().getSymbolicName();
        Throwable exc = null;
        Status status = new Status(type, pluginID, type, msg, exc);
        CommonPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String msg) {
        CommonPlugin.log(1, msg);
    }
}

