/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PldtAstVisitor
extends CASTVisitor {
    protected static String ARTIFACT_CALL = "Artifact Call";
    protected static String ARTIFACT_CONSTANT = "Artifact Constant";
    protected static String PREFIX = "";
    private static boolean traceOn = false;
    private final List<String> includes_;
    private final String fileName;
    private final ScanReturn scanReturn;

    public PldtAstVisitor(List<String> includes, String fileName, ScanReturn scanReturn) {
        this.includes_ = includes;
        this.fileName = fileName;
        this.scanReturn = scanReturn;
        traceOn = CommonPlugin.getTraceOn();
        if (traceOn) {
            System.out.println("PldtAstVisitor, traceOn=" + traceOn);
        }
    }

    public int visit(IASTStatement statement) {
        if (this.preprocessorIncluded((IASTNode)statement)) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTDeclaration declaration) {
        if (this.preprocessorIncluded((IASTNode)declaration)) {
            return 1;
        }
        return 3;
    }

    public void processFuncName(IASTName funcName, IASTExpression astExpr) {
        SourceInfo sourceInfo;
        if (this.isArtifact(funcName) && (sourceInfo = this.getSourceInfo(astExpr, 1)) != null) {
            String rawName;
            String artName;
            if (traceOn) {
                System.out.println("found MPI artifact: " + funcName.toString());
            }
            if (!(artName = funcName.toString()).equals(rawName = funcName.getRawSignature())) {
                if (rawName.length() == 0) {
                    rawName = "  ";
                }
                artName = String.valueOf(artName) + "  (" + rawName + ")";
            }
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, artName, ARTIFACT_CALL, sourceInfo));
        }
    }

    public void processExprWithConstant(IASTExpression astExpr) {
        SourceInfo sourceInfo;
        IASTName funcName = ((IASTIdExpression)astExpr).getName();
        if (this.isArtifact(funcName) && (sourceInfo = this.getSourceInfo(astExpr, 1)) != null) {
            System.out.println("found MPI artifact: " + funcName.toString());
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, funcName.toString(), ARTIFACT_CALL, sourceInfo));
        }
    }

    protected boolean isArtifact(IASTName funcName) {
        IBinding binding = funcName.resolveBinding();
        String name = binding.getName();
        String rawSig = funcName.getRawSignature();
        name = this.chooseName(name, rawSig);
        IASTName[] decls = funcName.getTranslationUnit().getDeclarationsInAST(binding);
        if (traceOn && decls.length == 0) {
            IASTTranslationUnit tu = funcName.getTranslationUnit();
            IASTName[] na = tu.getDeclarationsInAST(binding);
            int i = 0;
            while (i < na.length) {
                IASTName nm = na[i];
                System.out.println(nm);
                ++i;
            }
        }
        if (decls.length == 0) {
            System.out.println("PldtAstVisitor.isArtifact(): decls empty!");
        }
        int i = 0;
        while (i < decls.length) {
            IASTFileLocation loc = decls[i].getFileLocation();
            String filename = loc.getFileName();
            if (traceOn) {
                System.out.println("PldtAstVisitor found filename " + filename);
            }
            Path path = new Path(filename);
            if (traceOn) {
                System.out.println("PldtAstVisitor found path " + path);
            }
            if (this.isInIncludePath((IPath)path)) {
                if (traceOn) {
                    System.out.println("   path match! " + name + " is an artifact.");
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String chooseName(String bindingName, String rawSignature) {
        String name = bindingName;
        if (bindingName.length() == 0) {
            name = rawSignature;
        }
        return name;
    }

    public void processMacroLiteral(IASTLiteralExpression expression) {
        IASTNodeLocation[] locations = expression.getNodeLocations();
        if (locations.length == 1 && locations[0] instanceof IASTMacroExpansion) {
            SourceInfo sourceInfo;
            IASTMacroExpansion astMacroExpansion = (IASTMacroExpansion)locations[0];
            IASTPreprocessorMacroDefinition preprocessorMacroDefinition = astMacroExpansion.getMacroDefinition();
            String shortName = preprocessorMacroDefinition.getName().toString();
            IASTNodeLocation[] preprocessorLocations = preprocessorMacroDefinition.getNodeLocations();
            while (preprocessorLocations.length == 1 && preprocessorLocations[0] instanceof IASTMacroExpansion) {
                preprocessorLocations = ((IASTMacroExpansion)preprocessorLocations[0]).getMacroDefinition().getNodeLocations();
            }
            if (preprocessorLocations.length == 1 && this.isInIncludePath((IPath)new Path(preprocessorLocations[0].asFileLocation().getFileName())) && (sourceInfo = this.getSourceInfo(astMacroExpansion)) != null) {
                this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, shortName, ARTIFACT_CONSTANT, sourceInfo));
            }
        }
    }

    private boolean isInIncludePath(IPath includeFilePath) {
        if (includeFilePath == null) {
            return false;
        }
        for (String includeDir : this.includes_) {
            Path includePath = new Path(includeDir);
            if (traceOn) {
                System.out.println("PldtAstVisitor: is " + includeFilePath + " found in " + includeDir + "?");
            }
            if (!includePath.isPrefixOf(includeFilePath)) continue;
            return true;
        }
        return false;
    }

    private SourceInfo getSourceInfo(IASTExpression astExpr, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = astExpr.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
            } else if (locations[0] instanceof IASTMacroExpansion) {
                IASTMacroExpansion me = (IASTMacroExpansion)locations[0];
                astFileLocation = me.asFileLocation();
            }
            if (astFileLocation != null) {
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }

    private SourceInfo getSourceInfo(IASTMacroExpansion iASTMacroExpansion) {
        SourceInfo sourceInfo = null;
        IASTFileLocation iASTFileLocation = iASTMacroExpansion.asFileLocation();
        sourceInfo = new SourceInfo();
        sourceInfo.setStartingLine(iASTFileLocation.getStartingLineNumber());
        sourceInfo.setStart(iASTFileLocation.getNodeOffset());
        sourceInfo.setEnd(iASTFileLocation.getNodeOffset() + iASTFileLocation.getNodeLength());
        sourceInfo.setConstructType(2);
        return sourceInfo;
    }

    private boolean preprocessorIncluded(IASTNode astNode) {
        String tuFilePath;
        if (astNode.getFileLocation() == null) {
            return false;
        }
        String location = astNode.getFileLocation().getFileName();
        return !location.equals(tuFilePath = astNode.getTranslationUnit().getFilePath());
    }

    public void processIdExprAsLiteral(IASTIdExpression expression) {
        SourceInfo sourceInfo;
        IASTName name = expression.getName();
        if (this.isArtifact(name) && (sourceInfo = this.getSourceInfo((IASTExpression)expression, 2)) != null) {
            this.scanReturn.addArtifact(new Artifact(this.fileName, sourceInfo.getStartingLine(), 1, name.toString(), ARTIFACT_CONSTANT, sourceInfo));
        }
    }
}

