/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.toolopts;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.ToolApp;
import org.eclipse.ptp.perf.toolopts.ToolMaker;
import org.eclipse.ptp.perf.toolopts.ToolOption;
import org.eclipse.ptp.perf.toolopts.ToolPane;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToolParser
extends DefaultHandler {
    private static final String TOOLSET = "toolset";
    boolean oldParser = false;
    private static final String TOOL = "tool";
    private static final String COMPILE = "compile";
    private static final String CC = "cc";
    private static final String CXX = "cxx";
    private static final String F90 = "f90";
    private static final String ALLCOMP = "allcompilers";
    private static final String EXECUTE = "execute";
    private static final String UTILITY = "utility";
    private static final String ANALYZE = "analyze";
    private static final String PROCESS = "process";
    private static final String VIEW = "view";
    private static final String OPTIONPANE = "optionpane";
    private static final String TOGOPT = "togoption";
    private static final String LABEL = "label";
    private static final String TIP = "tooltip";
    private static final String NAME = "optname";
    private static final String VALUE = "optvalue";
    private static final String DEFAULT = "default";
    private static final String DEFSTATE = "defstate";
    private static final String REQUIRED = "required";
    private static final String VISIBLE = "visible";
    private static final String DISPLAYOPTIONS = "displayoptions";
    private static final String ENCLOSEVALS = "enclosevalues";
    private static final String ENCLOSEWITH = "enclosewith";
    private static final String SEPARATEWITH = "separatewith";
    private static final String PREPENDWITH = "prependwith";
    private static final String SEPARATEVAL = "separatevalues";
    private static final String ARGUMENT = "argument";
    private boolean inTool = false;
    private boolean inCompilation = false;
    private boolean inExecution = false;
    private boolean inAnalysis = false;
    private Stack<String> tagStack = new Stack();
    protected ArrayList<PerformanceTool> performanceTools = new ArrayList();
    private PerformanceTool currentTool;
    private ArrayList<ToolPane> toolPanes;
    private ToolPane currentPane;
    private ArrayList<ToolApp> toolApps;
    private ArrayList<String> currentArgs;
    private ToolApp currentApp;
    private ArrayList<ToolOption> toolOptions;
    private ToolOption actOpt;
    private Stack<StringBuffer> content = new Stack();
    private boolean inExecUtil = false;
    private boolean inAnaTool = false;

    public void characters(char[] chars, int start, int len) {
        this.content.peek().append(chars, start, len);
    }

    private static String getAttribute(String name, Attributes atts) {
        int repdex = atts.getIndex(name);
        if (repdex >= 0) {
            return atts.getValue(repdex);
        }
        return null;
    }

    private static boolean getBooleanAttribute(String name, boolean defValue, Attributes atts) {
        String boolAtt = ToolParser.getAttribute(name, atts);
        if (boolAtt == null) {
            return defValue;
        }
        if (boolAtt.toLowerCase().equals("true")) {
            return true;
        }
        if (boolAtt.toLowerCase().equals("false")) {
            return false;
        }
        return defValue;
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ((name = name.toLowerCase()).equals(TOOLSET)) {
            this.oldParser = true;
            this.parseOldStart(uri, localName, name, atts);
            return;
        }
        if (name.equals(TOOL)) {
            this.inTool = true;
            this.currentTool = new PerformanceTool();
            this.currentTool.toolID = this.currentTool.toolName = ToolParser.getAttribute("name", atts);
        } else if (name.equals(COMPILE)) {
            if (this.inTool && this.currentTool != null) {
                this.inCompilation = true;
                this.currentTool.recompile = true;
                this.currentTool.replaceCompiler = ToolParser.getBooleanAttribute("replace", false, atts);
            }
        } else if (name.equals(EXECUTE) && !this.inExecution) {
            this.inExecution = true;
            this.toolApps = new ArrayList();
        } else if (name.equals(ANALYZE) && !this.inAnalysis) {
            this.inAnalysis = true;
            this.toolApps = new ArrayList();
        } else if (name.equals(CC) || name.equals(CXX) || name.equals(F90) || name.equals(ALLCOMP) || name.equals(UTILITY)) {
            if (this.inTool && this.currentTool != null) {
                this.currentApp = new ToolApp();
                this.currentApp.toolCommand = ToolParser.getAttribute("command", atts);
                this.currentApp.toolID = ToolParser.getAttribute("id", atts);
                this.currentApp.toolGroup = ToolParser.getAttribute("group", atts);
                if (this.currentApp.toolGroup != null && this.currentApp.toolCommand != null) {
                    this.currentTool.groupApp.put(this.currentApp.toolGroup, this.currentApp.toolCommand);
                }
                if (this.inExecution) {
                    this.currentTool.prependExecution = true;
                }
            }
        } else if (name.equals(ARGUMENT)) {
            if (this.currentArgs == null) {
                this.currentArgs = new ArrayList();
            }
            this.currentArgs.add(ToolParser.getAttribute("value", atts));
        } else if (name.equals(OPTIONPANE)) {
            boolean virtual = ToolParser.getBooleanAttribute("virtual", false, atts);
            this.toolOptions = new ArrayList();
            this.currentPane = new ToolPane(virtual);
            this.currentPane.setName(ToolParser.getAttribute("title", atts));
            int optdex = atts.getIndex(PREPENDWITH);
            if (optdex >= 0) {
                this.currentPane.prependOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(ENCLOSEWITH)) >= 0) {
                this.currentPane.encloseOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(SEPARATEWITH)) >= 0) {
                this.currentPane.separateOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(ENCLOSEVALS)) >= 0) {
                this.currentPane.encloseValues = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(SEPARATEVAL)) >= 0) {
                this.currentPane.separateNameValue = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(DISPLAYOPTIONS)) >= 0) {
                String abool = atts.getValue(optdex);
                if ((abool = abool.toLowerCase()).equals("false")) {
                    this.currentPane.displayOptions = false;
                }
            }
        } else if (name.equals(TOGOPT)) {
            this.actOpt = new ToolOption();
            this.actOpt.optLabel = ToolParser.getAttribute(LABEL, atts);
            this.actOpt.optName = ToolParser.getAttribute(NAME, atts);
            this.actOpt.toolTip = ToolParser.getAttribute(TIP, atts);
            this.actOpt.defState = ToolParser.getBooleanAttribute(DEFSTATE, false, atts);
            this.actOpt.required = ToolParser.getBooleanAttribute(REQUIRED, false, atts);
            this.actOpt.visible = ToolParser.getBooleanAttribute(VISIBLE, true, atts);
        } else if (name.equals(VALUE) && this.actOpt != null && this.tagStack.peek().equals(TOGOPT)) {
            this.actOpt.useEquals = ToolParser.getBooleanAttribute("equals", true, atts);
            this.actOpt.defText = ToolParser.getAttribute(DEFAULT, atts);
            String type = ToolParser.getAttribute("type", atts);
            if (type != null) {
                if ((type = type.toLowerCase()).equals("text")) {
                    this.actOpt.type = 1;
                } else if (type.equals("dir")) {
                    this.actOpt.type = 2;
                } else if (type.equals("file")) {
                    this.actOpt.type = 3;
                } else if (type.equals("number")) {
                    this.actOpt.type = 5;
                } else if (type.equals("combo")) {
                    this.actOpt.type = 4;
                }
            }
        }
        this.tagStack.push(name.toLowerCase());
        this.content.push(new StringBuffer());
    }

    private ToolApp finishApp() {
        if (this.currentArgs != null && this.currentArgs.size() > 0) {
            this.currentApp.arguments = new String[this.currentArgs.size()];
            this.currentArgs.toArray(this.currentApp.arguments);
        }
        if (this.toolPanes != null && this.toolPanes.size() > 0) {
            this.currentApp.toolPanes = new ToolPane[this.toolPanes.size()];
            this.toolPanes.toArray(this.currentApp.toolPanes);
        }
        this.currentArgs = null;
        this.toolPanes = null;
        return this.currentApp;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        name = name.toLowerCase();
        if (this.oldParser) {
            this.parseOldEnd(uri, localName, name);
            return;
        }
        if (name.equals(TOOL)) {
            this.inTool = false;
            this.performanceTools.add(this.currentTool);
        } else if (name.equals(CC) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.ccCompiler = this.finishApp();
            }
        } else if (name.equals(CXX) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.cxxCompiler = this.finishApp();
            }
        } else if (name.equals(F90) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.f90Compiler = this.finishApp();
            }
        } else if (name.equals(ALLCOMP) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.allCompilers = this.finishApp();
            }
        } else if (name.equals(COMPILE)) {
            this.inCompilation = false;
        } else if (name.equals(EXECUTE) && this.inExecution) {
            this.currentTool.execUtils = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.currentTool.execUtils);
            this.inExecution = false;
        } else if (name.equals(UTILITY)) {
            this.toolApps.add(this.finishApp());
            this.currentApp = null;
        } else if (name.equals(ANALYZE) && this.inAnalysis) {
            this.currentTool.analysisCommands = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.currentTool.analysisCommands);
            this.inAnalysis = false;
        } else if (name.equals(OPTIONPANE)) {
            if (this.toolOptions != null) {
                if (this.toolPanes == null) {
                    this.toolPanes = new ArrayList();
                }
                this.currentPane.setOptions(this.toolOptions);
                this.toolPanes.add(this.currentPane);
            }
        } else if (name.equals(TOGOPT) && this.actOpt != null) {
            String panename = "";
            if (this.currentPane != null && this.currentPane.configID != null) {
                panename = this.currentPane.configID;
            }
            this.actOpt = ToolMaker.finishToolOption(this.actOpt, panename);
            if (this.actOpt != null) {
                this.toolOptions.add(this.actOpt);
            }
        }
        this.tagStack.pop();
        this.content.pop();
    }

    private ToolApp oldFinishApp() {
        if (this.currentArgs != null && this.currentArgs.size() > 0) {
            this.currentApp.arguments = new String[this.currentArgs.size()];
            this.currentArgs.toArray(this.currentApp.arguments);
        }
        if (this.toolPanes != null && this.toolPanes.size() > 0) {
            this.currentApp.toolPanes = new ToolPane[this.toolPanes.size()];
            this.toolPanes.toArray(this.currentApp.toolPanes);
        }
        this.currentArgs = null;
        this.toolPanes = null;
        this.currentApp.toolCommand = this.content.peek().toString().trim();
        return this.currentApp;
    }

    void parseOldStart(String uri, String localName, String name, Attributes atts) {
        int typedex;
        if ((name = name.toLowerCase()).equals(TOOL)) {
            this.inTool = true;
            this.currentTool = new PerformanceTool();
        } else if (name.equals(COMPILE)) {
            if (this.inTool && this.currentTool != null) {
                this.inCompilation = true;
                this.currentTool.recompile = true;
                int repdex = atts.getIndex("replace");
                if (repdex >= 0 && atts.getValue(repdex).toLowerCase().equals("true")) {
                    this.currentTool.replaceCompiler = true;
                }
            }
        } else if (name.equals(CC) || name.equals(CXX) || name.equals(F90) || name.equals(ALLCOMP)) {
            if (this.inCompilation && this.currentTool != null) {
                this.currentApp = new ToolApp();
            }
        } else if (name.equals(EXECUTE) && !this.inExecution) {
            this.inExecution = true;
            this.toolApps = new ArrayList();
        } else if (name.equals(UTILITY) && !this.inExecUtil) {
            this.inExecUtil = true;
            this.currentApp = new ToolApp();
        } else if (name.equals(ANALYZE) && !this.inAnalysis) {
            this.inAnalysis = true;
            this.toolApps = new ArrayList();
        } else if ((name.equals(PROCESS) || name.equals(VIEW)) && !this.inAnaTool) {
            this.inAnaTool = true;
            this.currentApp = new ToolApp();
        } else if (name.equals(ARGUMENT)) {
            this.currentArgs = new ArrayList();
        } else if (name.equals(OPTIONPANE)) {
            boolean virtual = false;
            int optdex = atts.getIndex("virtual");
            if (optdex >= 0 && atts.getValue(optdex).equals("true")) {
                virtual = true;
            }
            this.toolOptions = new ArrayList();
            this.currentPane = new ToolPane(virtual);
            optdex = atts.getIndex(PREPENDWITH);
            if (optdex >= 0) {
                this.currentPane.prependOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(ENCLOSEWITH)) >= 0) {
                this.currentPane.encloseOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(SEPARATEWITH)) >= 0) {
                this.currentPane.separateOpts = atts.getValue(optdex);
            }
        } else if (name.equals(TOGOPT)) {
            this.actOpt = new ToolOption();
            int defdex = atts.getIndex(DEFSTATE);
            if (defdex >= 0 && atts.getValue(defdex).toLowerCase().equals("on")) {
                this.actOpt.defState = true;
            }
        } else if (name.equals(NAME)) {
            String useeq;
            int eqdex;
            if (this.actOpt != null && this.tagStack.peek().equals(TOGOPT) && (eqdex = atts.getIndex("equals")) >= 0 && (useeq = atts.getValue(eqdex).toLowerCase()).equals("false")) {
                this.actOpt.useEquals = false;
            }
        } else if (name.equals(VALUE) && this.actOpt != null && this.tagStack.peek().equals(TOGOPT) && (typedex = atts.getIndex("type")) >= 0) {
            String type = atts.getValue(typedex).toLowerCase();
            if (type.equals("text")) {
                this.actOpt.type = 1;
            } else if (type.equals("dir")) {
                this.actOpt.type = 2;
            } else if (type.equals("file")) {
                this.actOpt.type = 3;
            } else if (type.equals("number")) {
                this.actOpt.type = 5;
            } else if (type.equals("combo")) {
                this.actOpt.type = 4;
            }
        }
        this.tagStack.push(name.toLowerCase());
        this.content.push(new StringBuffer());
    }

    void parseOldEnd(String uri, String localName, String name) {
        if ((name = name.toLowerCase()).equals(TOOL)) {
            this.currentTool.toolID = this.currentTool.toolName = this.content.peek().toString().trim();
            this.performanceTools.add(this.currentTool);
        } else if (name.equals(CC) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.ccCompiler = this.oldFinishApp();
            }
        } else if (name.equals(CXX) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.cxxCompiler = this.oldFinishApp();
            }
        } else if (name.equals(F90) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.f90Compiler = this.oldFinishApp();
            }
        } else if (name.equals(ALLCOMP) && this.inCompilation) {
            if (this.currentTool != null) {
                this.currentTool.allCompilers = this.oldFinishApp();
            }
        } else if (name.equals(COMPILE)) {
            this.inCompilation = false;
        } else if (name.equals(EXECUTE) && this.inExecution) {
            this.currentTool.execUtils = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.currentTool.execUtils);
            this.inExecution = false;
        } else if (name.equals(UTILITY) && this.inExecUtil) {
            this.inExecUtil = false;
            this.toolApps.add(this.oldFinishApp());
            this.currentTool.prependExecution = true;
            this.currentApp = null;
        } else if ((name.equals(PROCESS) || name.equals(VIEW)) && this.inAnaTool) {
            this.inAnaTool = false;
            this.toolApps.add(this.oldFinishApp());
            this.currentApp = null;
        } else if (name.equals(ANALYZE) && this.inAnalysis) {
            this.currentTool.analysisCommands = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.currentTool.analysisCommands);
            this.inAnalysis = false;
        } else if (name.equals(ARGUMENT)) {
            this.currentArgs.add(this.content.peek().toString().trim());
        } else if (name.equals(OPTIONPANE)) {
            if (this.toolOptions != null) {
                if (this.toolPanes == null) {
                    this.toolPanes = new ArrayList();
                }
                this.currentPane.setName(this.content.peek().toString().trim());
                this.currentPane.setOptions(this.toolOptions);
                this.toolPanes.add(this.currentPane);
            }
        } else if (name.equals(TOGOPT)) {
            if (this.actOpt != null) {
                this.actOpt = ToolMaker.finishToolOption(this.actOpt, "");
                this.toolOptions.add(this.actOpt);
            }
        } else if (name.equals(TIP)) {
            if (this.actOpt != null) {
                this.actOpt.toolTip = this.content.peek().toString().trim();
            }
        } else if (name.equals(LABEL)) {
            if (this.actOpt != null) {
                this.actOpt.optLabel = this.content.peek().toString().trim();
            }
        } else if (name.equals(NAME)) {
            if (this.actOpt != null) {
                this.actOpt.optName = this.content.peek().toString().trim();
            }
        } else if (name.equals(DEFAULT) && this.actOpt != null) {
            this.actOpt.optLabel = this.content.peek().toString().trim();
        }
        this.tagStack.pop();
        this.content.pop();
    }
}

