/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PElementPropertySource
implements IPropertySource {
    private final IPElement pelement;
    private final List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();

    public PElementPropertySource(IPElement pelement) {
        this.pelement = pelement;
        IAttributeDefinition[] attrDefs = pelement.getAttributeKeys();
        String[] keys = new String[attrDefs.length];
        int i = 0;
        while (i < attrDefs.length) {
            if (attrDefs[i].getDisplay()) {
                keys[i] = attrDefs[i].getId();
                this.addDescriptor(new PropertyDescriptor((Object)keys[i], attrDefs[i].getName()));
            }
            ++i;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        IAttribute attribute = this.pelement.getAttribute(id.toString());
        if (attribute != null) {
            return attribute.getValueAsString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    protected void addDescriptor(PropertyDescriptor desc) {
        this.descriptors.add(desc);
    }
}

