/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class OutputConsole
extends MessageConsole {
    private InputStream inputStream = null;
    private MessageConsoleStream messageOutputStream = null;
    private Thread thread = null;
    private static final int BUFFER_SIZE = 8192;
    private boolean isKilled = false;

    public OutputConsole(String name, InputStream inputStream) {
        this(name, null, inputStream);
    }

    public OutputConsole(String name, ImageDescriptor imageDescriptor, InputStream inputStream) {
        super(name, imageDescriptor);
        this.inputStream = inputStream;
        this.messageOutputStream = this.newMessageStream();
        this.startMonitorOutput();
    }

    protected void startMonitorOutput() {
        if (this.thread == null) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this});
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        OutputConsole.this.read();
                    }
                    catch (IOException iOException) {
                        OutputConsole.this.kill();
                    }
                }
            };
            this.thread = new Thread(runnable, "Output Console Monitor");
            this.thread.start();
        }
    }

    private void close() throws IOException {
        if (this.thread != null) {
            try {
                this.closeStream();
                this.messageOutputStream.close();
                this.thread.interrupt();
            }
            catch (Throwable throwable) {
                this.thread = null;
                this.isKilled = true;
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
                throw throwable;
            }
            this.thread = null;
            this.isKilled = true;
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    private void appendText(String text) {
        this.messageOutputStream.print(text);
    }

    public void kill() {
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeStream() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
            this.isKilled = true;
        }
    }

    private void read() throws IOException {
        byte[] bytes = new byte[8192];
        int read = 0;
        while (read >= 0) {
            try {
                if (this.isKilled) break;
                read = this.inputStream.read(bytes);
                if (read <= 0) continue;
                this.appendText(new String(bytes, 0, read));
            }
            catch (NullPointerException nullPointerException) {
                break;
            }
        }
        this.closeStream();
    }
}

