/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.ui.listeners.ISetListener;
import org.eclipse.ptp.ui.model.ElementSet;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public abstract class AbstractUIManager
implements IManager {
    protected IModelPresentation modelPresentation = null;
    protected String cur_set_id = "";
    protected ListenerList setListeners = new ListenerList();
    protected ListenerList jListeners = new ListenerList();

    public AbstractUIManager() {
        this.modelPresentation = PTPCorePlugin.getDefault().getModelPresentation();
    }

    public void addJobChangedListener(IJobChangedListener jobListener) {
        this.jListeners.add((Object)jobListener);
    }

    public void addSetListener(ISetListener setListener) {
        this.setListeners.add((Object)setListener);
    }

    public void addToSet(IElement[] elements, IElementSet set) {
        set.addElements(elements);
    }

    public void addToSet(IElement[] elements, String setID, IElementHandler elementHandler) {
        IElementSet set = (IElementSet)elementHandler.getElementByID(setID);
        this.addToSet(elements, set);
        this.fireSetEvent(3, elements, set, null);
    }

    public String createSet(IElement[] elements, String setID, String setName, IElementHandler elementHandler) {
        ElementSet set = new ElementSet(elementHandler, setID, setName);
        this.addToSet(elements, set);
        elementHandler.addElements(new IElement[]{set});
        this.fireSetEvent(0, elements, set, null);
        return set.getID();
    }

    public void fireJobChangedEvent(final int type, final String cur_job_id, final String pre_job_id) {
        Object[] array = this.jListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IJobChangedListener listener = (IJobChangedListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.jobChangedEvent(type, cur_job_id, pre_job_id);
                }
            });
            ++i;
        }
    }

    public void fireSetEvent(final int eventType, final IElement[] elements, final IElementSet cur_set, final IElementSet pre_set) {
        Object[] array = this.setListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ISetListener setListener = (ISetListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    switch (eventType) {
                        case 0: {
                            setListener.createSetEvent(cur_set, elements);
                            break;
                        }
                        case 1: {
                            setListener.deleteSetEvent(cur_set);
                            break;
                        }
                        case 2: {
                            setListener.changeSetEvent(cur_set, pre_set);
                            break;
                        }
                        case 3: {
                            setListener.addElementsEvent(cur_set, elements);
                            break;
                        }
                        case 4: {
                            setListener.removeElementsEvent(cur_set, elements);
                        }
                    }
                }
            });
            ++i;
        }
    }

    public IResourceManager[] getResourceManagers() {
        IPUniverse universe = this.modelPresentation.getUniverse();
        if (universe == null) {
            return new IResourceManager[0];
        }
        return universe.getResourceManagers();
    }

    public int getStatus(IElement element, int index) {
        return this.getStatus(element.getID());
    }

    public void removeFromSet(IElement[] elements, String setID, IElementHandler elementHandler) {
        IElementSet set = (IElementSet)elementHandler.getElementByID(setID);
        set.removeElements(elements);
        this.fireSetEvent(4, elements, set, null);
        if (set.size() == 0) {
            this.removeSet(setID, elementHandler);
        }
    }

    public void removeJobChangedListener(IJobChangedListener jobListener) {
        this.jListeners.remove((Object)jobListener);
    }

    public void removeSet(String setID, IElementHandler elementHandler) {
        IElementSet set = (IElementSet)elementHandler.getElementByID(setID);
        elementHandler.removeElements(new IElement[]{set});
        this.fireSetEvent(1, null, set, null);
    }

    public void removeSetListener(ISetListener setListener) {
        this.setListeners.remove((Object)setListener);
    }

    public void shutdown() {
        this.setListeners.clear();
        this.jListeners.clear();
    }
}

